/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.springframework.security.endpoint;

import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.PublicKeyCredentialRequestOptions;
import com.webauthn4j.springframework.security.endpoint.AbstractOptionsEndpointFilter;
import com.webauthn4j.springframework.security.options.AssertionOptionsProvider;
import java.io.IOException;
import java.io.Serializable;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.springframework.security.web.FilterInvocation;

public class AssertionOptionsEndpointFilter
extends AbstractOptionsEndpointFilter {
    public static final String FILTER_URL = "/webauthn/assertion/options";
    private final AssertionOptionsProvider assertionOptionsProvider;

    public AssertionOptionsEndpointFilter(AssertionOptionsProvider assertionOptionsProvider, ObjectConverter objectConverter) {
        super(objectConverter);
        this.assertionOptionsProvider = assertionOptionsProvider;
        this.setFilterProcessesUrl(FILTER_URL);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        FilterInvocation fi = new FilterInvocation(request, response, chain);
        if (!this.processFilter(fi.getRequest())) {
            chain.doFilter(request, response);
            return;
        }
        try {
            PublicKeyCredentialRequestOptions assertionOptions = this.assertionOptionsProvider.getAssertionOptions(fi.getRequest(), this.getAuthentication());
            this.writeResponse(fi.getResponse(), (Serializable)assertionOptions);
        }
        catch (RuntimeException e) {
            this.logger.debug((Object)e);
            this.writeErrorResponse(fi.getResponse(), e);
        }
    }
}

