/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.springframework.security;

import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.springframework.security.UserVerificationStrategy;
import com.webauthn4j.springframework.security.WebAuthnAssertionAuthenticationToken;
import com.webauthn4j.springframework.security.WebAuthnAuthenticationParameters;
import com.webauthn4j.springframework.security.WebAuthnAuthenticationRequest;
import com.webauthn4j.springframework.security.server.ServerPropertyProvider;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.util.Assert;
import org.springframework.util.Base64Utils;
import org.springframework.util.StringUtils;

public class WebAuthnProcessingFilter
extends UsernamePasswordAuthenticationFilter {
    public static final String SPRING_SECURITY_FORM_CREDENTIAL_ID_KEY = "credentialId";
    public static final String SPRING_SECURITY_FORM_CLIENT_DATA_JSON_KEY = "clientDataJSON";
    public static final String SPRING_SECURITY_FORM_AUTHENTICATOR_DATA_KEY = "authenticatorData";
    public static final String SPRING_SECURITY_FORM_SIGNATURE_KEY = "signature";
    public static final String SPRING_SECURITY_FORM_CLIENT_EXTENSIONS_JSON_KEY = "clientExtensionsJSON";
    private final List<GrantedAuthority> authorities;
    private String credentialIdParameter = "credentialId";
    private String clientDataJSONParameter = "clientDataJSON";
    private String authenticatorDataParameter = "authenticatorData";
    private String signatureParameter = "signature";
    private String clientExtensionsJSONParameter = "clientExtensionsJSON";
    private ServerPropertyProvider serverPropertyProvider;
    private UserVerificationStrategy userVerificationStrategy = new DefaultUserVerificationStrategy();
    private AuthenticationTrustResolver trustResolver = new AuthenticationTrustResolverImpl();
    private boolean postOnly = true;

    public WebAuthnProcessingFilter() {
        this.authorities = AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_ANONYMOUS"});
        this.serverPropertyProvider = null;
    }

    public WebAuthnProcessingFilter(List<GrantedAuthority> authorities, ServerPropertyProvider serverPropertyProvider) {
        Assert.notNull(authorities, (String)"authorities must not be null");
        Assert.notNull((Object)serverPropertyProvider, (String)"serverPropertyProvider must not be null");
        this.authorities = authorities;
        this.serverPropertyProvider = serverPropertyProvider;
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) {
        if (this.postOnly && !HttpMethod.POST.matches(request.getMethod())) {
            throw new AuthenticationServiceException("Authentication method not supported: " + request.getMethod());
        }
        String credentialId = this.obtainCredentialId(request);
        if (StringUtils.isEmpty((Object)credentialId)) {
            String username = this.obtainUsername(request);
            String password = this.obtainPassword(request);
            if (username == null) {
                username = "";
            }
            if (password == null) {
                password = "";
            }
            username = username.trim();
            UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
            this.setDetails(request, authRequest);
            return this.getAuthenticationManager().authenticate((Authentication)authRequest);
        }
        String clientDataJSON = this.obtainClientDataJSON(request);
        String authenticatorData = this.obtainAuthenticatorData(request);
        String signature = this.obtainSignatureData(request);
        String clientExtensionsJSON = this.obtainClientExtensionsJSON(request);
        byte[] rawId = Base64Utils.decodeFromUrlSafeString((String)credentialId);
        byte[] rawClientData = Base64Utils.decodeFromUrlSafeString((String)clientDataJSON);
        byte[] rawAuthenticatorData = Base64Utils.decodeFromUrlSafeString((String)authenticatorData);
        byte[] signatureBytes = Base64Utils.decodeFromUrlSafeString((String)signature);
        ServerProperty serverProperty = this.serverPropertyProvider.provide(request);
        WebAuthnAuthenticationRequest webAuthnAuthenticationRequest = new WebAuthnAuthenticationRequest(rawId, rawClientData, rawAuthenticatorData, signatureBytes, clientExtensionsJSON);
        WebAuthnAuthenticationParameters webAuthnAuthenticationParameters = new WebAuthnAuthenticationParameters(serverProperty, this.userVerificationStrategy.isUserVerificationRequired(), true);
        WebAuthnAssertionAuthenticationToken authenticationToken = new WebAuthnAssertionAuthenticationToken(webAuthnAuthenticationRequest, webAuthnAuthenticationParameters, this.authorities);
        this.setDetails(request, authenticationToken);
        return this.getAuthenticationManager().authenticate((Authentication)authenticationToken);
    }

    public void setPostOnly(boolean postOnly) {
        this.postOnly = postOnly;
    }

    public String getCredentialIdParameter() {
        return this.credentialIdParameter;
    }

    public void setCredentialIdParameter(String credentialIdParameter) {
        Assert.hasText((String)credentialIdParameter, (String)"credentialId parameter must not be empty or null");
        this.credentialIdParameter = credentialIdParameter;
    }

    public String getClientDataJSONParameter() {
        return this.clientDataJSONParameter;
    }

    public void setClientDataJSONParameter(String clientDataJSONParameter) {
        Assert.hasText((String)clientDataJSONParameter, (String)"clientDataJSON parameter must not be empty or null");
        this.clientDataJSONParameter = clientDataJSONParameter;
    }

    public String getAuthenticatorDataParameter() {
        return this.authenticatorDataParameter;
    }

    public void setAuthenticatorDataParameter(String authenticatorDataParameter) {
        Assert.hasText((String)authenticatorDataParameter, (String)"authenticatorData parameter must not be empty or null");
        this.authenticatorDataParameter = authenticatorDataParameter;
    }

    public String getSignatureParameter() {
        return this.signatureParameter;
    }

    public void setSignatureParameter(String signatureParameter) {
        Assert.hasText((String)signatureParameter, (String)"signature parameter must not be empty or null");
        this.signatureParameter = signatureParameter;
    }

    public String getClientExtensionsJSONParameter() {
        return this.clientExtensionsJSONParameter;
    }

    public void setClientExtensionsJSONParameter(String clientExtensionsJSONParameter) {
        Assert.hasText((String)clientExtensionsJSONParameter, (String)"clientExtensionsJSON parameter must not be empty or null");
        this.clientExtensionsJSONParameter = clientExtensionsJSONParameter;
    }

    public ServerPropertyProvider getServerPropertyProvider() {
        return this.serverPropertyProvider;
    }

    public void setServerPropertyProvider(ServerPropertyProvider serverPropertyProvider) {
        this.serverPropertyProvider = serverPropertyProvider;
    }

    protected void setDetails(HttpServletRequest request, AbstractAuthenticationToken authRequest) {
        authRequest.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
    }

    private String obtainClientDataJSON(HttpServletRequest request) {
        return request.getParameter(this.clientDataJSONParameter);
    }

    private String obtainCredentialId(HttpServletRequest request) {
        return request.getParameter(this.credentialIdParameter);
    }

    private String obtainAuthenticatorData(HttpServletRequest request) {
        return request.getParameter(this.authenticatorDataParameter);
    }

    private String obtainSignatureData(HttpServletRequest request) {
        return request.getParameter(this.signatureParameter);
    }

    private String obtainClientExtensionsJSON(HttpServletRequest request) {
        return request.getParameter(this.clientExtensionsJSONParameter);
    }

    private class DefaultUserVerificationStrategy
    implements UserVerificationStrategy {
        private DefaultUserVerificationStrategy() {
        }

        @Override
        public boolean isUserVerificationRequired() {
            Authentication currentAuthentication = SecurityContextHolder.getContext().getAuthentication();
            if (currentAuthentication == null) {
                return true;
            }
            if (WebAuthnProcessingFilter.this.trustResolver.isAnonymous(currentAuthentication)) {
                return true;
            }
            return !currentAuthentication.isAuthenticated();
        }
    }
}

