/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.springframework.security;

import com.webauthn4j.springframework.security.UserVerificationStrategy;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class DefaultUserVerificationStrategy
implements UserVerificationStrategy {
    private AuthenticationTrustResolver trustResolver;

    public DefaultUserVerificationStrategy(AuthenticationTrustResolver trustResolver) {
        this.trustResolver = trustResolver;
    }

    public DefaultUserVerificationStrategy() {
        this((AuthenticationTrustResolver)new AuthenticationTrustResolverImpl());
    }

    @Override
    public boolean isUserVerificationRequired() {
        Authentication currentAuthentication = SecurityContextHolder.getContext().getAuthentication();
        if (currentAuthentication == null) {
            return true;
        }
        if (this.trustResolver.isAnonymous(currentAuthentication)) {
            return true;
        }
        return !currentAuthentication.isAuthenticated();
    }

    public AuthenticationTrustResolver getTrustResolver() {
        return this.trustResolver;
    }

    public void setTrustResolver(AuthenticationTrustResolver trustResolver) {
        this.trustResolver = trustResolver;
    }
}

