/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.springframework.security;

import com.webauthn4j.WebAuthnManager;
import com.webauthn4j.data.RegistrationData;
import com.webauthn4j.data.RegistrationParameters;
import com.webauthn4j.data.RegistrationRequest;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.data.extension.client.RegistrationExtensionClientOutput;
import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.springframework.security.WebAuthnRegistrationRequestValidationResponse;
import com.webauthn4j.springframework.security.server.ServerPropertyProvider;
import com.webauthn4j.springframework.security.util.internal.ExceptionUtil;
import com.webauthn4j.util.Base64UrlUtil;
import com.webauthn4j.util.exception.WebAuthnException;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.Assert;

public class WebAuthnRegistrationRequestValidator {
    private final WebAuthnManager webAuthnManager;
    private final ServerPropertyProvider serverPropertyProvider;

    public WebAuthnRegistrationRequestValidator(WebAuthnManager webAuthnManager, ServerPropertyProvider serverPropertyProvider) {
        Assert.notNull((Object)webAuthnManager, (String)"webAuthnManager must not be null");
        Assert.notNull((Object)serverPropertyProvider, (String)"serverPropertyProvider must not be null");
        this.webAuthnManager = webAuthnManager;
        this.serverPropertyProvider = serverPropertyProvider;
    }

    public WebAuthnRegistrationRequestValidationResponse validate(HttpServletRequest httpServletRequest, String clientDataBase64url, String attestationObjectBase64url, Set<String> transports, String clientExtensionsJSON) {
        Assert.notNull((Object)httpServletRequest, (String)"httpServletRequest must not be null");
        Assert.hasText((String)clientDataBase64url, (String)"clientDataBase64url must have text");
        Assert.hasText((String)attestationObjectBase64url, (String)"attestationObjectBase64url must have text");
        if (transports != null) {
            transports.forEach(transport -> Assert.hasText((String)transport, (String)"each transport must have text"));
        }
        RegistrationRequest webAuthnRegistrationRequest = this.createRegistrationRequest(clientDataBase64url, attestationObjectBase64url, transports, clientExtensionsJSON);
        RegistrationParameters webAuthnRegistrationParameters = this.createRegistrationParameters(httpServletRequest);
        try {
            RegistrationData response = this.webAuthnManager.validate(webAuthnRegistrationRequest, webAuthnRegistrationParameters);
            return new WebAuthnRegistrationRequestValidationResponse(response.getCollectedClientData(), response.getAttestationObject(), (AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput>)response.getClientExtensions(), response.getTransports());
        }
        catch (WebAuthnException e) {
            throw ExceptionUtil.wrapWithAuthenticationException(e);
        }
    }

    RegistrationRequest createRegistrationRequest(String clientDataBase64, String attestationObjectBase64, Set<String> transports, String clientExtensionsJSON) {
        byte[] clientDataBytes = Base64UrlUtil.decode((String)clientDataBase64);
        byte[] attestationObjectBytes = Base64UrlUtil.decode((String)attestationObjectBase64);
        return new RegistrationRequest(attestationObjectBytes, clientDataBytes, clientExtensionsJSON, transports);
    }

    RegistrationParameters createRegistrationParameters(HttpServletRequest request) {
        ServerProperty serverProperty = this.serverPropertyProvider.provide(request);
        return new RegistrationParameters(serverProperty, null, false, false);
    }
}

