/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.springframework.security.anchor;

import com.webauthn4j.anchor.CachingTrustAnchorsProviderBase;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.CertificateUtil;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class KeyStoreResourceTrustAnchorProvider
extends CachingTrustAnchorsProviderBase
implements InitializingBean {
    private Resource keyStore;
    private String password;

    public KeyStoreResourceTrustAnchorProvider() {
    }

    public KeyStoreResourceTrustAnchorProvider(Resource keyStore) {
        this.keyStore = keyStore;
    }

    public void afterPropertiesSet() {
        this.checkConfig();
    }

    private void checkConfig() {
        AssertUtil.notNull((Object)this.keyStore, (String)"keyStore must not be null");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<AAGUID, Set<TrustAnchor>> loadTrustAnchors() {
        this.checkConfig();
        Resource keystore = this.getKeyStore();
        try (InputStream inputStream = keystore.getInputStream();){
            KeyStore keyStoreObject = this.loadKeyStoreFromStream(inputStream, this.getPassword());
            ArrayList<String> aliases = Collections.list(keyStoreObject.aliases());
            HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
            for (String alias : aliases) {
                X509Certificate certificate = (X509Certificate)keyStoreObject.getCertificate(alias);
                trustAnchors.add(new TrustAnchor(certificate, null));
            }
            Map map = Collections.singletonMap(null, trustAnchors);
            return map;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new com.webauthn4j.anchor.KeyStoreException("Failed to load TrustAnchor from keystore", (Throwable)e);
        }
    }

    public Resource getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(Resource keyStore) {
        this.keyStore = keyStore;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    private KeyStore loadKeyStoreFromStream(InputStream inputStream, String password) throws CertificateException, NoSuchAlgorithmException, IOException {
        KeyStore keyStoreObject = CertificateUtil.createKeyStore();
        keyStoreObject.load(inputStream, password.toCharArray());
        return keyStoreObject;
    }
}

