/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.springframework.security.config.configurers;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.metadata.converter.jackson.WebAuthnMetadataJSONModule;
import com.webauthn4j.springframework.security.DefaultUserVerificationStrategy;
import com.webauthn4j.springframework.security.UserVerificationStrategy;
import com.webauthn4j.springframework.security.authenticator.WebAuthnAuthenticatorService;
import com.webauthn4j.springframework.security.challenge.ChallengeRepository;
import com.webauthn4j.springframework.security.challenge.HttpSessionChallengeRepository;
import com.webauthn4j.springframework.security.converter.jackson.WebAuthn4JSpringSecurityJSONModule;
import com.webauthn4j.springframework.security.endpoint.AssertionOptionsEndpointFilter;
import com.webauthn4j.springframework.security.endpoint.AttestationOptionsEndpointFilter;
import com.webauthn4j.springframework.security.options.AssertionOptionsProvider;
import com.webauthn4j.springframework.security.options.AssertionOptionsProviderImpl;
import com.webauthn4j.springframework.security.options.AttestationOptionsProvider;
import com.webauthn4j.springframework.security.options.AttestationOptionsProviderImpl;
import com.webauthn4j.springframework.security.options.RpIdProvider;
import com.webauthn4j.springframework.security.server.ServerPropertyProvider;
import com.webauthn4j.springframework.security.server.ServerPropertyProviderImpl;
import org.springframework.context.ApplicationContext;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;

class WebAuthnConfigurerUtil {
    private WebAuthnConfigurerUtil() {
    }

    static <H extends HttpSecurityBuilder<H>> ChallengeRepository getChallengeRepositoryOrCreateNew(H http) {
        ChallengeRepository challengeRepository = (ChallengeRepository)http.getSharedObject(ChallengeRepository.class);
        if (challengeRepository != null) {
            return challengeRepository;
        }
        ApplicationContext applicationContext = (ApplicationContext)http.getSharedObject(ApplicationContext.class);
        String[] beanNames = applicationContext.getBeanNamesForType(ChallengeRepository.class);
        if (beanNames.length == 0) {
            return new HttpSessionChallengeRepository();
        }
        return (ChallengeRepository)applicationContext.getBean(ChallengeRepository.class);
    }

    static <H extends HttpSecurityBuilder<H>> WebAuthnAuthenticatorService getWebAuthnAuthenticatorServiceOrThrowException(H http) {
        WebAuthnAuthenticatorService webAuthnAuthenticatorService = (WebAuthnAuthenticatorService)http.getSharedObject(WebAuthnAuthenticatorService.class);
        if (webAuthnAuthenticatorService != null) {
            return webAuthnAuthenticatorService;
        }
        ApplicationContext applicationContext = (ApplicationContext)http.getSharedObject(ApplicationContext.class);
        return (WebAuthnAuthenticatorService)applicationContext.getBean(WebAuthnAuthenticatorService.class);
    }

    static <H extends HttpSecurityBuilder<H>> RpIdProvider getRpIdProviderOrNull(H http) {
        RpIdProvider rpIdProvider = (RpIdProvider)http.getSharedObject(RpIdProvider.class);
        if (rpIdProvider != null) {
            return rpIdProvider;
        }
        ApplicationContext applicationContext = (ApplicationContext)http.getSharedObject(ApplicationContext.class);
        String[] beanNames = applicationContext.getBeanNamesForType(RpIdProvider.class);
        rpIdProvider = beanNames.length == 0 ? null : (RpIdProvider)applicationContext.getBean(RpIdProvider.class);
        http.setSharedObject(RpIdProvider.class, (Object)rpIdProvider);
        return rpIdProvider;
    }

    static <H extends HttpSecurityBuilder<H>> AttestationOptionsProvider getAttestationOptionsProviderOrCreateNew(H http) {
        AttestationOptionsProvider optionsProvider = (AttestationOptionsProvider)http.getSharedObject(AttestationOptionsProvider.class);
        if (optionsProvider != null) {
            return optionsProvider;
        }
        ApplicationContext applicationContext = (ApplicationContext)http.getSharedObject(ApplicationContext.class);
        String[] beanNames = applicationContext.getBeanNamesForType(AttestationOptionsProvider.class);
        AttestationOptionsProvider attestationOptionsProvider = beanNames.length == 0 ? new AttestationOptionsProviderImpl(WebAuthnConfigurerUtil.getRpIdProviderOrNull(http), WebAuthnConfigurerUtil.getWebAuthnAuthenticatorServiceOrThrowException(http), WebAuthnConfigurerUtil.getChallengeRepositoryOrCreateNew(http)) : (AttestationOptionsProvider)applicationContext.getBean(AttestationOptionsProvider.class);
        http.setSharedObject(AttestationOptionsProvider.class, (Object)attestationOptionsProvider);
        return attestationOptionsProvider;
    }

    static <H extends HttpSecurityBuilder<H>> AssertionOptionsProvider getAssertionOptionsProviderOrCreateNew(H http) {
        AssertionOptionsProvider optionsProvider = (AssertionOptionsProvider)http.getSharedObject(AssertionOptionsProvider.class);
        if (optionsProvider != null) {
            return optionsProvider;
        }
        ApplicationContext applicationContext = (ApplicationContext)http.getSharedObject(ApplicationContext.class);
        String[] beanNames = applicationContext.getBeanNamesForType(AssertionOptionsProvider.class);
        if (beanNames.length == 0) {
            return new AssertionOptionsProviderImpl(WebAuthnConfigurerUtil.getRpIdProviderOrNull(http), WebAuthnConfigurerUtil.getWebAuthnAuthenticatorServiceOrThrowException(http), WebAuthnConfigurerUtil.getChallengeRepositoryOrCreateNew(http));
        }
        return (AssertionOptionsProvider)applicationContext.getBean(AssertionOptionsProvider.class);
    }

    public static <H extends HttpSecurityBuilder<H>> ObjectConverter getObjectConverterOrCreateNew(H http) {
        ObjectConverter objectConverter = (ObjectConverter)http.getSharedObject(ObjectConverter.class);
        if (objectConverter != null) {
            return objectConverter;
        }
        ApplicationContext applicationContext = (ApplicationContext)http.getSharedObject(ApplicationContext.class);
        String[] beanNames = applicationContext.getBeanNamesForType(ObjectConverter.class);
        if (beanNames.length == 0) {
            ObjectMapper jsonMapper = new ObjectMapper();
            jsonMapper.registerModule((Module)new WebAuthnMetadataJSONModule());
            jsonMapper.registerModule((Module)new WebAuthn4JSpringSecurityJSONModule());
            ObjectMapper cborMapper = new ObjectMapper((JsonFactory)new CBORFactory());
            return new ObjectConverter(jsonMapper, cborMapper);
        }
        return (ObjectConverter)applicationContext.getBean(ObjectConverter.class);
    }

    static <H extends HttpSecurityBuilder<H>> ServerPropertyProvider getServerPropertyProviderOrCreateNew(H http) {
        ServerPropertyProvider serverPropertyProvider = (ServerPropertyProvider)http.getSharedObject(ServerPropertyProvider.class);
        if (serverPropertyProvider != null) {
            return serverPropertyProvider;
        }
        ApplicationContext applicationContext = (ApplicationContext)http.getSharedObject(ApplicationContext.class);
        String[] beanNames = applicationContext.getBeanNamesForType(ServerPropertyProvider.class);
        if (beanNames.length == 0) {
            return new ServerPropertyProviderImpl(WebAuthnConfigurerUtil.getChallengeRepositoryOrCreateNew(http));
        }
        return (ServerPropertyProvider)applicationContext.getBean(ServerPropertyProvider.class);
    }

    public static <H extends HttpSecurityBuilder<H>> UserVerificationStrategy getUserVerificationStrategyOrCreateNew(H http) {
        UserVerificationStrategy userVerificationStrategy = (UserVerificationStrategy)http.getSharedObject(UserVerificationStrategy.class);
        if (userVerificationStrategy != null) {
            return userVerificationStrategy;
        }
        ApplicationContext applicationContext = (ApplicationContext)http.getSharedObject(ApplicationContext.class);
        String[] beanNames = applicationContext.getBeanNamesForType(UserVerificationStrategy.class);
        if (beanNames.length == 0) {
            return new DefaultUserVerificationStrategy(WebAuthnConfigurerUtil.getAuthenticationTrustResolverOrCreateNew(http));
        }
        return (UserVerificationStrategy)applicationContext.getBean(UserVerificationStrategy.class);
    }

    public static <H extends HttpSecurityBuilder<H>> AuthenticationTrustResolver getAuthenticationTrustResolverOrCreateNew(H http) {
        AuthenticationTrustResolver authenticationTrustResolver = (AuthenticationTrustResolver)http.getSharedObject(AuthenticationTrustResolver.class);
        if (authenticationTrustResolver != null) {
            return authenticationTrustResolver;
        }
        ApplicationContext applicationContext = (ApplicationContext)http.getSharedObject(ApplicationContext.class);
        String[] beanNames = applicationContext.getBeanNamesForType(AuthenticationTrustResolver.class);
        if (beanNames.length == 0) {
            return new AuthenticationTrustResolverImpl();
        }
        return (AuthenticationTrustResolver)applicationContext.getBean(AuthenticationTrustResolver.class);
    }

    public static <H extends HttpSecurityBuilder<H>> AttestationOptionsEndpointFilter getAttestationOptionsEndpointFilterOrCreateNew(H http) {
        AttestationOptionsEndpointFilter attestationOptionsEndpointFilter = (AttestationOptionsEndpointFilter)((Object)http.getSharedObject(AttestationOptionsEndpointFilter.class));
        if (attestationOptionsEndpointFilter != null) {
            return attestationOptionsEndpointFilter;
        }
        ApplicationContext applicationContext = (ApplicationContext)http.getSharedObject(ApplicationContext.class);
        String[] beanNames = applicationContext.getBeanNamesForType(AttestationOptionsEndpointFilter.class);
        if (beanNames.length == 0) {
            return new AttestationOptionsEndpointFilter(WebAuthnConfigurerUtil.getAttestationOptionsProviderOrCreateNew(http), WebAuthnConfigurerUtil.getObjectConverterOrCreateNew(http));
        }
        return (AttestationOptionsEndpointFilter)((Object)applicationContext.getBean(AttestationOptionsEndpointFilter.class));
    }

    public static <H extends HttpSecurityBuilder<H>> AssertionOptionsEndpointFilter getAssertionOptionsEndpointFilterOrCreateNew(H http) {
        AssertionOptionsEndpointFilter assertionOptionsEndpointFilter = (AssertionOptionsEndpointFilter)((Object)http.getSharedObject(AssertionOptionsEndpointFilter.class));
        if (assertionOptionsEndpointFilter != null) {
            return assertionOptionsEndpointFilter;
        }
        ApplicationContext applicationContext = (ApplicationContext)http.getSharedObject(ApplicationContext.class);
        String[] beanNames = applicationContext.getBeanNamesForType(AssertionOptionsEndpointFilter.class);
        if (beanNames.length == 0) {
            return new AssertionOptionsEndpointFilter(WebAuthnConfigurerUtil.getAssertionOptionsProviderOrCreateNew(http), WebAuthnConfigurerUtil.getObjectConverterOrCreateNew(http));
        }
        return (AssertionOptionsEndpointFilter)((Object)applicationContext.getBean(AssertionOptionsEndpointFilter.class));
    }
}

