/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.springframework.security.endpoint;

import com.webauthn4j.converter.util.JsonConverter;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.springframework.security.endpoint.ErrorResponse;
import java.io.IOException;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.SpringSecurityMessageSource;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.Assert;
import org.springframework.web.filter.GenericFilterBean;

public abstract class AbstractOptionsEndpointFilter
extends GenericFilterBean {
    private String filterProcessesUrl;
    protected MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();
    protected JsonConverter jsonConverter;
    private AuthenticationTrustResolver trustResolver;

    protected AbstractOptionsEndpointFilter(ObjectConverter objectConverter) {
        this.jsonConverter = objectConverter.getJsonConverter();
        this.trustResolver = new AuthenticationTrustResolverImpl();
    }

    public void afterPropertiesSet() {
        this.checkConfig();
    }

    private void checkConfig() {
        Assert.notNull((Object)this.getFilterProcessesUrl(), (String)"filterProcessesUrl must not be null");
        Assert.notNull((Object)this.jsonConverter, (String)"jsonConverter must not be null");
        Assert.notNull((Object)this.trustResolver, (String)"trustResolver must not be null");
    }

    public AuthenticationTrustResolver getTrustResolver() {
        return this.trustResolver;
    }

    public void setTrustResolver(AuthenticationTrustResolver trustResolver) {
        this.trustResolver = trustResolver;
    }

    public String getFilterProcessesUrl() {
        return this.filterProcessesUrl;
    }

    public void setFilterProcessesUrl(String filterProcessesUrl) {
        this.filterProcessesUrl = filterProcessesUrl;
    }

    void writeResponse(HttpServletResponse httpServletResponse, Serializable options) throws IOException {
        String responseText = this.jsonConverter.writeValueAsString((Object)options);
        httpServletResponse.setContentType("application/json");
        httpServletResponse.getWriter().print(responseText);
    }

    void writeErrorResponse(HttpServletResponse httpServletResponse, RuntimeException e) throws IOException {
        int statusCode;
        ErrorResponse errorResponse;
        if (e instanceof InsufficientAuthenticationException) {
            errorResponse = new ErrorResponse("Anonymous access is prohibited");
            statusCode = 403;
        } else {
            errorResponse = new ErrorResponse("The server encountered an internal error");
            statusCode = 500;
        }
        String errorResponseText = this.jsonConverter.writeValueAsString((Object)errorResponse);
        httpServletResponse.setContentType("application/json");
        httpServletResponse.getWriter().print(errorResponseText);
        httpServletResponse.setStatus(statusCode);
    }

    protected Authentication getAuthentication() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (this.trustResolver.isAnonymous(authentication)) {
            return null;
        }
        return authentication;
    }

    protected boolean processFilter(HttpServletRequest request) {
        return request.getRequestURI().contains(this.getFilterProcessesUrl());
    }
}

