/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.springframework.security.authenticator;

import com.webauthn4j.authenticator.AuthenticatorImpl;
import com.webauthn4j.data.AuthenticatorTransport;
import com.webauthn4j.data.attestation.authenticator.AttestedCredentialData;
import com.webauthn4j.data.attestation.statement.AttestationStatement;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionsAuthenticatorOutputs;
import com.webauthn4j.data.extension.authenticator.RegistrationExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.data.extension.client.RegistrationExtensionClientOutput;
import com.webauthn4j.springframework.security.authenticator.WebAuthnAuthenticator;
import java.io.Serializable;
import java.util.Objects;
import java.util.Set;

public class WebAuthnAuthenticatorImpl
extends AuthenticatorImpl
implements WebAuthnAuthenticator {
    private String name;
    private Serializable userPrincipal;

    public WebAuthnAuthenticatorImpl(String name, Serializable userPrincipal, AttestedCredentialData attestedCredentialData, AttestationStatement attestationStatement, long counter, Set<AuthenticatorTransport> transports, AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> clientExtensions, AuthenticationExtensionsAuthenticatorOutputs<RegistrationExtensionAuthenticatorOutput> authenticatorExtensions) {
        super(attestedCredentialData, attestationStatement, counter, transports, clientExtensions, authenticatorExtensions);
        this.setName(name);
        this.userPrincipal = userPrincipal;
    }

    public WebAuthnAuthenticatorImpl(String name, Serializable userPrincipal, AttestedCredentialData attestedCredentialData, AttestationStatement attestationStatement, long counter) {
        this(name, userPrincipal, attestedCredentialData, attestationStatement, counter, null, null, null);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Serializable getUserPrincipal() {
        return this.userPrincipal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WebAuthnAuthenticatorImpl that = (WebAuthnAuthenticatorImpl)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name);
    }
}

