/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.springframework.security.challenge;

import com.webauthn4j.data.client.challenge.Challenge;
import com.webauthn4j.data.client.challenge.DefaultChallenge;
import com.webauthn4j.springframework.security.challenge.ChallengeRepository;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.util.Assert;

public class HttpSessionChallengeRepository
implements ChallengeRepository {
    private static final String DEFAULT_CHALLENGE_ATTR_NAME = HttpSessionChallengeRepository.class.getName().concat(".CHALLENGE");
    private String sessionAttributeName = DEFAULT_CHALLENGE_ATTR_NAME;

    @Override
    public Challenge generateChallenge() {
        return new DefaultChallenge();
    }

    @Override
    public void saveChallenge(Challenge challenge, HttpServletRequest request) {
        if (challenge == null) {
            HttpSession session = request.getSession(false);
            if (session != null) {
                session.removeAttribute(this.sessionAttributeName);
            }
        } else {
            HttpSession session = request.getSession();
            session.setAttribute(this.sessionAttributeName, (Object)challenge);
        }
    }

    @Override
    public Challenge loadChallenge(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        return (Challenge)session.getAttribute(this.sessionAttributeName);
    }

    public void setSessionAttributeName(String sessionAttributeName) {
        Assert.hasLength((String)sessionAttributeName, (String)"sessionAttributename cannot be null or empty");
        this.sessionAttributeName = sessionAttributeName;
    }
}

