/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.springframework.security.endpoint;

import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.springframework.security.endpoint.AbstractOptionsEndpointFilter;
import com.webauthn4j.springframework.security.options.AttestationOptions;
import com.webauthn4j.springframework.security.options.AttestationOptionsProvider;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.springframework.security.web.FilterInvocation;

public class AttestationOptionsEndpointFilter
extends AbstractOptionsEndpointFilter {
    public static final String FILTER_URL = "/webauthn/attestation/options";
    private final AttestationOptionsProvider attestationOptionsProvider;

    public AttestationOptionsEndpointFilter(AttestationOptionsProvider attestationOptionsProvider, ObjectConverter objectConverter) {
        super(objectConverter);
        this.attestationOptionsProvider = attestationOptionsProvider;
        this.setFilterProcessesUrl(FILTER_URL);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        FilterInvocation fi = new FilterInvocation(request, response, chain);
        if (!this.processFilter(fi.getRequest())) {
            chain.doFilter(request, response);
            return;
        }
        try {
            AttestationOptions attestationOptions = this.attestationOptionsProvider.getAttestationOptions(fi.getRequest(), this.getAuthentication());
            this.writeResponse(fi.getResponse(), attestationOptions);
        }
        catch (RuntimeException e) {
            this.logger.debug((Object)e);
            this.writeErrorResponse(fi.getResponse(), e);
        }
    }
}

