/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.springframework.security.options;

import com.webauthn4j.data.PublicKeyCredentialDescriptor;
import com.webauthn4j.data.PublicKeyCredentialType;
import com.webauthn4j.data.UserVerificationRequirement;
import com.webauthn4j.data.extension.client.AuthenticationExtensionClientInput;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientInputs;
import com.webauthn4j.springframework.security.authenticator.WebAuthnAuthenticatorService;
import com.webauthn4j.springframework.security.challenge.ChallengeRepository;
import com.webauthn4j.springframework.security.exception.PrincipalNotFoundException;
import com.webauthn4j.springframework.security.extension.AuthenticationExtensionsClientInputsProvider;
import com.webauthn4j.springframework.security.options.AssertionOptions;
import com.webauthn4j.springframework.security.options.AssertionOptionsProvider;
import com.webauthn4j.springframework.security.options.RpIdProvider;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;

public class AssertionOptionsProviderImpl
implements AssertionOptionsProvider {
    private String rpId = null;
    private UserVerificationRequirement authenticationUserVerification;
    private Long authenticationTimeout = null;
    private AuthenticationExtensionsClientInputs<AuthenticationExtensionClientInput> authenticationExtensions;
    private RpIdProvider rpIdProvider;
    private final WebAuthnAuthenticatorService authenticatorService;
    private final ChallengeRepository challengeRepository;
    private AuthenticationExtensionsClientInputsProvider<AuthenticationExtensionClientInput> authenticationExtensionsProvider = new DefaultAuthenticationExtensionsProvider();

    public AssertionOptionsProviderImpl(RpIdProvider rpIdProvider, WebAuthnAuthenticatorService authenticatorService, ChallengeRepository challengeRepository) {
        Assert.notNull((Object)authenticatorService, (String)"authenticatorService must not be null");
        Assert.notNull((Object)challengeRepository, (String)"challengeRepository must not be null");
        this.rpIdProvider = rpIdProvider;
        this.authenticatorService = authenticatorService;
        this.challengeRepository = challengeRepository;
    }

    public AssertionOptionsProviderImpl(WebAuthnAuthenticatorService authenticatorService, ChallengeRepository challengeRepository) {
        this(null, authenticatorService, challengeRepository);
    }

    @Override
    public AssertionOptions getAssertionOptions(HttpServletRequest request, Authentication authentication) {
        return new AssertionOptions(this.getChallengeRepository().loadOrGenerateChallenge(request), this.getAuthenticationTimeout(), this.getRpId(request), this.getCredentials(authentication), this.getAuthenticationUserVerification(), this.getAuthenticationExtensionsProvider().provide(request));
    }

    public String getRpId() {
        return this.rpId;
    }

    public void setRpId(String rpId) {
        this.rpId = rpId;
        this.rpIdProvider = null;
    }

    public UserVerificationRequirement getAuthenticationUserVerification() {
        return this.authenticationUserVerification;
    }

    public void setAuthenticationUserVerification(UserVerificationRequirement authenticationUserVerification) {
        this.authenticationUserVerification = authenticationUserVerification;
    }

    public Long getAuthenticationTimeout() {
        return this.authenticationTimeout;
    }

    public void setAuthenticationTimeout(Long authenticationTimeout) {
        Assert.notNull((Object)authenticationTimeout, (String)"authenticationTimeout must not be null.");
        Assert.isTrue((authenticationTimeout >= 0L ? 1 : 0) != 0, (String)"registrationTimeout must be within unsigned long.");
        this.authenticationTimeout = authenticationTimeout;
    }

    public AuthenticationExtensionsClientInputs<AuthenticationExtensionClientInput> getAuthenticationExtensions() {
        return this.authenticationExtensions;
    }

    public void setAuthenticationExtensions(AuthenticationExtensionsClientInputs<AuthenticationExtensionClientInput> authenticationExtensions) {
        this.authenticationExtensions = authenticationExtensions;
    }

    public RpIdProvider getRpIdProvider() {
        return this.rpIdProvider;
    }

    public void setRpIdProvider(RpIdProvider rpIdProvider) {
        this.rpId = null;
        this.rpIdProvider = rpIdProvider;
    }

    public AuthenticationExtensionsClientInputsProvider<AuthenticationExtensionClientInput> getAuthenticationExtensionsProvider() {
        return this.authenticationExtensionsProvider;
    }

    public void setAuthenticationExtensionsProvider(AuthenticationExtensionsClientInputsProvider<AuthenticationExtensionClientInput> authenticationExtensionsProvider) {
        Assert.notNull(authenticationExtensionsProvider, (String)"registrationExtensionsProvider must not be null");
        this.authenticationExtensionsProvider = authenticationExtensionsProvider;
    }

    public WebAuthnAuthenticatorService getAuthenticatorService() {
        return this.authenticatorService;
    }

    protected ChallengeRepository getChallengeRepository() {
        return this.challengeRepository;
    }

    String getRpId(HttpServletRequest request) {
        if (this.rpIdProvider != null) {
            return this.rpIdProvider.provide(request);
        }
        return this.rpId;
    }

    protected List<PublicKeyCredentialDescriptor> getCredentials(Authentication authentication) {
        if (authentication == null) {
            return Collections.emptyList();
        }
        try {
            return this.getAuthenticatorService().loadAuthenticatorsByUserPrincipal(authentication.getName()).stream().map(authenticator -> new PublicKeyCredentialDescriptor(PublicKeyCredentialType.PUBLIC_KEY, authenticator.getAttestedCredentialData().getCredentialId(), authenticator.getTransports())).collect(Collectors.toList());
        }
        catch (PrincipalNotFoundException e) {
            return Collections.emptyList();
        }
    }

    class DefaultAuthenticationExtensionsProvider
    implements AuthenticationExtensionsClientInputsProvider<AuthenticationExtensionClientInput> {
        DefaultAuthenticationExtensionsProvider() {
        }

        @Override
        public AuthenticationExtensionsClientInputs<AuthenticationExtensionClientInput> provide(HttpServletRequest httpServletRequest) {
            return AssertionOptionsProviderImpl.this.authenticationExtensions;
        }
    }
}

