/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.springframework.security;

import com.webauthn4j.WebAuthnManager;
import com.webauthn4j.authenticator.Authenticator;
import com.webauthn4j.data.AuthenticationParameters;
import com.webauthn4j.data.AuthenticationRequest;
import com.webauthn4j.springframework.security.SpringSecurityWebAuthnMessageSource;
import com.webauthn4j.springframework.security.WebAuthnAssertionAuthenticationToken;
import com.webauthn4j.springframework.security.WebAuthnAuthenticationParameters;
import com.webauthn4j.springframework.security.WebAuthnAuthenticationRequest;
import com.webauthn4j.springframework.security.WebAuthnAuthenticationToken;
import com.webauthn4j.springframework.security.authenticator.WebAuthnAuthenticator;
import com.webauthn4j.springframework.security.authenticator.WebAuthnAuthenticatorService;
import com.webauthn4j.springframework.security.exception.CredentialIdNotFoundException;
import com.webauthn4j.springframework.security.util.internal.ExceptionUtil;
import com.webauthn4j.util.exception.WebAuthnException;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.Assert;

public class WebAuthnAuthenticationProvider
implements AuthenticationProvider {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final MessageSourceAccessor messages = SpringSecurityWebAuthnMessageSource.getAccessor();
    private final WebAuthnAuthenticatorService authenticatorService;
    private final WebAuthnManager webAuthnManager;
    private boolean hideCredentialIdNotFoundExceptions = true;

    public WebAuthnAuthenticationProvider(WebAuthnAuthenticatorService authenticatorService, WebAuthnManager webAuthnManager) {
        Assert.notNull((Object)authenticatorService, (String)"authenticatorService must not be null");
        Assert.notNull((Object)webAuthnManager, (String)"webAuthnManager must not be null");
        this.authenticatorService = authenticatorService;
        this.webAuthnManager = webAuthnManager;
    }

    public Authentication authenticate(Authentication authentication) {
        if (!this.supports(authentication.getClass())) {
            throw new IllegalArgumentException("Only WebAuthnAssertionAuthenticationToken is supported, " + authentication.getClass() + " was attempted");
        }
        WebAuthnAssertionAuthenticationToken authenticationToken = (WebAuthnAssertionAuthenticationToken)authentication;
        WebAuthnAuthenticationRequest credentials = authenticationToken.getCredentials();
        if (credentials == null) {
            this.logger.debug((Object)"Authentication failed: no credentials provided");
            throw new BadCredentialsException(this.messages.getMessage("WebAuthnAuthenticationProvider.badCredentials", "Bad credentials"));
        }
        byte[] credentialId = credentials.getCredentialId();
        WebAuthnAuthenticator webAuthnAuthenticator = this.retrieveAuthenticator(credentialId);
        this.doAuthenticate(authenticationToken, webAuthnAuthenticator);
        this.authenticatorService.updateCounter(credentialId, webAuthnAuthenticator.getCounter());
        return this.createSuccessAuthentication(authenticationToken, webAuthnAuthenticator);
    }

    protected Authentication createSuccessAuthentication(WebAuthnAssertionAuthenticationToken authenticationToken, WebAuthnAuthenticator webAuthnAuthenticator) {
        Object principal = webAuthnAuthenticator.getUserPrincipal();
        Collection authorities = null;
        if (principal instanceof UserDetails) {
            authorities = ((UserDetails)principal).getAuthorities();
        }
        WebAuthnAuthenticationToken webAuthnAuthenticationToken = new WebAuthnAuthenticationToken(principal, authenticationToken.getCredentials(), authorities);
        webAuthnAuthenticationToken.setDetails(authenticationToken.getDetails());
        return webAuthnAuthenticationToken;
    }

    public boolean supports(Class<?> authentication) {
        return WebAuthnAssertionAuthenticationToken.class.isAssignableFrom(authentication);
    }

    void doAuthenticate(WebAuthnAssertionAuthenticationToken authenticationToken, WebAuthnAuthenticator webAuthnAuthenticator) {
        WebAuthnAuthenticationRequest request = authenticationToken.getCredentials();
        WebAuthnAuthenticationParameters parameters = authenticationToken.getParameters();
        AuthenticationRequest authenticationRequest = new AuthenticationRequest(request.getCredentialId(), request.getAuthenticatorData(), request.getClientDataJSON(), request.getClientExtensionsJSON(), request.getSignature());
        AuthenticationParameters authenticationParameters = new AuthenticationParameters(parameters.getServerProperty(), (Authenticator)webAuthnAuthenticator, null, parameters.isUserVerificationRequired(), parameters.isUserPresenceRequired());
        try {
            this.webAuthnManager.validate(authenticationRequest, authenticationParameters);
        }
        catch (WebAuthnException e) {
            throw ExceptionUtil.wrapWithAuthenticationException(e);
        }
    }

    public boolean isHideCredentialIdNotFoundExceptions() {
        return this.hideCredentialIdNotFoundExceptions;
    }

    public void setHideCredentialIdNotFoundExceptions(boolean hideCredentialIdNotFoundExceptions) {
        this.hideCredentialIdNotFoundExceptions = hideCredentialIdNotFoundExceptions;
    }

    WebAuthnAuthenticator retrieveAuthenticator(byte[] credentialId) {
        WebAuthnAuthenticator webAuthnAuthenticator;
        try {
            webAuthnAuthenticator = this.authenticatorService.loadAuthenticatorByCredentialId(credentialId);
        }
        catch (CredentialIdNotFoundException notFound) {
            if (this.hideCredentialIdNotFoundExceptions) {
                throw new BadCredentialsException(this.messages.getMessage("WebAuthnAuthenticationProvider.badCredentials", "Bad credentials"));
            }
            throw notFound;
        }
        catch (Exception repositoryProblem) {
            throw new InternalAuthenticationServiceException(repositoryProblem.getMessage(), (Throwable)repositoryProblem);
        }
        if (webAuthnAuthenticator == null) {
            throw new InternalAuthenticationServiceException("WebAuthnAuthenticatorService returned null, which is an interface contract violation");
        }
        return webAuthnAuthenticator;
    }
}

