/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jackson;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.webcohesion.enunciate.EnunciateContext;
import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.api.InterfaceDescriptionFile;
import com.webcohesion.enunciate.api.datatype.DataType;
import com.webcohesion.enunciate.api.datatype.DataTypeReference;
import com.webcohesion.enunciate.api.datatype.Namespace;
import com.webcohesion.enunciate.api.datatype.Syntax;
import com.webcohesion.enunciate.api.resources.MediaTypeDescriptor;
import com.webcohesion.enunciate.facets.FacetFilter;
import com.webcohesion.enunciate.facets.HasFacets;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedDeclaredType;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.metadata.qname.XmlQNameEnum;
import com.webcohesion.enunciate.module.EnunciateModuleContext;
import com.webcohesion.enunciate.modules.jackson.api.impl.DataTypeImpl;
import com.webcohesion.enunciate.modules.jackson.api.impl.DataTypeReferenceImpl;
import com.webcohesion.enunciate.modules.jackson.api.impl.EnumDataTypeImpl;
import com.webcohesion.enunciate.modules.jackson.api.impl.MediaTypeDescriptorImpl;
import com.webcohesion.enunciate.modules.jackson.api.impl.ObjectDataTypeImpl;
import com.webcohesion.enunciate.modules.jackson.model.Accessor;
import com.webcohesion.enunciate.modules.jackson.model.EnumTypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.Member;
import com.webcohesion.enunciate.modules.jackson.model.ObjectTypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.QNameEnumTypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.SimpleTypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.TypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.Value;
import com.webcohesion.enunciate.modules.jackson.model.adapters.AdapterType;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonType;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonTypeFactory;
import com.webcohesion.enunciate.modules.jackson.model.types.KnownJsonType;
import com.webcohesion.enunciate.modules.jackson.model.util.JacksonUtil;
import com.webcohesion.enunciate.modules.jackson.model.util.MapType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;

public class EnunciateJacksonContext
extends EnunciateModuleContext
implements Syntax {
    public static final String SYNTAX_LABEL = "JSON";
    private final Map<String, JsonType> knownTypes = this.loadKnownTypes();
    private final Map<String, TypeDefinition> typeDefinitions = new HashMap<String, TypeDefinition>();
    private final boolean honorJaxb;

    public EnunciateJacksonContext(EnunciateContext context, boolean honorJaxb) {
        super(context);
        this.honorJaxb = honorJaxb;
    }

    public String getId() {
        return "jackson";
    }

    public int compareTo(Syntax syntax) {
        return this.getId().compareTo(syntax.getId());
    }

    public EnunciateContext getContext() {
        return this.context;
    }

    public boolean isHonorJaxb() {
        return this.honorJaxb;
    }

    public Collection<TypeDefinition> getTypeDefinitions() {
        return this.typeDefinitions.values();
    }

    public boolean isEmpty() {
        return this.typeDefinitions.isEmpty();
    }

    public String getSlug() {
        return "syntax_json";
    }

    public String getLabel() {
        return SYNTAX_LABEL;
    }

    public MediaTypeDescriptor findMediaTypeDescriptor(String mediaType, DecoratedTypeMirror typeMirror) {
        if (mediaType == null) {
            return null;
        }
        if (mediaType.equals("*/*") || mediaType.equals("application/*")) {
            mediaType = "application/json";
        }
        if (mediaType.endsWith("/json") || mediaType.endsWith("+json")) {
            DataTypeReference typeReference = this.findDataTypeReference(typeMirror);
            return new MediaTypeDescriptorImpl(mediaType, typeReference);
        }
        return null;
    }

    private DataTypeReference findDataTypeReference(DecoratedTypeMirror typeMirror) {
        JsonType jsonType;
        if (typeMirror == null) {
            return null;
        }
        try {
            jsonType = JsonTypeFactory.getJsonType((TypeMirror)typeMirror, this);
        }
        catch (Exception e) {
            jsonType = null;
        }
        return jsonType == null ? null : new DataTypeReferenceImpl(jsonType);
    }

    public List<Namespace> getNamespaces() {
        return Arrays.asList(this.getNamespace());
    }

    public Namespace getNamespace() {
        return new JacksonNamespace();
    }

    public JsonType getKnownType(Element declaration) {
        if (declaration instanceof TypeElement) {
            return this.knownTypes.get(((TypeElement)declaration).getQualifiedName().toString());
        }
        return null;
    }

    public TypeDefinition findTypeDefinition(Element declaration) {
        if (declaration instanceof TypeElement) {
            return this.typeDefinitions.get(((TypeElement)declaration).getQualifiedName().toString());
        }
        return null;
    }

    protected Map<String, JsonType> loadKnownTypes() {
        HashMap<String, JsonType> knownTypes = new HashMap<String, JsonType>();
        knownTypes.put(Boolean.class.getName(), KnownJsonType.BOOLEAN);
        knownTypes.put(Byte.class.getName(), KnownJsonType.NUMBER);
        knownTypes.put(Character.class.getName(), KnownJsonType.STRING);
        knownTypes.put(Double.class.getName(), KnownJsonType.NUMBER);
        knownTypes.put(Float.class.getName(), KnownJsonType.NUMBER);
        knownTypes.put(Integer.class.getName(), KnownJsonType.NUMBER);
        knownTypes.put(Long.class.getName(), KnownJsonType.NUMBER);
        knownTypes.put(Short.class.getName(), KnownJsonType.NUMBER);
        knownTypes.put(Boolean.TYPE.getName(), KnownJsonType.BOOLEAN);
        knownTypes.put(Byte.TYPE.getName(), KnownJsonType.NUMBER);
        knownTypes.put(Double.TYPE.getName(), KnownJsonType.NUMBER);
        knownTypes.put(Float.TYPE.getName(), KnownJsonType.NUMBER);
        knownTypes.put(Integer.TYPE.getName(), KnownJsonType.NUMBER);
        knownTypes.put(Long.TYPE.getName(), KnownJsonType.NUMBER);
        knownTypes.put(Short.TYPE.getName(), KnownJsonType.NUMBER);
        knownTypes.put(Character.TYPE.getName(), KnownJsonType.STRING);
        knownTypes.put(String.class.getName(), KnownJsonType.STRING);
        knownTypes.put(BigInteger.class.getName(), KnownJsonType.NUMBER);
        knownTypes.put(BigDecimal.class.getName(), KnownJsonType.NUMBER);
        knownTypes.put(Calendar.class.getName(), KnownJsonType.NUMBER);
        knownTypes.put(Date.class.getName(), KnownJsonType.NUMBER);
        knownTypes.put(Timestamp.class.getName(), KnownJsonType.NUMBER);
        knownTypes.put(URI.class.getName(), KnownJsonType.STRING);
        knownTypes.put(Object.class.getName(), KnownJsonType.OBJECT);
        knownTypes.put(byte[].class.getName(), KnownJsonType.STRING);
        knownTypes.put(DataHandler.class.getName(), KnownJsonType.STRING);
        knownTypes.put(UUID.class.getName(), KnownJsonType.STRING);
        knownTypes.put(XMLGregorianCalendar.class.getName(), KnownJsonType.NUMBER);
        knownTypes.put(GregorianCalendar.class.getName(), KnownJsonType.NUMBER);
        return knownTypes;
    }

    protected TypeDefinition createTypeDefinition(TypeElement declaration) {
        if (declaration.getKind() == ElementKind.INTERFACE && declaration.getAnnotation(XmlType.class) != null) {
            throw new EnunciateException(declaration.getQualifiedName() + ": an interface must not be annotated with @XmlType.");
        }
        if (this.isEnumType(declaration = this.narrowToAdaptingType(declaration))) {
            if (declaration.getAnnotation(XmlQNameEnum.class) != null) {
                return new QNameEnumTypeDefinition(declaration, this);
            }
            return new EnumTypeDefinition(declaration, this);
        }
        ObjectTypeDefinition typeDef = new ObjectTypeDefinition(declaration, this);
        if (typeDef.getValue() != null && this.hasNoMembers(typeDef)) {
            return new SimpleTypeDefinition(typeDef);
        }
        return typeDef;
    }

    protected TypeElement narrowToAdaptingType(TypeElement declaration) {
        AdapterType adapterType = JacksonUtil.findAdapterType(declaration, this);
        if (adapterType != null) {
            TypeMirror adaptingType = adapterType.getAdaptingType();
            if (adaptingType.getKind() != TypeKind.DECLARED) {
                return declaration;
            }
            TypeElement adaptingDeclaration = (TypeElement)((DeclaredType)adaptingType).asElement();
            if (adaptingDeclaration == null) {
                throw new EnunciateException(String.format("Class %s is being adapted by a type (%s) that doesn't seem to be on the classpath.", declaration.getQualifiedName(), adaptingType));
            }
            return adaptingDeclaration;
        }
        return declaration;
    }

    protected boolean isEnumType(TypeElement declaration) {
        JsonFormat format = declaration.getAnnotation(JsonFormat.class);
        if (format != null && format.shape() == JsonFormat.Shape.OBJECT) {
            return false;
        }
        return declaration.getKind() == ElementKind.ENUM;
    }

    protected boolean hasNoMembers(TypeDefinition typeDef) {
        TypeElement superDeclaration;
        boolean none = typeDef.getMembers().isEmpty();
        TypeMirror superclass = typeDef.getSuperclass();
        if (superclass instanceof DeclaredType && (superDeclaration = (TypeElement)((DeclaredType)superclass).asElement()) != null && !Object.class.getName().equals(superDeclaration.getQualifiedName().toString())) {
            none &= this.hasNoMembers(new ObjectTypeDefinition(superDeclaration, this));
        }
        return none;
    }

    public void add(TypeDefinition typeDef) {
        this.add(typeDef, new LinkedList<Element>());
    }

    public boolean isKnownTypeDefinition(TypeElement el) {
        return this.findTypeDefinition(el) != null || this.isKnownType(el);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TypeDefinition typeDef, LinkedList<Element> stack) {
        if (this.findTypeDefinition((Element)((Object)typeDef)) == null && !this.isKnownType((TypeElement)((Object)typeDef))) {
            this.typeDefinitions.put(typeDef.getQualifiedName().toString(), typeDef);
            this.debug("Added %s as a Jackson type definition.", new Object[]{typeDef.getQualifiedName()});
            typeDef.getReferencedFrom().addAll(stack);
            try {
                stack.push((Element)((Object)typeDef));
                this.addSeeAlsoTypeDefinitions((Element)((Object)typeDef), stack);
                for (Member member : typeDef.getMembers()) {
                    this.addReferencedTypeDefinitions(member, stack);
                }
                Value value = typeDef.getValue();
                if (value != null) {
                    this.addReferencedTypeDefinitions(value, stack);
                }
                TypeMirror superclass = typeDef.getSuperclass();
                if (!typeDef.isEnum() && superclass != null && superclass.getKind() != TypeKind.NONE) {
                    this.addReferencedTypeDefinitions(superclass, stack);
                }
            }
            finally {
                stack.pop();
            }
        }
    }

    protected void addReferencedTypeDefinitions(Accessor accessor, LinkedList<Element> stack) {
        this.addSeeAlsoTypeDefinitions((Element)((Object)accessor), stack);
        DecoratedTypeMirror enumRef = accessor.getQNameEnumRef();
        if (enumRef != null) {
            this.addReferencedTypeDefinitions((TypeMirror)enumRef, stack);
        }
    }

    protected void addReferencedTypeDefinitions(Value value, LinkedList<Element> stack) {
        this.addReferencedTypeDefinitions((Accessor)value, stack);
        if (value.isAdapted()) {
            this.addReferencedTypeDefinitions((TypeMirror)((Object)value.getAdapterType()), stack);
        } else if (value.getQNameEnumRef() == null) {
            this.addReferencedTypeDefinitions((TypeMirror)value.getAccessorType(), stack);
        }
    }

    protected void addReferencedTypeDefinitions(Member member, LinkedList<Element> stack) {
        this.addReferencedTypeDefinitions((Accessor)member, stack);
        for (Member member2 : member.getChoices()) {
            if (member2.isAdapted()) {
                this.addReferencedTypeDefinitions((TypeMirror)((Object)member2.getAdapterType()), stack);
                continue;
            }
            if (member2.getQNameEnumRef() != null) continue;
            this.addReferencedTypeDefinitions((TypeMirror)member2.getAccessorType(), stack);
        }
    }

    protected void addReferencedTypeDefinitions(TypeMirror type, LinkedList<Element> stack) {
        type.accept(new ReferencedJsonDefinitionVisitor(), stack);
    }

    protected void addSeeAlsoTypeDefinitions(Element declaration, LinkedList<Element> stack) {
    }

    protected boolean isKnownType(TypeElement typeDef) {
        return this.knownTypes.containsKey(typeDef.getQualifiedName().toString()) || ((DecoratedTypeMirror)typeDef.asType()).isInstanceOf(JAXBElement.class);
    }

    private class JacksonNamespace
    implements Namespace {
        private JacksonNamespace() {
        }

        public String getUri() {
            return null;
        }

        public InterfaceDescriptionFile getSchemaFile() {
            return null;
        }

        public List<? extends DataType> getTypes() {
            Collection<TypeDefinition> typeDefinitions = EnunciateJacksonContext.this.getTypeDefinitions();
            ArrayList<DataTypeImpl> dataTypes = new ArrayList<DataTypeImpl>();
            FacetFilter facetFilter = EnunciateJacksonContext.this.getContext().getConfiguration().getFacetFilter();
            for (TypeDefinition typeDefinition : typeDefinitions) {
                if (!facetFilter.accept((HasFacets)typeDefinition)) continue;
                if (typeDefinition instanceof ObjectTypeDefinition) {
                    dataTypes.add(new ObjectDataTypeImpl((ObjectTypeDefinition)typeDefinition));
                    continue;
                }
                if (!(typeDefinition instanceof EnumTypeDefinition)) continue;
                dataTypes.add(new EnumDataTypeImpl((EnumTypeDefinition)typeDefinition));
            }
            Collections.sort(dataTypes, new Comparator<DataType>(){

                @Override
                public int compare(DataType o1, DataType o2) {
                    return o1.getLabel().compareTo(o2.getLabel());
                }
            });
            return dataTypes;
        }
    }

    private class ReferencedJsonDefinitionVisitor
    extends SimpleTypeVisitor6<Void, LinkedList<Element>> {
        private ReferencedJsonDefinitionVisitor() {
        }

        @Override
        public Void visitArray(ArrayType t, LinkedList<Element> stack) {
            return t.getComponentType().accept(this, stack);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void visitDeclared(DeclaredType declaredType, LinkedList<Element> stack) {
            TypeElement declaration = (TypeElement)declaredType.asElement();
            if (declaration.getKind() == ElementKind.ENUM) {
                if (!EnunciateJacksonContext.this.isKnownTypeDefinition(declaration)) {
                    EnunciateJacksonContext.this.add(EnunciateJacksonContext.this.createTypeDefinition(declaration));
                }
            } else if (declaredType instanceof AdapterType) {
                ((AdapterType)((Object)declaredType)).getAdaptingType().accept(this, stack);
            } else if (MapType.findMapType(declaredType, EnunciateJacksonContext.this) == null) {
                String qualifiedName = declaration.getQualifiedName().toString();
                if (Object.class.getName().equals(qualifiedName)) {
                    return null;
                }
                if (stack.contains(declaration)) {
                    return null;
                }
                stack.push(declaration);
                try {
                    List<? extends TypeMirror> typeArgs;
                    if (!(EnunciateJacksonContext.this.isKnownTypeDefinition(declaration) || declaration.getKind() != ElementKind.CLASS || ((DecoratedDeclaredType)declaredType).isCollection() || ((DecoratedDeclaredType)declaredType).isInstanceOf(JAXBElement.class))) {
                        EnunciateJacksonContext.this.add(EnunciateJacksonContext.this.createTypeDefinition(declaration));
                    }
                    if ((typeArgs = declaredType.getTypeArguments()) != null) {
                        for (TypeMirror typeMirror : typeArgs) {
                            typeMirror.accept(this, stack);
                        }
                    }
                }
                finally {
                    stack.pop();
                }
            }
            return null;
        }

        @Override
        public Void visitTypeVariable(TypeVariable t, LinkedList<Element> stack) {
            return t.getUpperBound().accept(this, stack);
        }

        @Override
        public Void visitWildcard(WildcardType t, LinkedList<Element> stack) {
            TypeMirror superBound;
            TypeMirror extendsBound = t.getExtendsBound();
            if (extendsBound != null) {
                extendsBound.accept(this, stack);
            }
            if ((superBound = t.getSuperBound()) != null) {
                superBound.accept(this, stack);
            }
            return null;
        }

        @Override
        public Void visitUnknown(TypeMirror t, LinkedList<Element> stack) {
            return (Void)this.defaultAction(t, stack);
        }
    }
}

