/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jackson.model.types;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.webcohesion.enunciate.javac.decorations.Annotations;
import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.metadata.rs.TypeHint;
import com.webcohesion.enunciate.modules.jackson.EnunciateJacksonContext;
import com.webcohesion.enunciate.modules.jackson.model.TypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.adapters.AdapterType;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonArrayType;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonClassType;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonMapType;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonPrimitiveType;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonType;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonTypeFactory;
import com.webcohesion.enunciate.modules.jackson.model.types.KnownJsonType;
import com.webcohesion.enunciate.modules.jackson.model.util.JacksonUtil;
import com.webcohesion.enunciate.modules.jackson.model.util.MapType;
import com.webcohesion.enunciate.util.TypeHintUtils;
import java.util.concurrent.Callable;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor6;

public class JsonTypeVisitor
extends SimpleTypeVisitor6<JsonType, Context> {
    @Override
    protected JsonType defaultAction(TypeMirror typeMirror, Context context) {
        return KnownJsonType.OBJECT;
    }

    @Override
    public JsonType visitPrimitive(PrimitiveType primitiveType, Context context) {
        if (context.isInArray() && primitiveType.getKind() == TypeKind.BYTE) {
            return KnownJsonType.STRING;
        }
        JsonPrimitiveType jsonType = new JsonPrimitiveType(primitiveType);
        return context.isInArray() || context.isInCollection() ? new JsonArrayType(jsonType) : jsonType;
    }

    @Override
    public JsonType visitDeclared(DeclaredType declaredType, Context context) {
        AdapterType adapterType;
        JsonSerialize serializeInfo;
        TypeMirror hint;
        JsonType jsonType = null;
        Element declaredElement = declaredType.asElement();
        TypeHint typeHint = declaredElement.getAnnotation(TypeHint.class);
        if (typeHint != null && (hint = TypeHintUtils.getTypeHint((TypeHint)typeHint, (ProcessingEnvironment)context.getContext().getContext().getProcessingEnvironment(), null)) != null) {
            jsonType = hint.accept(this, new Context(context.context, false, false));
        }
        if ((serializeInfo = declaredElement.getAnnotation(JsonSerialize.class)) != null) {
            DecoratedTypeMirror as;
            DecoratedProcessingEnvironment env = context.getContext().getContext().getProcessingEnvironment();
            DecoratedTypeMirror using = Annotations.mirrorOf((Callable)new Callable<Class<?>>(){

                @Override
                public Class<?> call() throws Exception {
                    return serializeInfo.using();
                }
            }, (ProcessingEnvironment)env, JsonSerializer.None.class);
            if (using != null) {
                jsonType = KnownJsonType.OBJECT;
            }
            if ((as = Annotations.mirrorOf((Callable)new Callable<Class<?>>(){

                @Override
                public Class<?> call() throws Exception {
                    return serializeInfo.as();
                }
            }, (ProcessingEnvironment)env, Void.class)) != null) {
                jsonType = (JsonType)as.accept((TypeVisitor)this, (Object)new Context(context.context, false, false));
            }
        }
        if ((adapterType = JacksonUtil.findAdapterType(declaredElement, context.getContext())) != null) {
            adapterType.getAdaptingType().accept(this, new Context(context.context, false, false));
        } else {
            MapType mapType = MapType.findMapType(declaredType, context.getContext());
            if (mapType != null) {
                JsonType keyType = JsonTypeFactory.getJsonType(mapType.getKeyType(), context.getContext());
                JsonType valueType = JsonTypeFactory.getJsonType(mapType.getValueType(), context.getContext());
                jsonType = new JsonMapType(keyType, valueType);
            } else {
                switch (declaredElement.getKind()) {
                    case ENUM: 
                    case CLASS: {
                        JsonType knownType = context.getContext().getKnownType(declaredElement);
                        if (knownType != null) {
                            jsonType = knownType;
                            break;
                        }
                        TypeDefinition typeDefinition = context.getContext().findTypeDefinition(declaredElement);
                        if (typeDefinition == null) break;
                        jsonType = new JsonClassType(typeDefinition);
                        break;
                    }
                    case INTERFACE: {
                        if (!context.isInCollection()) break;
                        jsonType = KnownJsonType.OBJECT;
                    }
                }
            }
        }
        if (jsonType == null) {
            jsonType = (JsonType)super.visitDeclared(declaredType, context);
        }
        return context.isInArray() || context.isInCollection() ? new JsonArrayType(jsonType) : jsonType;
    }

    @Override
    public JsonType visitArray(ArrayType arrayType, Context context) {
        return new JsonArrayType(arrayType.getComponentType().accept(this, new Context(context.context, true, false)));
    }

    @Override
    public JsonType visitTypeVariable(TypeVariable typeVariable, Context context) {
        TypeMirror bound = typeVariable.getUpperBound();
        if (bound == null) {
            return context.isInArray() || context.isInCollection() ? new JsonArrayType(KnownJsonType.OBJECT) : KnownJsonType.OBJECT;
        }
        JsonType jsonType = bound.accept(this, new Context(context.context, false, false));
        return context.isInArray() || context.isInCollection() ? new JsonArrayType(jsonType) : jsonType;
    }

    @Override
    public JsonType visitWildcard(WildcardType wildcardType, Context context) {
        TypeMirror bound = wildcardType.getExtendsBound();
        if (bound == null) {
            return context.isInArray() || context.isInCollection() ? new JsonArrayType(KnownJsonType.OBJECT) : KnownJsonType.OBJECT;
        }
        JsonType jsonType = bound.accept(this, new Context(context.context, false, false));
        return context.isInArray() || context.isInCollection() ? new JsonArrayType(jsonType) : jsonType;
    }

    public static class Context {
        private final EnunciateJacksonContext context;
        private final boolean inArray;
        private final boolean inCollection;

        public Context(EnunciateJacksonContext context, boolean inArray, boolean inCollection) {
            this.context = context;
            this.inArray = inArray;
            this.inCollection = inCollection;
        }

        public EnunciateJacksonContext getContext() {
            return this.context;
        }

        public boolean isInArray() {
            return this.inArray;
        }

        public boolean isInCollection() {
            return this.inCollection;
        }
    }
}

