/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jackson.api.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.api.datatype.Example;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedElement;
import com.webcohesion.enunciate.javac.decorations.element.ElementUtils;
import com.webcohesion.enunciate.metadata.DocumentationExample;
import com.webcohesion.enunciate.modules.jackson.model.EnumTypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.Member;
import com.webcohesion.enunciate.modules.jackson.model.ObjectTypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.SimpleTypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.TypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonArrayType;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonClassType;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonMapType;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonType;
import java.util.LinkedList;

public class ExampleImpl
implements Example {
    private final ObjectTypeDefinition type;

    public ExampleImpl(ObjectTypeDefinition type) {
        this.type = type;
    }

    public String getLang() {
        return "js";
    }

    public String getBody() {
        ObjectNode node = JsonNodeFactory.instance.objectNode();
        this.build(node, this.type, new LinkedList<String>());
        ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
        try {
            return mapper.writeValueAsString((Object)node);
        }
        catch (JsonProcessingException e) {
            throw new EnunciateException((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void build(ObjectNode node, ObjectTypeDefinition type, LinkedList<String> contextStack) {
        if (contextStack.size() > 2) {
            return;
        }
        for (Member member : type.getMembers()) {
            if (ElementUtils.findDeprecationMessage((DecoratedElement)member) != null) continue;
            String example = null;
            DocumentationExample documentationExample = (DocumentationExample)member.getAnnotation(DocumentationExample.class);
            if (documentationExample != null) {
                if (documentationExample.exclude()) continue;
                if (!"##default".equals(documentationExample.value())) {
                    example = documentationExample.value();
                }
            }
            if (member.getChoices().size() > 1) {
                ArrayNode wrapperNode;
                String choiceName;
                JsonType jsonType;
                if (member.isCollectionType()) {
                    ArrayNode exampleNode = JsonNodeFactory.instance.arrayNode();
                    for (Member member2 : member.getChoices()) {
                        jsonType = member2.getJsonType();
                        choiceName = member2.getName();
                        if ("".equals(choiceName)) {
                            choiceName = "...";
                        }
                        if (member.getSubtypeIdInclusion() == JsonTypeInfo.As.WRAPPER_ARRAY) {
                            wrapperNode = JsonNodeFactory.instance.arrayNode();
                            wrapperNode.add(choiceName);
                            wrapperNode.add(this.exampleNode(jsonType, example, contextStack));
                            exampleNode.add((JsonNode)wrapperNode);
                            continue;
                        }
                        if (member.getSubtypeIdInclusion() == JsonTypeInfo.As.WRAPPER_OBJECT) {
                            wrapperNode = JsonNodeFactory.instance.objectNode();
                            wrapperNode.set(choiceName, this.exampleNode(jsonType, example, contextStack));
                            exampleNode.add((JsonNode)wrapperNode);
                            continue;
                        }
                        exampleNode.add(this.exampleNode(jsonType, example, contextStack));
                    }
                    node.set(member.getName(), (JsonNode)exampleNode);
                    continue;
                }
                for (Member member3 : member.getChoices()) {
                    void var10_17;
                    jsonType = member3.getJsonType();
                    choiceName = member3.getName();
                    if ("".equals(choiceName)) {
                        choiceName = "...";
                    }
                    if (member.getSubtypeIdInclusion() == JsonTypeInfo.As.WRAPPER_ARRAY) {
                        wrapperNode = JsonNodeFactory.instance.arrayNode();
                        wrapperNode.add(choiceName);
                        wrapperNode.add(this.exampleNode(jsonType, example, contextStack));
                        ArrayNode arrayNode = wrapperNode;
                    } else if (member.getSubtypeIdInclusion() == JsonTypeInfo.As.WRAPPER_OBJECT) {
                        wrapperNode = JsonNodeFactory.instance.objectNode();
                        wrapperNode.set(choiceName, this.exampleNode(jsonType, example, contextStack));
                        ArrayNode arrayNode = wrapperNode;
                    } else {
                        JsonNode jsonNode = this.exampleNode(jsonType, example, contextStack);
                    }
                    node.set(member.getName(), (JsonNode)var10_17);
                }
                continue;
            }
            node.set(member.getName(), this.exampleNode(member.getJsonType(), example, contextStack));
        }
        JsonType supertype = type.getSupertype();
        if (supertype instanceof JsonClassType && ((JsonClassType)supertype).getTypeDefinition() instanceof ObjectTypeDefinition) {
            this.build(node, (ObjectTypeDefinition)((JsonClassType)supertype).getTypeDefinition(), contextStack);
        }
        if (type.getWildcardMember() != null && ElementUtils.findDeprecationMessage((DecoratedElement)type.getWildcardMember()) == null) {
            node.put("extension1", "...");
            node.put("extension2", "...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonNode exampleNode(JsonType jsonType, String specifiedExample, LinkedList<String> contextStack) {
        if (jsonType instanceof JsonClassType) {
            TypeDefinition typeDefinition = ((JsonClassType)jsonType).getTypeDefinition();
            if (typeDefinition instanceof ObjectTypeDefinition) {
                ObjectNode objectNode = JsonNodeFactory.instance.objectNode();
                if (!contextStack.contains(typeDefinition.getQualifiedName().toString())) {
                    contextStack.push(typeDefinition.getQualifiedName().toString());
                    try {
                        this.build(objectNode, (ObjectTypeDefinition)typeDefinition, contextStack);
                    }
                    finally {
                        contextStack.pop();
                    }
                }
                return objectNode;
            }
            if (typeDefinition instanceof EnumTypeDefinition) {
                String example = "???";
                if (specifiedExample != null) {
                    example = specifiedExample;
                } else if (((EnumTypeDefinition)typeDefinition).getEnumValues().size() > 0) {
                    example = ((EnumTypeDefinition)typeDefinition).getEnumValues().values().iterator().next();
                }
                return JsonNodeFactory.instance.textNode(example);
            }
            return this.exampleNode(((SimpleTypeDefinition)typeDefinition).getBaseType(), specifiedExample, contextStack);
        }
        if (jsonType instanceof JsonMapType) {
            ObjectNode mapNode = JsonNodeFactory.instance.objectNode();
            mapNode.put("property1", "...");
            mapNode.put("property2", "...");
            return mapNode;
        }
        if (jsonType.isArray()) {
            ArrayNode arrayNode = JsonNodeFactory.instance.arrayNode();
            JsonNode componentNode = this.exampleNode(((JsonArrayType)jsonType).getComponentType(), specifiedExample, contextStack);
            arrayNode.add(componentNode);
            arrayNode.add(componentNode);
            return arrayNode;
        }
        if (jsonType.isNumber()) {
            Double example = 12345.0;
            if (specifiedExample != null) {
                try {
                    example = Double.parseDouble(specifiedExample);
                }
                catch (NumberFormatException e) {
                    this.type.getContext().getContext().getLogger().warn("\"%s\" was provided as a documentation example, but it is not a valid JSON number, so it will be ignored.", new Object[]{specifiedExample});
                }
            }
            return JsonNodeFactory.instance.numberNode(example);
        }
        if (jsonType.isBoolean()) {
            boolean example = !"false".equals(specifiedExample);
            return JsonNodeFactory.instance.booleanNode(example);
        }
        if (jsonType.isString()) {
            String example = specifiedExample;
            if (example == null) {
                example = "...";
            }
            return JsonNodeFactory.instance.textNode(example);
        }
        return JsonNodeFactory.instance.objectNode();
    }
}

