/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jackson;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.POJONode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.webcohesion.enunciate.EnunciateContext;
import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.api.InterfaceDescriptionFile;
import com.webcohesion.enunciate.api.datatype.DataType;
import com.webcohesion.enunciate.api.datatype.DataTypeReference;
import com.webcohesion.enunciate.api.datatype.Namespace;
import com.webcohesion.enunciate.api.datatype.Syntax;
import com.webcohesion.enunciate.api.resources.MediaTypeDescriptor;
import com.webcohesion.enunciate.facets.FacetFilter;
import com.webcohesion.enunciate.facets.HasFacets;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedDeclaredType;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.metadata.json.JsonSeeAlso;
import com.webcohesion.enunciate.metadata.qname.XmlQNameEnum;
import com.webcohesion.enunciate.module.EnunciateModuleContext;
import com.webcohesion.enunciate.modules.jackson.api.impl.DataTypeImpl;
import com.webcohesion.enunciate.modules.jackson.api.impl.DataTypeReferenceImpl;
import com.webcohesion.enunciate.modules.jackson.api.impl.EnumDataTypeImpl;
import com.webcohesion.enunciate.modules.jackson.api.impl.MediaTypeDescriptorImpl;
import com.webcohesion.enunciate.modules.jackson.api.impl.ObjectDataTypeImpl;
import com.webcohesion.enunciate.modules.jackson.model.Accessor;
import com.webcohesion.enunciate.modules.jackson.model.EnumTypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.Member;
import com.webcohesion.enunciate.modules.jackson.model.ObjectTypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.QNameEnumTypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.SimpleTypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.TypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.Value;
import com.webcohesion.enunciate.modules.jackson.model.adapters.AdapterType;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonType;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonTypeFactory;
import com.webcohesion.enunciate.modules.jackson.model.types.KnownJsonType;
import com.webcohesion.enunciate.modules.jackson.model.util.JacksonUtil;
import com.webcohesion.enunciate.modules.jackson.model.util.MapType;
import com.webcohesion.enunciate.util.IgnoreUtils;
import com.webcohesion.enunciate.util.OneTimeLogMessage;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;

public class EnunciateJacksonContext
extends EnunciateModuleContext
implements Syntax {
    public static final String SYNTAX_LABEL = "JSON";
    private final Map<String, JsonType> knownTypes;
    private final Map<String, TypeDefinition> typeDefinitions;
    private final boolean honorJaxb;
    private final KnownJsonType dateType;
    private final Map<String, TypeDefinition> typeDefinitionsBySlug;
    private final boolean collapseTypeHierarchy;

    public EnunciateJacksonContext(EnunciateContext context, boolean honorJaxb, KnownJsonType dateType, boolean collapseTypeHierarchy) {
        super(context);
        this.dateType = dateType;
        this.knownTypes = this.loadKnownTypes();
        this.typeDefinitions = new HashMap<String, TypeDefinition>();
        this.honorJaxb = honorJaxb;
        this.collapseTypeHierarchy = collapseTypeHierarchy;
        this.typeDefinitionsBySlug = new HashMap<String, TypeDefinition>();
    }

    public String getId() {
        return "jackson";
    }

    public int compareTo(Syntax syntax) {
        return this.getId().compareTo(syntax.getId());
    }

    public EnunciateContext getContext() {
        return this.context;
    }

    public boolean isHonorJaxb() {
        return this.honorJaxb;
    }

    public boolean isCollapseTypeHierarchy() {
        return this.collapseTypeHierarchy;
    }

    public Collection<TypeDefinition> getTypeDefinitions() {
        return this.typeDefinitions.values();
    }

    public boolean isEmpty() {
        return this.typeDefinitions.isEmpty();
    }

    public String getSlug() {
        return "syntax_json";
    }

    public String getLabel() {
        return SYNTAX_LABEL;
    }

    public MediaTypeDescriptor findMediaTypeDescriptor(String mediaType, DecoratedTypeMirror typeMirror) {
        if (mediaType == null) {
            return null;
        }
        if (mediaType.equals("*/*") || mediaType.equals("application/*")) {
            mediaType = "application/json";
        }
        if (mediaType.endsWith("/json") || mediaType.endsWith("+json")) {
            DataTypeReference typeReference = this.findDataTypeReference(typeMirror);
            return typeReference == null ? null : new MediaTypeDescriptorImpl(mediaType, typeReference);
        }
        return null;
    }

    private DataTypeReference findDataTypeReference(DecoratedTypeMirror typeMirror) {
        JsonType jsonType;
        if (typeMirror == null) {
            return null;
        }
        try {
            jsonType = JsonTypeFactory.getJsonType((TypeMirror)typeMirror, this);
        }
        catch (Exception e) {
            jsonType = null;
        }
        return jsonType == null ? null : new DataTypeReferenceImpl(jsonType);
    }

    public List<Namespace> getNamespaces() {
        return Arrays.asList(this.getNamespace());
    }

    public Namespace getNamespace() {
        return new JacksonNamespace();
    }

    public JsonType getKnownType(Element declaration) {
        if (declaration instanceof TypeElement) {
            return this.knownTypes.get(((TypeElement)declaration).getQualifiedName().toString());
        }
        return null;
    }

    public TypeDefinition findTypeDefinition(Element declaration) {
        if (declaration instanceof TypeElement) {
            return this.typeDefinitions.get(((TypeElement)declaration).getQualifiedName().toString());
        }
        return null;
    }

    protected Map<String, JsonType> loadKnownTypes() {
        HashMap<String, JsonType> knownTypes = new HashMap<String, JsonType>();
        knownTypes.put(Boolean.class.getName(), KnownJsonType.BOOLEAN);
        knownTypes.put(Byte.class.getName(), KnownJsonType.WHOLE_NUMBER);
        knownTypes.put(Character.class.getName(), KnownJsonType.STRING);
        knownTypes.put(Double.class.getName(), KnownJsonType.NUMBER);
        knownTypes.put(Float.class.getName(), KnownJsonType.NUMBER);
        knownTypes.put(Integer.class.getName(), KnownJsonType.WHOLE_NUMBER);
        knownTypes.put(Long.class.getName(), KnownJsonType.WHOLE_NUMBER);
        knownTypes.put(Short.class.getName(), KnownJsonType.WHOLE_NUMBER);
        knownTypes.put(Boolean.TYPE.getName(), KnownJsonType.BOOLEAN);
        knownTypes.put(Byte.TYPE.getName(), KnownJsonType.WHOLE_NUMBER);
        knownTypes.put(Double.TYPE.getName(), KnownJsonType.NUMBER);
        knownTypes.put(Float.TYPE.getName(), KnownJsonType.NUMBER);
        knownTypes.put(Integer.TYPE.getName(), KnownJsonType.WHOLE_NUMBER);
        knownTypes.put(Long.TYPE.getName(), KnownJsonType.WHOLE_NUMBER);
        knownTypes.put(Short.TYPE.getName(), KnownJsonType.WHOLE_NUMBER);
        knownTypes.put(Character.TYPE.getName(), KnownJsonType.STRING);
        knownTypes.put(String.class.getName(), KnownJsonType.STRING);
        knownTypes.put(BigInteger.class.getName(), KnownJsonType.WHOLE_NUMBER);
        knownTypes.put(BigDecimal.class.getName(), KnownJsonType.NUMBER);
        knownTypes.put(Calendar.class.getName(), this.dateType);
        knownTypes.put(Date.class.getName(), this.dateType);
        knownTypes.put(Timestamp.class.getName(), this.dateType);
        knownTypes.put(URI.class.getName(), KnownJsonType.STRING);
        knownTypes.put(Object.class.getName(), KnownJsonType.OBJECT);
        knownTypes.put(byte[].class.getName(), KnownJsonType.STRING);
        knownTypes.put(DataHandler.class.getName(), KnownJsonType.STRING);
        knownTypes.put(UUID.class.getName(), KnownJsonType.STRING);
        knownTypes.put(XMLGregorianCalendar.class.getName(), this.dateType);
        knownTypes.put(GregorianCalendar.class.getName(), this.dateType);
        knownTypes.put(JsonNode.class.getName(), KnownJsonType.OBJECT);
        knownTypes.put(ContainerNode.class.getName(), KnownJsonType.OBJECT);
        knownTypes.put(ArrayNode.class.getName(), KnownJsonType.ARRAY);
        knownTypes.put(ObjectNode.class.getName(), KnownJsonType.OBJECT);
        knownTypes.put(ValueNode.class.getName(), KnownJsonType.STRING);
        knownTypes.put(TextNode.class.getName(), KnownJsonType.STRING);
        knownTypes.put(BinaryNode.class.getName(), KnownJsonType.STRING);
        knownTypes.put(MissingNode.class.getName(), KnownJsonType.STRING);
        knownTypes.put(NullNode.class.getName(), KnownJsonType.STRING);
        knownTypes.put(NumericNode.class.getName(), KnownJsonType.WHOLE_NUMBER);
        knownTypes.put(IntNode.class.getName(), KnownJsonType.WHOLE_NUMBER);
        knownTypes.put(ShortNode.class.getName(), KnownJsonType.WHOLE_NUMBER);
        knownTypes.put(FloatNode.class.getName(), KnownJsonType.NUMBER);
        knownTypes.put(DoubleNode.class.getName(), KnownJsonType.NUMBER);
        knownTypes.put(DecimalNode.class.getName(), KnownJsonType.NUMBER);
        knownTypes.put(LongNode.class.getName(), KnownJsonType.WHOLE_NUMBER);
        knownTypes.put(BigIntegerNode.class.getName(), KnownJsonType.WHOLE_NUMBER);
        knownTypes.put(POJONode.class.getName(), KnownJsonType.OBJECT);
        knownTypes.put(BooleanNode.class.getName(), KnownJsonType.BOOLEAN);
        knownTypes.put(Class.class.getName(), KnownJsonType.OBJECT);
        knownTypes.put("java.time.Period", KnownJsonType.STRING);
        knownTypes.put("java.time.Duration", this.dateType);
        knownTypes.put("java.time.Instant", this.dateType);
        knownTypes.put("java.time.Year", this.dateType);
        knownTypes.put("java.time.YearMonth", KnownJsonType.STRING);
        knownTypes.put("java.time.MonthDay", KnownJsonType.STRING);
        knownTypes.put("java.time.ZoneId", KnownJsonType.STRING);
        knownTypes.put("java.time.ZoneOffset", KnownJsonType.STRING);
        knownTypes.put("java.time.LocalDate", KnownJsonType.STRING);
        knownTypes.put("java.time.LocalTime", KnownJsonType.STRING);
        knownTypes.put("java.time.LocalDateTime", KnownJsonType.STRING);
        knownTypes.put("java.time.OffsetTime", KnownJsonType.STRING);
        knownTypes.put("java.time.ZonedDateTime", this.dateType);
        knownTypes.put("java.time.OffsetDateTime", this.dateType);
        knownTypes.put("org.joda.time.DateTime", this.dateType);
        return knownTypes;
    }

    protected TypeDefinition createTypeDefinition(TypeElement declaration) {
        if (declaration.getKind() == ElementKind.INTERFACE && declaration.getAnnotation(XmlType.class) != null) {
            throw new EnunciateException(declaration.getQualifiedName() + ": an interface must not be annotated with @XmlType.");
        }
        if (this.isEnumType(declaration = this.narrowToAdaptingType(declaration))) {
            if (declaration.getAnnotation(XmlQNameEnum.class) != null) {
                return new QNameEnumTypeDefinition(declaration, this);
            }
            return new EnumTypeDefinition(declaration, this);
        }
        ObjectTypeDefinition typeDef = new ObjectTypeDefinition(declaration, this);
        if (typeDef.getValue() != null && this.hasNoMembers(typeDef)) {
            return new SimpleTypeDefinition(typeDef);
        }
        return typeDef;
    }

    protected TypeElement narrowToAdaptingType(TypeElement declaration) {
        AdapterType adapterType = JacksonUtil.findAdapterType(declaration, this);
        if (adapterType != null) {
            TypeMirror adaptingType = adapterType.getAdaptingType();
            if (adaptingType.getKind() != TypeKind.DECLARED) {
                return declaration;
            }
            TypeElement adaptingDeclaration = (TypeElement)((DeclaredType)adaptingType).asElement();
            if (adaptingDeclaration == null) {
                throw new EnunciateException(String.format("Class %s is being adapted by a type (%s) that doesn't seem to be on the classpath.", declaration.getQualifiedName(), adaptingType));
            }
            return adaptingDeclaration;
        }
        return declaration;
    }

    protected boolean isEnumType(TypeElement declaration) {
        JsonFormat format = declaration.getAnnotation(JsonFormat.class);
        if (format != null && format.shape() == JsonFormat.Shape.OBJECT) {
            return false;
        }
        return declaration.getKind() == ElementKind.ENUM;
    }

    protected boolean hasNoMembers(TypeDefinition typeDef) {
        TypeElement superDeclaration;
        boolean none = typeDef.getMembers().isEmpty();
        TypeMirror superclass = typeDef.getSuperclass();
        if (superclass instanceof DeclaredType && (superDeclaration = (TypeElement)((DeclaredType)superclass).asElement()) != null && !Object.class.getName().equals(superDeclaration.getQualifiedName().toString())) {
            none &= this.hasNoMembers(new ObjectTypeDefinition(superDeclaration, this));
        }
        return none;
    }

    public boolean isKnownTypeDefinition(TypeElement el) {
        return this.findTypeDefinition(el) != null || this.isKnownType(el);
    }

    public boolean isIgnored(Element el) {
        return IgnoreUtils.isIgnored((Element)el) || el.getAnnotation(JsonIgnore.class) != null && el.getAnnotation(JsonIgnore.class).value();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TypeDefinition typeDef, LinkedList<Element> stack) {
        if (this.findTypeDefinition((Element)((Object)typeDef)) == null && !this.isKnownType((TypeElement)((Object)typeDef))) {
            this.typeDefinitions.put(typeDef.getQualifiedName().toString(), typeDef);
            if (this.context.isExcluded((Element)((Object)typeDef))) {
                this.warn("Added %s as a Jackson type definition even though is was supposed to be excluded according to configuration. It was referenced from %s%s, so it had to be included to prevent broken references.", new Object[]{typeDef.getQualifiedName(), stack.size() > 0 ? stack.get(0) : "an unknown location", stack.size() > 1 ? " of " + stack.get(1) : ""});
            } else {
                this.debug("Added %s as a Jackson type definition.", new Object[]{typeDef.getQualifiedName()});
            }
            if (this.getContext().getProcessingEnvironment().findSourcePosition((Element)((Object)typeDef)) == null) {
                OneTimeLogMessage.SOURCE_FILES_NOT_FOUND.log(this.getContext());
                this.debug("Unable to find source file for %s.", new Object[]{typeDef.getQualifiedName()});
            }
            typeDef.getReferencedFrom().addAll(stack);
            try {
                stack.push((Element)((Object)typeDef));
                this.addSeeAlsoTypeDefinitions((Element)((Object)typeDef), stack);
                for (Member member : typeDef.getMembers()) {
                    this.addReferencedTypeDefinitions(member, stack);
                }
                Value value = typeDef.getValue();
                if (value != null) {
                    this.addReferencedTypeDefinitions(value, stack);
                }
                TypeMirror superclass = typeDef.getSuperclass();
                if (!typeDef.isEnum() && superclass != null && superclass.getKind() != TypeKind.NONE && !this.isCollapseTypeHierarchy()) {
                    this.addReferencedTypeDefinitions(superclass, stack);
                }
            }
            finally {
                stack.pop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addReferencedTypeDefinitions(Accessor accessor, LinkedList<Element> stack) {
        stack.push((Element)((Object)accessor));
        try {
            this.addSeeAlsoTypeDefinitions((Element)((Object)accessor), stack);
            DecoratedTypeMirror enumRef = accessor.getQNameEnumRef();
            if (enumRef != null) {
                this.addReferencedTypeDefinitions((TypeMirror)enumRef, stack);
            }
        }
        finally {
            stack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addReferencedTypeDefinitions(Value value, LinkedList<Element> stack) {
        stack.push((Element)((Object)value));
        try {
            this.addReferencedTypeDefinitions((Accessor)value, stack);
            if (value.isAdapted()) {
                this.addReferencedTypeDefinitions((TypeMirror)((Object)value.getAdapterType()), stack);
            } else if (value.getQNameEnumRef() == null) {
                this.addReferencedTypeDefinitions((TypeMirror)value.getAccessorType(), stack);
            }
        }
        finally {
            stack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addReferencedTypeDefinitions(Member member, LinkedList<Element> stack) {
        this.addReferencedTypeDefinitions((Accessor)member, stack);
        stack.push((Element)((Object)member));
        try {
            for (Member member2 : member.getChoices()) {
                if (member2.isAdapted()) {
                    this.addReferencedTypeDefinitions((TypeMirror)((Object)member2.getAdapterType()), stack);
                    continue;
                }
                if (member2.getQNameEnumRef() != null) continue;
                this.addReferencedTypeDefinitions((TypeMirror)member2.getAccessorType(), stack);
            }
        }
        finally {
            stack.pop();
        }
    }

    protected void addReferencedTypeDefinitions(TypeMirror type, LinkedList<Element> stack) {
        type.accept(new ReferencedJsonDefinitionVisitor(), new ReferenceContext(stack));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void addSeeAlsoTypeDefinitions(Element declaration, LinkedList<Element> stack) {
        JsonSeeAlso seeAlso;
        Class clazz;
        JsonSubTypes subTypes = declaration.getAnnotation(JsonSubTypes.class);
        if (subTypes != null) {
            JsonSubTypes.Type[] types;
            Elements elementUtils = this.getContext().getProcessingEnvironment().getElementUtils();
            Types typeUtils = this.getContext().getProcessingEnvironment().getTypeUtils();
            for (JsonSubTypes.Type type : types = subTypes.value()) {
                try {
                    stack.push(elementUtils.getTypeElement(JsonSubTypes.class.getName()));
                    clazz = type.value();
                    this.add(this.createTypeDefinition(elementUtils.getTypeElement(clazz.getName())), stack);
                }
                catch (MirroredTypeException e) {
                    TypeMirror mirror = e.getTypeMirror();
                    Element element = typeUtils.asElement(mirror);
                    if (!(element instanceof TypeElement)) continue;
                    this.add(this.createTypeDefinition((TypeElement)element), stack);
                }
                catch (MirroredTypesException e) {
                    List<? extends TypeMirror> mirrors = e.getTypeMirrors();
                    for (TypeMirror typeMirror : mirrors) {
                        Element element = typeUtils.asElement(typeMirror);
                        if (!(element instanceof TypeElement)) continue;
                        this.add(this.createTypeDefinition((TypeElement)element), stack);
                    }
                }
                finally {
                    stack.pop();
                }
            }
        }
        if ((seeAlso = declaration.getAnnotation(JsonSeeAlso.class)) != null) {
            Elements elementUtils = this.getContext().getProcessingEnvironment().getElementUtils();
            Types typeUtils = this.getContext().getProcessingEnvironment().getTypeUtils();
            stack.push(elementUtils.getTypeElement(JsonSeeAlso.class.getName()));
            try {
                void var10_19;
                Class[] classes;
                Class[] arr$ = classes = seeAlso.value();
                int len$ = arr$.length;
                boolean bl = false;
                while (var10_19 < len$) {
                    clazz = arr$[var10_19];
                    this.add(this.createTypeDefinition(elementUtils.getTypeElement(clazz.getName())), stack);
                    ++var10_19;
                }
            }
            catch (MirroredTypeException e) {
                TypeMirror mirror = e.getTypeMirror();
                Element element = typeUtils.asElement(mirror);
                if (element instanceof TypeElement) {
                    this.add(this.createTypeDefinition((TypeElement)element), stack);
                }
            }
            catch (MirroredTypesException e) {
                List<? extends TypeMirror> mirrors = e.getTypeMirrors();
                for (TypeMirror typeMirror : mirrors) {
                    Element element = typeUtils.asElement(typeMirror);
                    if (!(element instanceof TypeElement)) continue;
                    this.add(this.createTypeDefinition((TypeElement)element), stack);
                }
            }
            finally {
                stack.pop();
            }
        }
    }

    protected boolean isKnownType(TypeElement typeDef) {
        return this.knownTypes.containsKey(typeDef.getQualifiedName().toString()) || ((DecoratedTypeMirror)typeDef.asType()).isInstanceOf(JAXBElement.class);
    }

    public String getSlug(TypeDefinition typeDefinition) {
        String[] qualifiedNameTokens = typeDefinition.getQualifiedName().toString().split("\\.");
        String slug = "";
        for (int i = qualifiedNameTokens.length - 1; i >= 0; --i) {
            TypeDefinition entry = this.typeDefinitionsBySlug.get(slug = slug.isEmpty() ? qualifiedNameTokens[i] : slug + "_" + qualifiedNameTokens[i]);
            if (entry == null) {
                entry = typeDefinition;
                this.typeDefinitionsBySlug.put(slug, entry);
            }
            if (!entry.getQualifiedName().toString().equals(typeDefinition.getQualifiedName().toString())) continue;
            return slug;
        }
        return slug;
    }

    private class JacksonNamespace
    implements Namespace {
        private JacksonNamespace() {
        }

        public String getUri() {
            return null;
        }

        public InterfaceDescriptionFile getSchemaFile() {
            return null;
        }

        public List<? extends DataType> getTypes() {
            Collection<TypeDefinition> typeDefinitions = EnunciateJacksonContext.this.getTypeDefinitions();
            ArrayList<DataTypeImpl> dataTypes = new ArrayList<DataTypeImpl>();
            FacetFilter facetFilter = EnunciateJacksonContext.this.getContext().getConfiguration().getFacetFilter();
            for (TypeDefinition typeDefinition : typeDefinitions) {
                if (!facetFilter.accept((HasFacets)typeDefinition)) continue;
                if (typeDefinition instanceof ObjectTypeDefinition) {
                    dataTypes.add(new ObjectDataTypeImpl((ObjectTypeDefinition)typeDefinition));
                    continue;
                }
                if (!(typeDefinition instanceof EnumTypeDefinition)) continue;
                dataTypes.add(new EnumDataTypeImpl((EnumTypeDefinition)typeDefinition));
            }
            Collections.sort(dataTypes, new Comparator<DataType>(){

                @Override
                public int compare(DataType o1, DataType o2) {
                    return o1.getLabel().compareTo(o2.getLabel());
                }
            });
            return dataTypes;
        }
    }

    private static class ReferenceContext {
        LinkedList<Element> referenceStack;
        LinkedList<Element> recursionStack;

        public ReferenceContext(LinkedList<Element> referenceStack) {
            this.referenceStack = referenceStack;
            this.recursionStack = new LinkedList();
        }
    }

    private class ReferencedJsonDefinitionVisitor
    extends SimpleTypeVisitor6<Void, ReferenceContext> {
        private ReferencedJsonDefinitionVisitor() {
        }

        @Override
        public Void visitArray(ArrayType t, ReferenceContext context) {
            return t.getComponentType().accept(this, context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Void visitDeclared(DeclaredType declaredType, ReferenceContext context) {
            TypeElement declaration = (TypeElement)declaredType.asElement();
            if (declaration.getKind() == ElementKind.ENUM) {
                if (EnunciateJacksonContext.this.isKnownTypeDefinition(declaration)) return null;
                EnunciateJacksonContext.this.add(EnunciateJacksonContext.this.createTypeDefinition(declaration), context.referenceStack);
                return null;
            } else if (declaredType instanceof AdapterType) {
                ((AdapterType)((Object)declaredType)).getAdaptingType().accept(this, context);
                return null;
            } else if (MapType.findMapType(declaredType, EnunciateJacksonContext.this) == null) {
                String qualifiedName = declaration.getQualifiedName().toString();
                if (Object.class.getName().equals(qualifiedName)) {
                    return null;
                }
                if (context.recursionStack.contains(declaration)) {
                    return null;
                }
                context.recursionStack.push(declaration);
                try {
                    List<? extends TypeMirror> typeArgs;
                    if (!(EnunciateJacksonContext.this.isKnownTypeDefinition(declaration) || EnunciateJacksonContext.this.isIgnored(declaration) || declaration.getKind() != ElementKind.CLASS || ((DecoratedDeclaredType)declaredType).isCollection() || ((DecoratedDeclaredType)declaredType).isInstanceOf(JAXBElement.class))) {
                        EnunciateJacksonContext.this.add(EnunciateJacksonContext.this.createTypeDefinition(declaration), context.referenceStack);
                    }
                    if ((typeArgs = declaredType.getTypeArguments()) == null) return null;
                    for (TypeMirror typeMirror : typeArgs) {
                        typeMirror.accept(this, context);
                    }
                    return null;
                }
                finally {
                    context.recursionStack.pop();
                }
            } else {
                List<? extends TypeMirror> typeArgs = declaredType.getTypeArguments();
                if (typeArgs == null) return null;
                for (TypeMirror typeMirror : typeArgs) {
                    typeMirror.accept(this, context);
                }
            }
            return null;
        }

        @Override
        public Void visitTypeVariable(TypeVariable t, ReferenceContext context) {
            return t.getUpperBound().accept(this, context);
        }

        @Override
        public Void visitWildcard(WildcardType t, ReferenceContext context) {
            TypeMirror superBound;
            TypeMirror extendsBound = t.getExtendsBound();
            if (extendsBound != null) {
                extendsBound.accept(this, context);
            }
            if ((superBound = t.getSuperBound()) != null) {
                superBound.accept(this, context);
            }
            return null;
        }

        @Override
        public Void visitUnknown(TypeMirror t, ReferenceContext context) {
            return (Void)this.defaultAction(t, context);
        }
    }
}

