/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jackson.api.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.webcohesion.enunciate.api.datatype.BaseType;
import com.webcohesion.enunciate.api.datatype.DataTypeReference;
import com.webcohesion.enunciate.api.datatype.Example;
import com.webcohesion.enunciate.api.datatype.Property;
import com.webcohesion.enunciate.api.datatype.Value;
import com.webcohesion.enunciate.facets.FacetFilter;
import com.webcohesion.enunciate.facets.HasFacets;
import com.webcohesion.enunciate.modules.jackson.api.impl.DataTypeImpl;
import com.webcohesion.enunciate.modules.jackson.api.impl.DataTypeReferenceImpl;
import com.webcohesion.enunciate.modules.jackson.api.impl.ExampleImpl;
import com.webcohesion.enunciate.modules.jackson.api.impl.PropertyImpl;
import com.webcohesion.enunciate.modules.jackson.model.Member;
import com.webcohesion.enunciate.modules.jackson.model.ObjectTypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonClassType;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonType;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;

public class ObjectDataTypeImpl
extends DataTypeImpl {
    private final ObjectTypeDefinition typeDefinition;

    public ObjectDataTypeImpl(ObjectTypeDefinition typeDefinition) {
        super(typeDefinition);
        this.typeDefinition = typeDefinition;
    }

    public BaseType getBaseType() {
        return BaseType.object;
    }

    public List<? extends Value> getValues() {
        return null;
    }

    public List<? extends Property> getProperties() {
        SortedSet<Member> members = this.typeDefinition.getMembers();
        ArrayList<PropertyImpl> properties = new ArrayList<PropertyImpl>(members.size());
        FacetFilter facetFilter = this.typeDefinition.getContext().getContext().getConfiguration().getFacetFilter();
        for (Member member : members) {
            if (!facetFilter.accept((HasFacets)member)) continue;
            if (member.getChoices().size() > 1) {
                JsonTypeInfo.As inclusion = member.getSubtypeIdInclusion();
                if (inclusion == JsonTypeInfo.As.WRAPPER_ARRAY || inclusion == JsonTypeInfo.As.WRAPPER_OBJECT) {
                    for (Member member2 : member.getChoices()) {
                        properties.add(new PropertyImpl(member2));
                    }
                    continue;
                }
                properties.add(new PropertyImpl(member));
                continue;
            }
            properties.add(new PropertyImpl(member));
        }
        return properties;
    }

    public List<? extends Property> getRequiredProperties() {
        ArrayList<Property> requiredProperties = new ArrayList<Property>();
        for (Property property : this.getProperties()) {
            if (!property.isRequired()) continue;
            requiredProperties.add(property);
        }
        return requiredProperties;
    }

    @Override
    public List<DataTypeReference> getSupertypes() {
        ArrayList<DataTypeReferenceImpl> supertypes = null;
        JsonType supertype = this.typeDefinition.getSupertype();
        while (supertype != null) {
            if (supertypes == null) {
                supertypes = new ArrayList<DataTypeReferenceImpl>();
            }
            supertypes.add(new DataTypeReferenceImpl(supertype));
            supertype = supertype instanceof JsonClassType ? (((JsonClassType)supertype).getTypeDefinition() instanceof ObjectTypeDefinition ? ((ObjectTypeDefinition)((JsonClassType)supertype).getTypeDefinition()).getSupertype() : null) : null;
        }
        return supertypes;
    }

    @Override
    public Example getExample() {
        return new ExampleImpl(this.typeDefinition);
    }
}

