/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jackson.model;

import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.modules.jackson.EnunciateJacksonContext;
import com.webcohesion.enunciate.modules.jackson.model.EnumValue;
import com.webcohesion.enunciate.modules.jackson.model.SimpleTypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonType;
import com.webcohesion.enunciate.modules.jackson.model.types.KnownJsonType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.xml.bind.annotation.XmlEnumValue;

public class EnumTypeDefinition
extends SimpleTypeDefinition {
    private List<EnumValue> enumValues;

    public EnumTypeDefinition(TypeElement delegate, EnunciateJacksonContext context) {
        super(delegate, context);
    }

    protected List<EnumValue> loadEnumValues() {
        List enumConstants = this.enumValues();
        ArrayList<EnumValue> enumValueMap = new ArrayList<EnumValue>();
        HashSet<String> enumValues = new HashSet<String>(enumConstants.size());
        for (VariableElement enumConstant : enumConstants) {
            XmlEnumValue enumValue;
            String value = enumConstant.getSimpleName().toString();
            if (this.context.isHonorJaxb() && (enumValue = enumConstant.getAnnotation(XmlEnumValue.class)) != null) {
                value = enumValue.value();
            }
            if (!enumValues.add(value)) {
                throw new EnunciateException(this.getQualifiedName() + ": duplicate enum value: " + value);
            }
            enumValueMap.add(new EnumValue(this, enumConstant, enumConstant.getSimpleName().toString(), value));
        }
        return enumValueMap;
    }

    @Override
    public JsonType getBaseType() {
        return KnownJsonType.STRING;
    }

    public List<EnumValue> getEnumValues() {
        if (this.enumValues == null) {
            this.enumValues = this.loadEnumValues();
        }
        return this.enumValues;
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return true;
    }
}

