/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jackson.api.impl;

import com.webcohesion.enunciate.api.datatype.BaseType;
import com.webcohesion.enunciate.api.datatype.DataType;
import com.webcohesion.enunciate.api.datatype.DataTypeReference;
import com.webcohesion.enunciate.modules.jackson.api.impl.DataTypeImpl;
import com.webcohesion.enunciate.modules.jackson.api.impl.EnumDataTypeImpl;
import com.webcohesion.enunciate.modules.jackson.api.impl.ObjectDataTypeImpl;
import com.webcohesion.enunciate.modules.jackson.model.EnumTypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.ObjectTypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.SimpleTypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.TypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonArrayType;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonClassType;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonMapType;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonType;
import java.util.LinkedList;
import java.util.List;

public class DataTypeReferenceImpl
implements DataTypeReference {
    private final String label;
    private final String slug;
    private final List<DataTypeReference.ContainerType> containers;
    private final DataType dataType;
    private final JsonType jsonType;

    public DataTypeReferenceImpl(JsonType jsonType) {
        String label;
        LinkedList<DataTypeReference.ContainerType> containers = null;
        String slug = null;
        DataTypeImpl dataType = null;
        while (jsonType instanceof JsonArrayType || jsonType instanceof JsonClassType && ((JsonClassType)jsonType).getTypeDefinition() instanceof SimpleTypeDefinition) {
            if (jsonType instanceof JsonArrayType) {
                containers = containers == null ? new LinkedList<DataTypeReference.ContainerType>() : containers;
                containers.push(DataTypeReference.ContainerType.array);
                jsonType = ((JsonArrayType)jsonType).getComponentType();
                continue;
            }
            if (((JsonClassType)jsonType).getTypeDefinition() instanceof EnumTypeDefinition) break;
            jsonType = ((SimpleTypeDefinition)((JsonClassType)jsonType).getTypeDefinition()).getBaseType();
        }
        if (jsonType instanceof JsonClassType) {
            TypeDefinition typeDef = ((JsonClassType)jsonType).getTypeDefinition();
            if (typeDef instanceof ObjectTypeDefinition) {
                dataType = new ObjectDataTypeImpl((ObjectTypeDefinition)typeDef);
            } else if (typeDef instanceof EnumTypeDefinition) {
                dataType = new EnumDataTypeImpl((EnumTypeDefinition)typeDef);
            } else {
                throw new IllegalStateException();
            }
            label = dataType.getLabel();
            slug = dataType.getSlug();
        } else if (jsonType instanceof JsonMapType) {
            label = "object";
        } else {
            String string = jsonType.isBoolean() ? "boolean" : (jsonType.isNumber() ? "number" : (label = jsonType.isString() ? "string" : "object"));
            if (jsonType.isArray()) {
                containers = containers == null ? new LinkedList<DataTypeReference.ContainerType>() : containers;
                containers.push(DataTypeReference.ContainerType.array);
            }
        }
        this.jsonType = jsonType;
        this.label = label;
        this.slug = slug;
        this.containers = containers;
        this.dataType = dataType;
    }

    public JsonType getJsonType() {
        return this.jsonType;
    }

    public BaseType getBaseType() {
        return this.jsonType.isBoolean() ? BaseType.bool : (this.jsonType.isNumber() ? BaseType.number : (this.jsonType.isString() ? BaseType.string : BaseType.object));
    }

    public String getLabel() {
        return this.label;
    }

    public String getSlug() {
        return this.slug;
    }

    public List<DataTypeReference.ContainerType> getContainers() {
        return this.containers;
    }

    public DataType getValue() {
        return this.dataType;
    }
}

