/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxb.api.impl;

import com.webcohesion.enunciate.api.datatype.DataTypeReference;
import com.webcohesion.enunciate.api.datatype.Property;
import com.webcohesion.enunciate.api.datatype.PropertyMetadata;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedElement;
import com.webcohesion.enunciate.javac.decorations.element.ElementUtils;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.modules.jaxb.api.impl.DataTypeReferenceImpl;
import com.webcohesion.enunciate.modules.jaxb.model.Accessor;
import com.webcohesion.enunciate.modules.jaxb.model.Attribute;
import com.webcohesion.enunciate.modules.jaxb.model.Element;
import com.webcohesion.enunciate.modules.jaxb.model.Value;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;

public class PropertyImpl
implements Property {
    private final Accessor accessor;

    public PropertyImpl(Accessor accessor) {
        this.accessor = accessor;
    }

    public String getName() {
        if (this.accessor.isValue()) {
            return "(value)";
        }
        return this.accessor.getName();
    }

    public String getType() {
        return this.accessor.isAttribute() ? "attribute" : (this.accessor.isValue() ? "(value)" : "element");
    }

    public PropertyMetadata getNamespaceInfo() {
        return new PropertyMetadata(this.getNamespacePrefix(), this.getNamespace(), null);
    }

    public String getNamespacePrefix() {
        String namespace = this.getNamespace();
        String prefix = this.accessor.getContext().getNamespacePrefixes().get(namespace);
        if (namespace == null || "".equals(namespace)) {
            prefix = "";
        }
        return prefix;
    }

    public String getNamespace() {
        return this.accessor.getNamespace();
    }

    public String getMinMaxOccurs() {
        String minMaxOccurs = null;
        if (this.accessor instanceof Attribute) {
            minMaxOccurs = String.format("%s/1", ((Attribute)this.accessor).isRequired() ? "1" : "0");
        } else if (this.accessor instanceof Value) {
            minMaxOccurs = "0/1";
        }
        if (this.accessor instanceof Element) {
            minMaxOccurs = String.format("%s/%s", ((Element)this.accessor).getMinOccurs(), ((Element)this.accessor).getMaxOccurs());
        }
        return minMaxOccurs;
    }

    public String getDefaultValue() {
        String defaultValue = null;
        if (this.accessor instanceof Element) {
            defaultValue = ((Element)this.accessor).getDefaultValue();
        }
        return defaultValue;
    }

    public String getDescription() {
        JavaDoc.JavaDocTagList tags;
        JavaDoc doc = this.accessor.getJavaDoc();
        String description = doc.toString();
        if (description.trim().isEmpty()) {
            description = null;
        }
        if (description == null && (tags = (JavaDoc.JavaDocTagList)doc.get((Object)"return")) != null && !tags.isEmpty()) {
            description = tags.toString();
        }
        return description;
    }

    public boolean isAttribute() {
        return this.accessor.isAttribute();
    }

    public DataTypeReference getDataType() {
        return new DataTypeReferenceImpl(this.accessor.getXmlType(), this.accessor.isXmlList());
    }

    public String getDeprecated() {
        return ElementUtils.findDeprecationMessage((DecoratedElement)this.accessor);
    }

    public Map<String, AnnotationMirror> getAnnotations() {
        return this.accessor.getAnnotations();
    }
}

