/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxb.model;

import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.javac.decorations.Annotations;
import com.webcohesion.enunciate.javac.decorations.TypeMirrorDecorator;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.javac.decorations.type.TypeMirrorUtils;
import com.webcohesion.enunciate.modules.jaxb.EnunciateJaxbContext;
import com.webcohesion.enunciate.modules.jaxb.model.SimpleTypeDefinition;
import com.webcohesion.enunciate.modules.jaxb.model.types.KnownXmlType;
import com.webcohesion.enunciate.modules.jaxb.model.types.XmlType;
import com.webcohesion.enunciate.modules.jaxb.model.types.XmlTypeFactory;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

public class EnumTypeDefinition
extends SimpleTypeDefinition {
    private final XmlEnum xmlEnum = (XmlEnum)this.getAnnotation(XmlEnum.class);
    private Map<String, Object> enumValues;

    public EnumTypeDefinition(TypeElement delegate, EnunciateJaxbContext context) {
        super(delegate, context);
    }

    protected Map<String, Object> loadEnumValues() {
        List enumConstants = this.getEnumConstants();
        LinkedHashMap<String, Object> enumValueMap = new LinkedHashMap<String, Object>();
        HashSet<String> enumValues = new HashSet<String>(enumConstants.size());
        for (VariableElement enumConstant : enumConstants) {
            String value = enumConstant.getSimpleName().toString();
            XmlEnumValue enumValue = enumConstant.getAnnotation(XmlEnumValue.class);
            if (enumValue != null) {
                value = enumValue.value();
            }
            if (!enumValues.add(value)) {
                throw new EnunciateException(this.getQualifiedName() + ": duplicate enum value: " + value);
            }
            enumValueMap.put(enumConstant.getSimpleName().toString(), value);
        }
        return enumValueMap;
    }

    @Override
    public XmlType getBaseType() {
        XmlType xmlType = KnownXmlType.STRING;
        if (this.xmlEnum != null) {
            DecoratedTypeMirror typeMirror = Annotations.mirrorOf((Callable)new Callable<Class<?>>(){

                @Override
                public Class<?> call() throws Exception {
                    return EnumTypeDefinition.this.xmlEnum.value();
                }
            }, (ProcessingEnvironment)this.env);
            xmlType = XmlTypeFactory.getXmlType((TypeMirror)typeMirror, this.context);
        }
        return xmlType;
    }

    public DecoratedTypeMirror getEnumBaseClass() {
        try {
            return TypeMirrorUtils.mirrorOf((Class)(this.xmlEnum == null ? String.class : this.xmlEnum.value()), (ProcessingEnvironment)this.env);
        }
        catch (MirroredTypeException e) {
            return (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)e.getTypeMirror(), (ProcessingEnvironment)this.env);
        }
    }

    public Map<String, Object> getEnumValues() {
        if (this.enumValues == null) {
            this.enumValues = this.loadEnumValues();
        }
        return this.enumValues;
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return this.getAnnotation(XmlJavaTypeAdapter.class) == null;
    }
}

