/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxb.model;

import com.webcohesion.enunciate.api.InterfaceDescriptionFile;
import com.webcohesion.enunciate.javac.TypeElementComparator;
import com.webcohesion.enunciate.modules.jaxb.EnunciateJaxbContext;
import com.webcohesion.enunciate.modules.jaxb.model.Attribute;
import com.webcohesion.enunciate.modules.jaxb.model.Element;
import com.webcohesion.enunciate.modules.jaxb.model.ImplicitChildElement;
import com.webcohesion.enunciate.modules.jaxb.model.ImplicitRootElement;
import com.webcohesion.enunciate.modules.jaxb.model.ImplicitSchemaAttribute;
import com.webcohesion.enunciate.modules.jaxb.model.ImplicitSchemaElement;
import com.webcohesion.enunciate.modules.jaxb.model.LocalElementDeclaration;
import com.webcohesion.enunciate.modules.jaxb.model.QNameEnumTypeDefinition;
import com.webcohesion.enunciate.modules.jaxb.model.Registry;
import com.webcohesion.enunciate.modules.jaxb.model.RootElementDeclaration;
import com.webcohesion.enunciate.modules.jaxb.model.Schema;
import com.webcohesion.enunciate.modules.jaxb.model.TypeDefinition;
import com.webcohesion.enunciate.modules.jaxb.model.Value;
import com.webcohesion.enunciate.modules.jaxb.model.types.MapXmlType;
import com.webcohesion.enunciate.modules.jaxb.model.types.XmlClassType;
import com.webcohesion.enunciate.modules.jaxb.model.types.XmlType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;

public class SchemaInfo {
    private String id;
    private String namespace;
    private String filename;
    private String jaxbBindingVersion;
    private String appinfo;
    private String explicitLocation;
    private InterfaceDescriptionFile schemaFile;
    private final EnunciateJaxbContext context;
    private final Collection<ImplicitSchemaElement> implicitSchemaElements = new TreeSet<ImplicitSchemaElement>(new ImplicitSchemaElementComparator());
    private final Collection<ImplicitSchemaAttribute> implicitSchemaAttributes = new TreeSet<ImplicitSchemaAttribute>(new ImplicitSchemaAttributeComparator());
    private final Collection<TypeDefinition> typeDefinitions = new TreeSet<TypeDefinition>((Comparator<TypeDefinition>)new TypeElementComparator());
    private final Collection<RootElementDeclaration> rootElements = new TreeSet<RootElementDeclaration>((Comparator<RootElementDeclaration>)new TypeElementComparator());
    private final Collection<Registry> registries = new ArrayList<Registry>();
    private final Collection<LocalElementDeclaration> localElementDeclarations = new ArrayList<LocalElementDeclaration>();
    private final TreeSet<Schema> packages = new TreeSet();

    public SchemaInfo(EnunciateJaxbContext context) {
        this.context = context;
    }

    public EnunciateJaxbContext getContext() {
        return this.context;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public InterfaceDescriptionFile getSchemaFile() {
        return this.schemaFile;
    }

    public void setSchemaFile(InterfaceDescriptionFile schemaFile) {
        this.schemaFile = schemaFile;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getJaxbBindingVersion() {
        return this.jaxbBindingVersion;
    }

    public void setJaxbBindingVersion(String jaxbBindingVersion) {
        this.jaxbBindingVersion = jaxbBindingVersion;
    }

    public String getAppinfo() {
        return this.appinfo;
    }

    public void setAppinfo(String appinfo) {
        this.appinfo = appinfo;
    }

    public String getExplicitLocation() {
        return this.explicitLocation;
    }

    public void setExplicitLocation(String explicitLocation) {
        this.explicitLocation = explicitLocation;
    }

    public Collection<TypeDefinition> getTypeDefinitions() {
        return this.typeDefinitions;
    }

    public Collection<ImplicitSchemaElement> getImplicitSchemaElements() {
        return this.implicitSchemaElements;
    }

    public Collection<ImplicitSchemaAttribute> getImplicitSchemaAttributes() {
        return this.implicitSchemaAttributes;
    }

    public Collection<RootElementDeclaration> getRootElements() {
        return this.rootElements;
    }

    public Collection<Registry> getRegistries() {
        return this.registries;
    }

    public Collection<LocalElementDeclaration> getLocalElementDeclarations() {
        return this.localElementDeclarations;
    }

    public Set<Schema> getPackages() {
        return this.packages;
    }

    public String getElementFormDefault() {
        for (Schema pckg : this.getPackages()) {
            if (pckg.getElementFormDefault() == null) continue;
            return pckg.getElementFormDefault().toString().toLowerCase();
        }
        return null;
    }

    public String getAttributeFormDefault() {
        for (Schema pckg : this.getPackages()) {
            if (pckg.getAttributeFormDefault() == null) continue;
            return pckg.getAttributeFormDefault().toString().toLowerCase();
        }
        return null;
    }

    public String getDocumentation() {
        for (Schema pckg : this.getPackages()) {
            String docValue = pckg.getDocValue();
            if (docValue == null) continue;
            return docValue;
        }
        return null;
    }

    public Set<String> getReferencedNamespaces() {
        QName typeQName;
        HashSet<String> referencedNamespaces = new HashSet<String>();
        for (TypeDefinition typeDefinition : this.getTypeDefinitions()) {
            this.addReferencedNamespaces(typeDefinition, referencedNamespaces);
        }
        for (RootElementDeclaration rootElement : this.getRootElements()) {
            referencedNamespaces.add(rootElement.getNamespace());
            referencedNamespaces.add(rootElement.getTypeDefinition().getNamespace());
        }
        for (ImplicitSchemaElement schemaElement : this.implicitSchemaElements) {
            typeQName = schemaElement.getTypeQName();
            if (typeQName != null) {
                referencedNamespaces.add(typeQName.getNamespaceURI());
            }
            if (!(schemaElement instanceof ImplicitRootElement)) continue;
            for (ImplicitChildElement childElement : ((ImplicitRootElement)schemaElement).getChildElements()) {
                this.addReferencedNamespaces(childElement.getXmlType(), new LinkedList<String>(), referencedNamespaces);
            }
        }
        for (ImplicitSchemaAttribute schemaAttribute : this.implicitSchemaAttributes) {
            typeQName = schemaAttribute.getTypeQName();
            if (typeQName == null) continue;
            referencedNamespaces.add(typeQName.getNamespaceURI());
        }
        for (LocalElementDeclaration localElementDeclaration : this.localElementDeclarations) {
            typeQName = localElementDeclaration.getElementXmlType().getQname();
            if (typeQName == null) continue;
            referencedNamespaces.add(typeQName.getNamespaceURI());
        }
        referencedNamespaces.add(this.getNamespace());
        referencedNamespaces.remove("http://www.w3.org/2001/XMLSchema");
        if (referencedNamespaces.remove(null)) {
            referencedNamespaces.add("");
        }
        return referencedNamespaces;
    }

    private void addReferencedNamespaces(TypeDefinition typeDefinition, Set<String> referencedNamespaces) {
        this.addReferencedNamespaces(typeDefinition, new LinkedList<String>(), referencedNamespaces);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addReferencedNamespaces(TypeDefinition typeDefinition, LinkedList<String> stack, Set<String> referencedNamespaces) {
        if (stack.contains(typeDefinition.getQualifiedName().toString())) {
            return;
        }
        stack.push(typeDefinition.getQualifiedName().toString());
        try {
            for (Attribute attribute : typeDefinition.getAttributes()) {
                QName ref = attribute.getRef();
                if (ref != null) {
                    referencedNamespaces.add(ref.getNamespaceURI());
                    continue;
                }
                this.addReferencedNamespaces(attribute.getBaseType(), stack, referencedNamespaces);
            }
            for (Element element : typeDefinition.getElements()) {
                for (Element element2 : element.getChoices()) {
                    QName ref = element2.getRef();
                    if (ref != null) {
                        referencedNamespaces.add(ref.getNamespaceURI());
                        continue;
                    }
                    this.addReferencedNamespaces(element2.getBaseType(), stack, referencedNamespaces);
                }
            }
            Value value = typeDefinition.getValue();
            if (value != null) {
                this.addReferencedNamespaces(value.getBaseType(), stack, referencedNamespaces);
            }
            if (typeDefinition instanceof QNameEnumTypeDefinition) {
                for (Object qnameValue : ((QNameEnumTypeDefinition)typeDefinition).getEnumValues().values()) {
                    QName qName = (QName)qnameValue;
                    if (qName == null) continue;
                    referencedNamespaces.add(qName.getNamespaceURI());
                }
            }
            this.addReferencedNamespaces(typeDefinition.getBaseType(), stack, referencedNamespaces);
        }
        finally {
            stack.pop();
        }
    }

    private void addReferencedNamespaces(XmlType xmlType, LinkedList<String> stack, Set<String> referencedNamespaces) {
        if (!xmlType.isAnonymous()) {
            referencedNamespaces.add(xmlType.getNamespace());
        } else if (xmlType instanceof MapXmlType) {
            referencedNamespaces.add(((MapXmlType)xmlType).getKeyType().getNamespace());
            referencedNamespaces.add(((MapXmlType)xmlType).getValueType().getNamespace());
        }
        if (xmlType instanceof XmlClassType) {
            this.addReferencedNamespaces(((XmlClassType)xmlType).getTypeDefinition(), stack, referencedNamespaces);
        }
    }

    public List<SchemaInfo> getImportedSchemas() {
        Set<String> importedNamespaces = this.getReferencedNamespaces();
        importedNamespaces.remove(this.getNamespace() == null ? "" : this.getNamespace());
        ArrayList<SchemaInfo> schemas = new ArrayList<SchemaInfo>();
        for (String ns : importedNamespaces) {
            SchemaInfo schema = this.lookupSchema(ns);
            if (schema != null) {
                schemas.add(schema);
                continue;
            }
            SchemaInfo schemaInfo = new SchemaInfo(this.context);
            schemaInfo.setNamespace(ns);
            schemas.add(schemaInfo);
        }
        return schemas;
    }

    protected SchemaInfo lookupSchema(String namespace) {
        if ("".equals(namespace)) {
            namespace = null;
        }
        return this.context.getSchemas().get(namespace);
    }

    private static class ImplicitSchemaAttributeComparator
    implements Comparator<ImplicitSchemaAttribute> {
        private ImplicitSchemaAttributeComparator() {
        }

        @Override
        public int compare(ImplicitSchemaAttribute attribute1, ImplicitSchemaAttribute attribute2) {
            return attribute1.getAttributeName().compareTo(attribute2.getAttributeName());
        }
    }

    private static class ImplicitSchemaElementComparator
    implements Comparator<ImplicitSchemaElement> {
        private ImplicitSchemaElementComparator() {
        }

        @Override
        public int compare(ImplicitSchemaElement element1, ImplicitSchemaElement element2) {
            return element1.getElementName().compareTo(element2.getElementName());
        }
    }
}

