/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxb;

import com.webcohesion.enunciate.Enunciate;
import com.webcohesion.enunciate.artifacts.BaseArtifact;
import com.webcohesion.enunciate.modules.jaxb.EnunciateJaxbContext;
import com.webcohesion.enunciate.modules.jaxb.model.Registry;
import com.webcohesion.enunciate.modules.jaxb.model.RootElementDeclaration;
import com.webcohesion.enunciate.modules.jaxb.model.SchemaInfo;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;

public class JaxbContextClassListArtifact
extends BaseArtifact {
    private final EnunciateJaxbContext jaxbContext;
    private final Date created = new Date();

    public JaxbContextClassListArtifact(EnunciateJaxbContext jaxbContext) {
        super("jaxb", "jaxb-context-classes.list");
        this.jaxbContext = jaxbContext;
        this.setBelongsOnServerSideClasspath(true);
    }

    public String getName() {
        return "jaxb-context-classes.list";
    }

    public String getDescription() {
        return "A plain text files that contains the list of all root elements and registries that should be noticed by the jaxb context.";
    }

    public boolean isPublic() {
        return false;
    }

    public Date getCreated() {
        return this.created;
    }

    public void exportTo(File fileOrDirectory, Enunciate enunciate) throws IOException {
        FileWriter out = new FileWriter(fileOrDirectory.isDirectory() ? new File(fileOrDirectory, this.getName()) : fileOrDirectory);
        for (SchemaInfo schemaInfo : this.jaxbContext.getSchemas().values()) {
            for (Registry registry : schemaInfo.getRegistries()) {
                out.write(registry.getQualifiedName() + "\n");
            }
            Collection<RootElementDeclaration> elements = schemaInfo.getRootElements();
            for (RootElementDeclaration element : elements) {
                out.write(element.getQualifiedName() + "\n");
            }
        }
        out.flush();
        out.close();
    }

    public long getSize() {
        return -1L;
    }
}

