/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxb.model;

import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.javac.decorations.type.TypeMirrorUtils;
import com.webcohesion.enunciate.metadata.qname.XmlQNameEnum;
import com.webcohesion.enunciate.metadata.qname.XmlQNameEnumValue;
import com.webcohesion.enunciate.metadata.qname.XmlUnknownQNameEnumValue;
import com.webcohesion.enunciate.modules.jaxb.EnunciateJaxbContext;
import com.webcohesion.enunciate.modules.jaxb.model.EnumTypeDefinition;
import com.webcohesion.enunciate.modules.jaxb.model.types.KnownXmlType;
import com.webcohesion.enunciate.modules.jaxb.model.types.XmlType;
import java.net.URI;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.xml.namespace.QName;

public class QNameEnumTypeDefinition
extends EnumTypeDefinition {
    private final String namespace;
    private final XmlQNameEnum.BaseType baseType;

    public QNameEnumTypeDefinition(TypeElement delegate, EnunciateJaxbContext context) {
        super(delegate, context);
        XmlQNameEnum xmlQNameEnum = (XmlQNameEnum)this.getAnnotation(XmlQNameEnum.class);
        if (xmlQNameEnum == null) {
            throw new IllegalArgumentException(delegate.getQualifiedName() + " is not a qname enum (not annotated with @com.webcohesion.enunciate.metadata.qname.XmlQNameEnum)");
        }
        String namespace = this.getPackage().getNamespace();
        if (!"##default".equals(xmlQNameEnum.namespace())) {
            namespace = xmlQNameEnum.namespace();
        }
        this.namespace = namespace;
        this.baseType = xmlQNameEnum.base();
    }

    @Override
    protected Map<String, Object> loadEnumValues() {
        String namespace = this.getPackage().getNamespace();
        XmlQNameEnum xmlQNameEnum = (XmlQNameEnum)this.getAnnotation(XmlQNameEnum.class);
        if (xmlQNameEnum != null && !"##default".equals(xmlQNameEnum.namespace())) {
            namespace = xmlQNameEnum.namespace();
        }
        if (namespace == null) {
            namespace = "";
        }
        List enumConstants = this.getEnumConstants();
        LinkedHashMap<String, Object> enumValueMap = new LinkedHashMap<String, Object>();
        HashSet<QName> enumValues = new HashSet<QName>(enumConstants.size());
        String unknownQNameConstant = null;
        for (VariableElement enumConstant : enumConstants) {
            QName qname;
            XmlUnknownQNameEnumValue unknownQNameEnumValue = enumConstant.getAnnotation(XmlUnknownQNameEnumValue.class);
            if (unknownQNameEnumValue != null) {
                if (unknownQNameConstant != null) {
                    throw new EnunciateException(this.getQualifiedName() + ": no more than two constants can be annotated with @XmlUnknownQNameEnumValue.");
                }
                unknownQNameConstant = enumConstant.getSimpleName().toString();
                continue;
            }
            String ns = namespace;
            String localPart = enumConstant.getSimpleName().toString();
            XmlQNameEnumValue enumValueInfo = enumConstant.getAnnotation(XmlQNameEnumValue.class);
            if (enumValueInfo != null) {
                if (enumValueInfo.exclude()) continue;
                if (!"##default".equals(enumValueInfo.namespace())) {
                    ns = enumValueInfo.namespace();
                }
                if (!"##default".equals(enumValueInfo.localPart())) {
                    localPart = enumValueInfo.localPart();
                }
            }
            if (!enumValues.add(qname = new QName(ns, localPart))) {
                throw new EnunciateException(this.getQualifiedName() + ": duplicate qname enum value: " + qname);
            }
            enumValueMap.put(enumConstant.getSimpleName().toString(), qname);
        }
        if (unknownQNameConstant != null) {
            enumValueMap.put(unknownQNameConstant, null);
        }
        return enumValueMap;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public XmlType getBaseType() {
        return this.isUriBaseType() ? KnownXmlType.ANY_URI : KnownXmlType.QNAME;
    }

    public boolean isUriBaseType() {
        return this.baseType == XmlQNameEnum.BaseType.URI;
    }

    @Override
    public DecoratedTypeMirror getEnumBaseClass() {
        return this.isUriBaseType() ? TypeMirrorUtils.mirrorOf(URI.class, (ProcessingEnvironment)this.env) : TypeMirrorUtils.mirrorOf(QName.class, (ProcessingEnvironment)this.env);
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return true;
    }

    public boolean isQNameEnum() {
        return true;
    }
}

