/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxb.model.types;

import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.modules.jaxb.EnunciateJaxbContext;
import com.webcohesion.enunciate.modules.jaxb.model.TypeDefinition;
import com.webcohesion.enunciate.modules.jaxb.model.adapters.AdapterType;
import com.webcohesion.enunciate.modules.jaxb.model.types.KnownXmlType;
import com.webcohesion.enunciate.modules.jaxb.model.types.MapXmlType;
import com.webcohesion.enunciate.modules.jaxb.model.types.XmlClassType;
import com.webcohesion.enunciate.modules.jaxb.model.types.XmlPrimitiveType;
import com.webcohesion.enunciate.modules.jaxb.model.types.XmlType;
import com.webcohesion.enunciate.modules.jaxb.model.types.XmlTypeFactory;
import com.webcohesion.enunciate.modules.jaxb.model.util.JAXBUtil;
import com.webcohesion.enunciate.modules.jaxb.model.util.MapType;
import javax.lang.model.element.Element;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor6;

public class XmlTypeVisitor
extends SimpleTypeVisitor6<XmlType, Context> {
    @Override
    protected XmlType defaultAction(TypeMirror typeMirror, Context context) {
        throw new EnunciateException(typeMirror + " is not recognized as an XML type.");
    }

    @Override
    public XmlType visitPrimitive(PrimitiveType primitiveType, Context context) {
        if (context.isInArray() && primitiveType.getKind() == TypeKind.BYTE) {
            return KnownXmlType.BASE64_BINARY;
        }
        return new XmlPrimitiveType(primitiveType);
    }

    @Override
    public XmlType visitDeclared(DeclaredType declaredType, Context context) {
        Element declaredElement = declaredType.asElement();
        AdapterType adapterType = JAXBUtil.findAdapterType(declaredElement, context.getContext());
        if (adapterType != null) {
            adapterType.getAdaptingType().accept(this, context);
        } else {
            MapType mapType = MapType.findMapType(declaredType, context.getContext());
            if (mapType != null) {
                XmlType keyType = XmlTypeFactory.getXmlType(mapType.getKeyType(), context.getContext());
                XmlType valueType = XmlTypeFactory.getXmlType(mapType.getValueType(), context.getContext());
                return new MapXmlType(keyType, valueType);
            }
            switch (declaredElement.getKind()) {
                case ENUM: 
                case CLASS: {
                    XmlType knownType = context.getContext().getKnownType(declaredElement);
                    if (knownType != null) {
                        return knownType;
                    }
                    TypeDefinition typeDefinition = context.getContext().findTypeDefinition(declaredElement);
                    if (typeDefinition == null) break;
                    return new XmlClassType(typeDefinition);
                }
                case INTERFACE: {
                    if (!context.isInCollection()) break;
                    return KnownXmlType.ANY_TYPE;
                }
            }
        }
        return (XmlType)super.visitDeclared(declaredType, context);
    }

    @Override
    public XmlType visitArray(ArrayType arrayType, Context context) {
        if (context.isInArray()) {
            throw new UnsupportedOperationException("Enunciate JAXB support doesn't handle multi-dimensional arrays.");
        }
        return arrayType.getComponentType().accept(this, context);
    }

    @Override
    public XmlType visitTypeVariable(TypeVariable typeVariable, Context context) {
        TypeMirror bound = typeVariable.getUpperBound();
        if (bound == null) {
            return KnownXmlType.ANY_TYPE;
        }
        return bound.accept(this, context);
    }

    @Override
    public XmlType visitWildcard(WildcardType wildcardType, Context context) {
        TypeMirror bound = wildcardType.getExtendsBound();
        if (bound == null) {
            return KnownXmlType.ANY_TYPE;
        }
        return bound.accept(this, context);
    }

    public static class Context {
        private final EnunciateJaxbContext context;
        private final boolean inArray;
        private final boolean inCollection;

        public Context(EnunciateJaxbContext context, boolean inArray, boolean inCollection) {
            this.context = context;
            this.inArray = inArray;
            this.inCollection = inCollection;
        }

        public EnunciateJaxbContext getContext() {
            return this.context;
        }

        public boolean isInArray() {
            return this.inArray;
        }

        public boolean isInCollection() {
            return this.inCollection;
        }
    }
}

