/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxb;

import com.webcohesion.enunciate.EnunciateContext;
import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.api.datatype.DataTypeReference;
import com.webcohesion.enunciate.api.datatype.Namespace;
import com.webcohesion.enunciate.api.datatype.Syntax;
import com.webcohesion.enunciate.api.resources.MediaTypeDescriptor;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedTypeElement;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedDeclaredType;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.metadata.qname.XmlQNameEnum;
import com.webcohesion.enunciate.module.EnunciateModuleContext;
import com.webcohesion.enunciate.modules.jaxb.api.impl.DataTypeReferenceImpl;
import com.webcohesion.enunciate.modules.jaxb.api.impl.MediaTypeDescriptorImpl;
import com.webcohesion.enunciate.modules.jaxb.api.impl.NamespaceImpl;
import com.webcohesion.enunciate.modules.jaxb.model.Accessor;
import com.webcohesion.enunciate.modules.jaxb.model.Attribute;
import com.webcohesion.enunciate.modules.jaxb.model.ComplexTypeDefinition;
import com.webcohesion.enunciate.modules.jaxb.model.Element;
import com.webcohesion.enunciate.modules.jaxb.model.ElementDeclaration;
import com.webcohesion.enunciate.modules.jaxb.model.ElementRef;
import com.webcohesion.enunciate.modules.jaxb.model.EnumTypeDefinition;
import com.webcohesion.enunciate.modules.jaxb.model.ImplicitAttributeRef;
import com.webcohesion.enunciate.modules.jaxb.model.ImplicitElementRef;
import com.webcohesion.enunciate.modules.jaxb.model.ImplicitSchemaAttribute;
import com.webcohesion.enunciate.modules.jaxb.model.ImplicitSchemaElement;
import com.webcohesion.enunciate.modules.jaxb.model.ImplicitWrappedElementRef;
import com.webcohesion.enunciate.modules.jaxb.model.LocalElementDeclaration;
import com.webcohesion.enunciate.modules.jaxb.model.QNameEnumTypeDefinition;
import com.webcohesion.enunciate.modules.jaxb.model.Registry;
import com.webcohesion.enunciate.modules.jaxb.model.RootElementDeclaration;
import com.webcohesion.enunciate.modules.jaxb.model.Schema;
import com.webcohesion.enunciate.modules.jaxb.model.SchemaInfo;
import com.webcohesion.enunciate.modules.jaxb.model.SimpleTypeDefinition;
import com.webcohesion.enunciate.modules.jaxb.model.TypeDefinition;
import com.webcohesion.enunciate.modules.jaxb.model.Value;
import com.webcohesion.enunciate.modules.jaxb.model.adapters.AdapterType;
import com.webcohesion.enunciate.modules.jaxb.model.types.KnownXmlType;
import com.webcohesion.enunciate.modules.jaxb.model.types.XmlType;
import com.webcohesion.enunciate.modules.jaxb.model.types.XmlTypeFactory;
import com.webcohesion.enunciate.modules.jaxb.model.util.JAXBUtil;
import com.webcohesion.enunciate.modules.jaxb.model.util.MapType;
import java.awt.Image;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlNsForm;
import javax.xml.bind.annotation.XmlRegistry;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;

public class EnunciateJaxbContext
extends EnunciateModuleContext
implements Syntax {
    public static final String SYNTAX_LABEL = "XML";
    private int prefixIndex = 0;
    private final Map<String, XmlType> knownTypes = this.loadKnownTypes();
    private final Map<String, TypeDefinition> typeDefinitions = new HashMap<String, TypeDefinition>();
    private final Map<String, ElementDeclaration> elementDeclarations = new HashMap<String, ElementDeclaration>();
    private final Map<String, String> namespacePrefixes;
    private final Map<String, SchemaInfo> schemas;
    private final Map<String, Map<String, XmlSchemaType>> packageSpecifiedTypes;

    public EnunciateJaxbContext(EnunciateContext context) {
        super(context);
        this.namespacePrefixes = this.loadKnownPrefixes(context);
        this.schemas = new HashMap<String, SchemaInfo>();
        this.packageSpecifiedTypes = new HashMap<String, Map<String, XmlSchemaType>>();
    }

    protected Map<String, String> loadKnownPrefixes(EnunciateContext context) {
        Map<String, String> namespacePrefixes = this.loadDefaultPrefixes();
        namespacePrefixes.putAll(context.getConfiguration().getNamespaces());
        return namespacePrefixes;
    }

    protected Map<String, String> loadDefaultPrefixes() {
        HashMap<String, String> knownNamespaces = new HashMap<String, String>();
        knownNamespaces.put("http://schemas.xmlsoap.org/wsdl/", "wsdl");
        knownNamespaces.put("http://schemas.xmlsoap.org/wsdl/http/", "http");
        knownNamespaces.put("http://schemas.xmlsoap.org/wsdl/mime/", "mime");
        knownNamespaces.put("http://schemas.xmlsoap.org/wsdl/soap/", "soap");
        knownNamespaces.put("http://schemas.xmlsoap.org/wsdl/soap12/", "soap12");
        knownNamespaces.put("http://schemas.xmlsoap.org/soap/encoding/", "soapenc");
        knownNamespaces.put("http://www.w3.org/2001/XMLSchema", "xs");
        knownNamespaces.put("http://www.w3.org/2001/XMLSchema-instance", "xsi");
        knownNamespaces.put("http://ws-i.org/profiles/basic/1.1/xsd", "wsi");
        knownNamespaces.put("http://wadl.dev.java.net/2009/02", "wadl");
        knownNamespaces.put("http://www.w3.org/XML/1998/namespace", "xml");
        return knownNamespaces;
    }

    public String getId() {
        return "jaxb";
    }

    public int compareTo(Syntax syntax) {
        return this.getId().compareTo(syntax.getId());
    }

    public String getSlug() {
        return "syntax_xml";
    }

    public String getLabel() {
        return SYNTAX_LABEL;
    }

    public boolean isEmpty() {
        return this.schemas.isEmpty();
    }

    public MediaTypeDescriptor findMediaTypeDescriptor(String mediaType, DecoratedTypeMirror typeMirror) {
        if (mediaType == null) {
            return null;
        }
        if (mediaType.equals("*/*") || mediaType.equals("application/*")) {
            mediaType = "application/xml";
        } else if (mediaType.equals("text/*")) {
            mediaType = "text/xml";
        }
        if (mediaType.endsWith("/xml") || mediaType.endsWith("+xml")) {
            DataTypeReference typeReference = this.findDataTypeReference(typeMirror);
            return new MediaTypeDescriptorImpl(mediaType, typeReference);
        }
        return null;
    }

    private DataTypeReference findDataTypeReference(DecoratedTypeMirror typeMirror) {
        XmlType xmlType;
        if (typeMirror == null) {
            return null;
        }
        try {
            xmlType = XmlTypeFactory.getXmlType((TypeMirror)typeMirror, this);
        }
        catch (Exception e) {
            xmlType = null;
        }
        return xmlType == null ? null : new DataTypeReferenceImpl(xmlType, typeMirror.isCollection() || typeMirror.isArray());
    }

    public List<Namespace> getNamespaces() {
        ArrayList<Namespace> namespaces = new ArrayList<Namespace>();
        for (SchemaInfo schemaInfo : this.schemas.values()) {
            namespaces.add(new NamespaceImpl(schemaInfo));
        }
        return namespaces;
    }

    public EnunciateContext getContext() {
        return this.context;
    }

    public XmlType getKnownType(javax.lang.model.element.Element declaration) {
        if (declaration instanceof TypeElement) {
            return this.knownTypes.get(((TypeElement)declaration).getQualifiedName().toString());
        }
        return null;
    }

    public TypeDefinition findTypeDefinition(javax.lang.model.element.Element declaration) {
        if (declaration instanceof TypeElement) {
            return this.typeDefinitions.get(((TypeElement)declaration).getQualifiedName().toString());
        }
        return null;
    }

    public ElementDeclaration findElementDeclaration(javax.lang.model.element.Element declaredElement) {
        if (declaredElement instanceof TypeElement) {
            return this.elementDeclarations.get(((TypeElement)declaredElement).getQualifiedName().toString());
        }
        if (declaredElement instanceof ExecutableElement) {
            return this.elementDeclarations.get(declaredElement.toString());
        }
        return null;
    }

    public Map<String, XmlSchemaType> getPackageSpecifiedTypes(String packageName) {
        return this.packageSpecifiedTypes.get(packageName);
    }

    public void setPackageSpecifiedTypes(String packageName, Map<String, XmlSchemaType> explicitTypes) {
        this.packageSpecifiedTypes.put(packageName, explicitTypes);
    }

    public Map<String, String> getNamespacePrefixes() {
        return this.namespacePrefixes;
    }

    public void addNamespacePrefix(String namespace, String prefix) {
        this.namespacePrefixes.put(namespace, prefix);
    }

    public Map<String, SchemaInfo> getSchemas() {
        return this.schemas;
    }

    protected Map<String, XmlType> loadKnownTypes() {
        HashMap<String, XmlType> knownTypes = new HashMap<String, XmlType>();
        knownTypes.put(Boolean.class.getName(), KnownXmlType.BOOLEAN);
        knownTypes.put(Byte.class.getName(), KnownXmlType.BYTE);
        knownTypes.put(Character.class.getName(), KnownXmlType.UNSIGNED_SHORT);
        knownTypes.put(Double.class.getName(), KnownXmlType.DOUBLE);
        knownTypes.put(Float.class.getName(), KnownXmlType.FLOAT);
        knownTypes.put(Integer.class.getName(), KnownXmlType.INT);
        knownTypes.put(Long.class.getName(), KnownXmlType.LONG);
        knownTypes.put(Short.class.getName(), KnownXmlType.SHORT);
        knownTypes.put(Boolean.TYPE.getName(), KnownXmlType.BOOLEAN);
        knownTypes.put(Byte.TYPE.getName(), KnownXmlType.BYTE);
        knownTypes.put(Double.TYPE.getName(), KnownXmlType.DOUBLE);
        knownTypes.put(Float.TYPE.getName(), KnownXmlType.FLOAT);
        knownTypes.put(Integer.TYPE.getName(), KnownXmlType.INT);
        knownTypes.put(Long.TYPE.getName(), KnownXmlType.LONG);
        knownTypes.put(Short.TYPE.getName(), KnownXmlType.SHORT);
        knownTypes.put(Character.TYPE.getName(), KnownXmlType.UNSIGNED_SHORT);
        knownTypes.put(String.class.getName(), KnownXmlType.STRING);
        knownTypes.put(BigInteger.class.getName(), KnownXmlType.INTEGER);
        knownTypes.put(BigDecimal.class.getName(), KnownXmlType.DECIMAL);
        knownTypes.put(Calendar.class.getName(), KnownXmlType.DATE_TIME);
        knownTypes.put(Date.class.getName(), KnownXmlType.DATE_TIME);
        knownTypes.put(Timestamp.class.getName(), KnownXmlType.DATE_TIME);
        knownTypes.put(QName.class.getName(), KnownXmlType.QNAME);
        knownTypes.put(URI.class.getName(), KnownXmlType.STRING);
        knownTypes.put(Duration.class.getName(), KnownXmlType.DURATION);
        knownTypes.put(Object.class.getName(), KnownXmlType.ANY_TYPE);
        knownTypes.put(byte[].class.getName(), KnownXmlType.BASE64_BINARY);
        knownTypes.put(Image.class.getName(), KnownXmlType.BASE64_BINARY);
        knownTypes.put(DataHandler.class.getName(), KnownXmlType.BASE64_BINARY);
        knownTypes.put(Source.class.getName(), KnownXmlType.BASE64_BINARY);
        knownTypes.put(UUID.class.getName(), KnownXmlType.STRING);
        knownTypes.put(XMLGregorianCalendar.class.getName(), KnownXmlType.DATE_TIME);
        knownTypes.put(GregorianCalendar.class.getName(), KnownXmlType.DATE_TIME);
        return knownTypes;
    }

    protected TypeDefinition createTypeDefinition(TypeElement declaration) {
        if (declaration.getKind() == ElementKind.INTERFACE && declaration.getAnnotation(javax.xml.bind.annotation.XmlType.class) != null) {
            throw new EnunciateException(declaration.getQualifiedName() + ": an interface must not be annotated with @XmlType.");
        }
        if (this.isEnumType(declaration = this.narrowToAdaptingType(declaration))) {
            if (declaration.getAnnotation(XmlQNameEnum.class) != null) {
                return new QNameEnumTypeDefinition(declaration, this);
            }
            return new EnumTypeDefinition(declaration, this);
        }
        ComplexTypeDefinition typeDef = new ComplexTypeDefinition(declaration, this);
        if (typeDef.getValue() != null && this.hasNeitherAttributesNorElements(typeDef)) {
            return new SimpleTypeDefinition(typeDef);
        }
        return typeDef;
    }

    protected TypeElement narrowToAdaptingType(TypeElement declaration) {
        AdapterType adapterType = JAXBUtil.findAdapterType(declaration, this);
        if (adapterType != null) {
            TypeMirror adaptingType = adapterType.getAdaptingType();
            if (adaptingType.getKind() != TypeKind.DECLARED) {
                return declaration;
            }
            TypeElement adaptingDeclaration = (TypeElement)((DeclaredType)adaptingType).asElement();
            if (adaptingDeclaration == null) {
                throw new EnunciateException(String.format("Class %s is being adapted by a type (%s) that doesn't seem to be on the classpath.", declaration.getQualifiedName(), adaptingType));
            }
            return adaptingDeclaration;
        }
        return declaration;
    }

    protected boolean isEnumType(TypeElement declaration) {
        return declaration.getKind() == ElementKind.ENUM;
    }

    protected boolean hasNeitherAttributesNorElements(TypeDefinition typeDef) {
        boolean none = typeDef.getAttributes().isEmpty() && typeDef.getElements().isEmpty();
        TypeMirror superclass = typeDef.getSuperclass();
        if (superclass instanceof DeclaredType) {
            TypeElement superDeclaration = (TypeElement)((DeclaredType)superclass).asElement();
            if (!Object.class.getName().equals(superDeclaration.getQualifiedName().toString())) {
                none &= this.hasNeitherAttributesNorElements(new ComplexTypeDefinition(superDeclaration, this));
            }
        }
        return none;
    }

    public String addNamespace(String namespace) {
        String prefix = this.namespacePrefixes.get(namespace);
        if (prefix == null) {
            prefix = this.generatePrefix(namespace);
            this.namespacePrefixes.put(namespace, prefix);
        }
        return prefix;
    }

    protected String generatePrefix(String namespace) {
        String prefix = "ns" + this.prefixIndex++;
        while (this.namespacePrefixes.values().contains(prefix)) {
            prefix = "ns" + this.prefixIndex++;
        }
        return prefix;
    }

    public void add(TypeDefinition typeDef) {
        this.add(typeDef, new LinkedList<javax.lang.model.element.Element>());
    }

    public void add(Schema schema) {
        this.add(schema, new LinkedList<javax.lang.model.element.Element>());
    }

    public void add(RootElementDeclaration rootElement) {
        if (this.findElementDeclaration(rootElement) == null) {
            this.elementDeclarations.put(rootElement.getQualifiedName().toString(), rootElement);
            this.debug("Added %s as a root XML element.", new Object[]{rootElement.getQualifiedName()});
            this.add(rootElement.getSchema());
            String namespace = rootElement.getNamespace();
            String prefix = this.addNamespace(namespace);
            SchemaInfo schemaInfo = this.schemas.get(namespace);
            if (schemaInfo == null) {
                schemaInfo = new SchemaInfo(this);
                schemaInfo.setId(prefix);
                schemaInfo.setNamespace(namespace);
                this.schemas.put(namespace, schemaInfo);
            }
            schemaInfo.getRootElements().add(rootElement);
            this.addReferencedTypeDefinitions(rootElement);
        }
    }

    public void add(Registry registry) {
        this.add(registry, new LinkedList<javax.lang.model.element.Element>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(Registry registry, LinkedList<javax.lang.model.element.Element> stack) {
        this.add(registry.getSchema());
        String namespace = registry.getSchema().getNamespace();
        String prefix = this.addNamespace(namespace);
        SchemaInfo schemaInfo = this.schemas.get(namespace);
        if (schemaInfo == null) {
            schemaInfo = new SchemaInfo(this);
            schemaInfo.setId(prefix);
            schemaInfo.setNamespace(namespace);
            this.schemas.put(namespace, schemaInfo);
        }
        schemaInfo.getRegistries().add(registry);
        this.debug("Added %s as an XML registry.", new Object[]{registry.getQualifiedName()});
        stack.push((javax.lang.model.element.Element)((Object)registry));
        try {
            this.addReferencedTypeDefinitions(registry, stack);
            for (LocalElementDeclaration led : registry.getLocalElementDeclarations()) {
                this.add(led, stack);
            }
        }
        finally {
            stack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addReferencedTypeDefinitions(Registry registry, LinkedList<javax.lang.model.element.Element> stack) {
        this.addSeeAlsoTypeDefinitions((javax.lang.model.element.Element)((Object)registry), stack);
        for (ExecutableElement methodDeclaration : registry.getInstanceFactoryMethods()) {
            stack.push(methodDeclaration);
            try {
                this.addReferencedTypeDefinitions(methodDeclaration.getReturnType(), stack);
            }
            finally {
                stack.pop();
            }
        }
    }

    protected void add(LocalElementDeclaration led, LinkedList<javax.lang.model.element.Element> stack) {
        String namespace = led.getNamespace();
        String prefix = this.addNamespace(namespace);
        SchemaInfo schemaInfo = this.schemas.get(namespace);
        if (schemaInfo == null) {
            schemaInfo = new SchemaInfo(this);
            schemaInfo.setId(prefix);
            schemaInfo.setNamespace(namespace);
            this.schemas.put(namespace, schemaInfo);
        }
        this.elementDeclarations.put(led.getElementType().getQualifiedName().toString(), led);
        schemaInfo.getLocalElementDeclarations().add(led);
        this.debug("Added %s as a local element declaration.", new Object[]{led.getSimpleName()});
        this.addReferencedTypeDefinitions(led, stack);
    }

    protected void addReferencedTypeDefinitions(LocalElementDeclaration led, LinkedList<javax.lang.model.element.Element> stack) {
        this.addSeeAlsoTypeDefinitions(led, stack);
        DecoratedTypeElement scope = led.getElementScope();
        if (scope != null && scope.getKind() == ElementKind.CLASS && !this.isKnownTypeDefinition((TypeElement)scope)) {
            this.add(this.createTypeDefinition((TypeElement)scope), stack);
        }
        TypeElement typeDeclaration = led.getElementType();
        if (scope != null && scope.getKind() == ElementKind.CLASS && !this.isKnownTypeDefinition(typeDeclaration)) {
            this.add(this.createTypeDefinition(typeDeclaration), stack);
        }
    }

    public boolean isKnownTypeDefinition(TypeElement el) {
        return this.findTypeDefinition(el) != null || this.isKnownType(el);
    }

    public void addReferencedTypeDefinitions(RootElementDeclaration rootEl) {
        TypeDefinition typeDefinition = rootEl.getTypeDefinition();
        if (typeDefinition != null) {
            this.add(typeDefinition);
        } else {
            this.add(this.createTypeDefinition((TypeElement)rootEl.getDelegate()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(Schema schema, LinkedList<javax.lang.model.element.Element> stack) {
        stack.add((javax.lang.model.element.Element)((Object)schema));
        try {
            String namespace = schema.getNamespace();
            String prefix = this.addNamespace(namespace);
            this.namespacePrefixes.putAll(schema.getSpecifiedNamespacePrefixes());
            SchemaInfo schemaInfo = this.schemas.get(namespace);
            if (schemaInfo == null) {
                schemaInfo = new SchemaInfo(this);
                schemaInfo.setId(prefix);
                schemaInfo.setNamespace(namespace);
                this.schemas.put(namespace, schemaInfo);
            }
            if (schema.getElementFormDefault() != XmlNsForm.UNSET) {
                for (Schema pckg : schemaInfo.getPackages()) {
                    if (pckg.getElementFormDefault() == null || schema.getElementFormDefault() == pckg.getElementFormDefault()) continue;
                    throw new EnunciateException(schema.getQualifiedName() + ": inconsistent elementFormDefault declarations: " + pckg.getQualifiedName());
                }
            }
            if (schema.getAttributeFormDefault() != XmlNsForm.UNSET) {
                for (Schema pckg : schemaInfo.getPackages()) {
                    if (pckg.getAttributeFormDefault() == null || schema.getAttributeFormDefault() == pckg.getAttributeFormDefault()) continue;
                    throw new EnunciateException(schema.getQualifiedName() + ": inconsistent attributeFormDefault declarations: " + pckg.getQualifiedName());
                }
            }
            schemaInfo.getPackages().add(schema);
        }
        finally {
            stack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(TypeDefinition typeDef, LinkedList<javax.lang.model.element.Element> stack) {
        if (this.findTypeDefinition((javax.lang.model.element.Element)((Object)typeDef)) == null && !this.isKnownType((TypeElement)((Object)typeDef))) {
            this.typeDefinitions.put(typeDef.getQualifiedName().toString(), typeDef);
            this.debug("Added %s as a JAXB type definition.", new Object[]{typeDef.getQualifiedName()});
            if (typeDef.getAnnotation(XmlRootElement.class) != null && this.findElementDeclaration((javax.lang.model.element.Element)((Object)typeDef)) == null) {
                this.add(new RootElementDeclaration((TypeElement)typeDef.getDelegate(), typeDef, this));
            }
            typeDef.getReferencedFrom().addAll(stack);
            try {
                Value value;
                SchemaInfo referencedSchemaInfo;
                stack.push((javax.lang.model.element.Element)((Object)typeDef));
                this.add(typeDef.getSchema(), stack);
                String namespace = typeDef.getNamespace();
                String prefix = this.addNamespace(namespace);
                SchemaInfo schemaInfo = this.schemas.get(namespace);
                if (schemaInfo == null) {
                    schemaInfo = new SchemaInfo(this);
                    schemaInfo.setId(prefix);
                    schemaInfo.setNamespace(namespace);
                    this.schemas.put(namespace, schemaInfo);
                }
                schemaInfo.getTypeDefinitions().add(typeDef);
                this.addSeeAlsoTypeDefinitions((javax.lang.model.element.Element)((Object)typeDef), stack);
                for (Element element : typeDef.getElements()) {
                    this.addReferencedTypeDefinitions(element, stack);
                    ImplicitSchemaElement implicitElement = this.getImplicitElement(element);
                    if (implicitElement == null) continue;
                    String implicitNamespace = element.isWrapped() ? element.getWrapperNamespace() : element.getNamespace();
                    referencedSchemaInfo = this.schemas.get(implicitNamespace);
                    if (referencedSchemaInfo == null) {
                        referencedSchemaInfo = new SchemaInfo(this);
                        referencedSchemaInfo.setId(this.addNamespace(implicitNamespace));
                        referencedSchemaInfo.setNamespace(implicitNamespace);
                        this.schemas.put(implicitNamespace, referencedSchemaInfo);
                    }
                    referencedSchemaInfo.getImplicitSchemaElements().add(implicitElement);
                }
                for (Attribute attribute : typeDef.getAttributes()) {
                    this.addReferencedTypeDefinitions(attribute, stack);
                    ImplicitSchemaAttribute implicitAttribute = this.getImplicitAttribute(attribute);
                    if (implicitAttribute == null) continue;
                    String implicitAttributeNamespace = attribute.getNamespace();
                    referencedSchemaInfo = this.schemas.get(implicitAttributeNamespace);
                    if (referencedSchemaInfo == null) {
                        referencedSchemaInfo = new SchemaInfo(this);
                        referencedSchemaInfo.setId(this.addNamespace(implicitAttributeNamespace));
                        referencedSchemaInfo.setNamespace(implicitAttributeNamespace);
                        this.schemas.put(implicitAttributeNamespace, referencedSchemaInfo);
                    }
                    referencedSchemaInfo.getImplicitSchemaAttributes().add(implicitAttribute);
                }
                if (typeDef.getAnyAttributeQNameEnumRef() != null) {
                    this.addReferencedTypeDefinitions(typeDef.getAnyAttributeQNameEnumRef(), stack);
                }
                if ((value = typeDef.getValue()) != null) {
                    this.addReferencedTypeDefinitions(value, stack);
                }
                TypeMirror superclass = typeDef.getSuperclass();
                if (!typeDef.isEnum() && superclass != null && superclass.getKind() != TypeKind.NONE) {
                    this.addReferencedTypeDefinitions(superclass, stack);
                }
            }
            finally {
                stack.pop();
            }
        }
    }

    protected void addReferencedTypeDefinitions(Accessor accessor, LinkedList<javax.lang.model.element.Element> stack) {
        this.addSeeAlsoTypeDefinitions((javax.lang.model.element.Element)((Object)accessor), stack);
        DecoratedTypeMirror enumRef = accessor.getQNameEnumRef();
        if (enumRef != null) {
            this.addReferencedTypeDefinitions((TypeMirror)enumRef, stack);
        }
    }

    protected void addReferencedTypeDefinitions(Attribute attribute, LinkedList<javax.lang.model.element.Element> stack) {
        this.addReferencedTypeDefinitions((Accessor)attribute, stack);
        this.addReferencedTypeDefinitions((TypeMirror)((Object)(attribute.isAdapted() ? attribute.getAdapterType() : attribute.getAccessorType())), stack);
    }

    protected void addReferencedTypeDefinitions(Value value, LinkedList<javax.lang.model.element.Element> stack) {
        this.addReferencedTypeDefinitions((Accessor)value, stack);
        this.addReferencedTypeDefinitions((TypeMirror)((Object)(value.isAdapted() ? value.getAdapterType() : value.getAccessorType())), stack);
    }

    protected void addReferencedTypeDefinitions(Element element, LinkedList<javax.lang.model.element.Element> stack) {
        this.addReferencedTypeDefinitions((Accessor)element, stack);
        if (element instanceof ElementRef && element.isCollectionType()) {
            this.addReferencedTypeDefinitions((TypeMirror)element.getAccessorType(), stack);
        } else {
            for (Element element2 : element.getChoices()) {
                this.addReferencedTypeDefinitions((TypeMirror)((Object)(element2.isAdapted() ? element2.getAdapterType() : element2.getAccessorType())), stack);
            }
        }
    }

    public void addReferencedTypeDefinitions(TypeMirror type, LinkedList<javax.lang.model.element.Element> stack) {
        type.accept(new ReferencedTypeDefinitionVisitor(), stack);
    }

    protected ImplicitSchemaElement getImplicitElement(Element element) {
        if (!(element instanceof ElementRef)) {
            boolean qualified = element.getForm() == XmlNsForm.QUALIFIED;
            String typeNamespace = element.getTypeDefinition().getNamespace();
            typeNamespace = typeNamespace == null ? "" : typeNamespace;
            String elementNamespace = element.isWrapped() ? element.getWrapperNamespace() : element.getNamespace();
            String string = elementNamespace = elementNamespace == null ? "" : elementNamespace;
            if (!(elementNamespace.equals(typeNamespace) || !qualified && "".equals(elementNamespace))) {
                return element.isWrapped() ? new ImplicitWrappedElementRef(element) : new ImplicitElementRef(element);
            }
        }
        return null;
    }

    protected ImplicitSchemaAttribute getImplicitAttribute(Attribute attribute) {
        boolean qualified = attribute.getForm() == XmlNsForm.QUALIFIED;
        String typeNamespace = attribute.getTypeDefinition().getNamespace();
        typeNamespace = typeNamespace == null ? "" : typeNamespace;
        String attributeNamespace = attribute.getNamespace();
        String string = attributeNamespace = attributeNamespace == null ? "" : attributeNamespace;
        if (!(attributeNamespace.equals(typeNamespace) || !qualified && "".equals(attributeNamespace))) {
            return new ImplicitAttributeRef(attribute);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void addSeeAlsoTypeDefinitions(javax.lang.model.element.Element declaration, LinkedList<javax.lang.model.element.Element> stack) {
        XmlSeeAlso seeAlso = declaration.getAnnotation(XmlSeeAlso.class);
        if (seeAlso != null) {
            Elements elementUtils = this.getContext().getProcessingEnvironment().getElementUtils();
            Types typeUtils = this.getContext().getProcessingEnvironment().getTypeUtils();
            stack.push(elementUtils.getTypeElement(XmlSeeAlso.class.getName()));
            try {
                void var9_13;
                Class[] classes;
                Class[] arr$ = classes = seeAlso.value();
                int len$ = arr$.length;
                boolean bl = false;
                while (var9_13 < len$) {
                    Class clazz = arr$[var9_13];
                    this.addSeeAlsoReference(elementUtils.getTypeElement(clazz.getName()));
                    ++var9_13;
                }
            }
            catch (MirroredTypesException e) {
                List<? extends TypeMirror> mirrors = e.getTypeMirrors();
                for (TypeMirror typeMirror : mirrors) {
                    javax.lang.model.element.Element element = typeUtils.asElement(typeMirror);
                    if (!(element instanceof TypeElement)) continue;
                    this.addSeeAlsoReference((TypeElement)element);
                }
            }
            finally {
                stack.pop();
            }
        }
    }

    protected void addSeeAlsoReference(TypeElement typeDeclaration) {
        if (!this.isKnownTypeDefinition(typeDeclaration) && typeDeclaration.getAnnotation(XmlRegistry.class) == null) {
            this.add(this.createTypeDefinition(typeDeclaration));
        }
    }

    protected boolean isKnownType(TypeElement typeDef) {
        return this.knownTypes.containsKey(typeDef.getQualifiedName().toString()) || ((DecoratedTypeMirror)typeDef.asType()).isInstanceOf(JAXBElement.class);
    }

    private class ReferencedTypeDefinitionVisitor
    extends SimpleTypeVisitor6<Void, LinkedList<javax.lang.model.element.Element>> {
        private ReferencedTypeDefinitionVisitor() {
        }

        @Override
        public Void visitArray(ArrayType t, LinkedList<javax.lang.model.element.Element> stack) {
            return t.getComponentType().accept(this, stack);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Void visitDeclared(DeclaredType declaredType, LinkedList<javax.lang.model.element.Element> stack) {
            TypeElement declaration = (TypeElement)declaredType.asElement();
            if (declaration.getKind() == ElementKind.ENUM) {
                if (EnunciateJaxbContext.this.isKnownTypeDefinition(declaration)) return null;
                EnunciateJaxbContext.this.add(EnunciateJaxbContext.this.createTypeDefinition(declaration));
                return null;
            } else if (declaredType instanceof AdapterType) {
                ((AdapterType)((Object)declaredType)).getAdaptingType().accept(this, stack);
                return null;
            } else {
                MapType mapType = MapType.findMapType(declaredType, EnunciateJaxbContext.this);
                if (mapType == null) {
                    String qualifiedName = declaration.getQualifiedName().toString();
                    if (Object.class.getName().equals(qualifiedName)) {
                        return null;
                    }
                    if (stack.contains(declaration)) {
                        return null;
                    }
                    stack.push(declaration);
                    try {
                        List<? extends TypeMirror> typeArgs;
                        if (!(EnunciateJaxbContext.this.isKnownTypeDefinition(declaration) || ((DecoratedDeclaredType)declaredType).isCollection() || ((DecoratedDeclaredType)declaredType).isInstanceOf(JAXBElement.class))) {
                            EnunciateJaxbContext.this.add(EnunciateJaxbContext.this.createTypeDefinition(declaration));
                        }
                        if ((typeArgs = declaredType.getTypeArguments()) == null) return null;
                        for (TypeMirror typeMirror : typeArgs) {
                            typeMirror.accept(this, stack);
                        }
                        return null;
                    }
                    finally {
                        stack.pop();
                    }
                } else {
                    mapType.getKeyType().accept(this, stack);
                    mapType.getValueType().accept(this, stack);
                }
            }
            return null;
        }

        @Override
        public Void visitTypeVariable(TypeVariable t, LinkedList<javax.lang.model.element.Element> stack) {
            return t.getUpperBound().accept(this, stack);
        }

        @Override
        public Void visitWildcard(WildcardType t, LinkedList<javax.lang.model.element.Element> stack) {
            TypeMirror superBound;
            TypeMirror extendsBound = t.getExtendsBound();
            if (extendsBound != null) {
                extendsBound.accept(this, stack);
            }
            if ((superBound = t.getSuperBound()) != null) {
                superBound.accept(this, stack);
            }
            return null;
        }

        @Override
        public Void visitUnknown(TypeMirror t, LinkedList<javax.lang.model.element.Element> stack) {
            return (Void)this.defaultAction(t, stack);
        }
    }
}

