/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxb.api.impl;

import com.webcohesion.enunciate.api.datatype.BaseType;
import com.webcohesion.enunciate.api.datatype.DataTypeReference;
import com.webcohesion.enunciate.api.datatype.Example;
import com.webcohesion.enunciate.api.datatype.Property;
import com.webcohesion.enunciate.api.datatype.Value;
import com.webcohesion.enunciate.facets.FacetFilter;
import com.webcohesion.enunciate.facets.HasFacets;
import com.webcohesion.enunciate.modules.jaxb.api.impl.DataTypeImpl;
import com.webcohesion.enunciate.modules.jaxb.api.impl.DataTypeReferenceImpl;
import com.webcohesion.enunciate.modules.jaxb.api.impl.ExampleImpl;
import com.webcohesion.enunciate.modules.jaxb.api.impl.PropertyImpl;
import com.webcohesion.enunciate.modules.jaxb.api.impl.WrappedPropertyImpl;
import com.webcohesion.enunciate.modules.jaxb.model.Attribute;
import com.webcohesion.enunciate.modules.jaxb.model.ComplexTypeDefinition;
import com.webcohesion.enunciate.modules.jaxb.model.Element;
import com.webcohesion.enunciate.modules.jaxb.model.types.XmlClassType;
import com.webcohesion.enunciate.modules.jaxb.model.types.XmlType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ComplexDataTypeImpl
extends DataTypeImpl {
    private final ComplexTypeDefinition typeDefinition;

    public ComplexDataTypeImpl(ComplexTypeDefinition typeDefinition) {
        super(typeDefinition);
        this.typeDefinition = typeDefinition;
    }

    public BaseType getBaseType() {
        return BaseType.object;
    }

    public List<? extends Value> getValues() {
        return null;
    }

    public List<? extends Property> getProperties() {
        ArrayList properties = new ArrayList();
        FacetFilter facetFilter = this.typeDefinition.getContext().getContext().getConfiguration().getFacetFilter();
        ArrayList<PropertyImpl> attributeProperties = new ArrayList<PropertyImpl>();
        for (Attribute attribute : this.typeDefinition.getAttributes()) {
            if (!facetFilter.accept((HasFacets)attribute)) continue;
            attributeProperties.add(new PropertyImpl(attribute));
        }
        Collections.sort(attributeProperties, new Comparator<Property>(){

            @Override
            public int compare(Property o1, Property o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        properties.addAll(attributeProperties);
        if (this.typeDefinition.getValue() != null) {
            properties.add(new PropertyImpl(this.typeDefinition.getValue()));
        } else {
            ArrayList<WrappedPropertyImpl> elementProperties = new ArrayList<WrappedPropertyImpl>();
            for (Element element : this.typeDefinition.getElements()) {
                if (!facetFilter.accept((HasFacets)element)) continue;
                boolean wrapped = element.isWrapped();
                String wrapperName = wrapped ? element.getWrapperName() : null;
                String wrapperNamespace = wrapped ? element.getWrapperNamespace() : null;
                for (Element element2 : element.getChoices()) {
                    elementProperties.add((WrappedPropertyImpl)(wrapped ? new WrappedPropertyImpl(element2, wrapperName, wrapperNamespace) : new PropertyImpl(element2)));
                }
            }
            Collections.sort(elementProperties, new Comparator<Property>(){

                @Override
                public int compare(Property o1, Property o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            properties.addAll(elementProperties);
        }
        return properties;
    }

    @Override
    public List<DataTypeReference> getSupertypes() {
        ArrayList<DataTypeReferenceImpl> supertypes = null;
        XmlType supertype = this.typeDefinition.getBaseType();
        while (supertype != null) {
            if (supertypes == null) {
                supertypes = new ArrayList<DataTypeReferenceImpl>();
            }
            supertypes.add(new DataTypeReferenceImpl(supertype, false));
            supertype = supertype instanceof XmlClassType ? (((XmlClassType)supertype).getTypeDefinition() instanceof ComplexTypeDefinition ? ((XmlClassType)supertype).getTypeDefinition().getBaseType() : null) : null;
        }
        return supertypes;
    }

    @Override
    public Example getExample() {
        return new ExampleImpl(this.typeDefinition);
    }

    public Map<String, String> getPropertyMetadata() {
        LinkedHashMap<String, String> propertyMetadata = new LinkedHashMap<String, String>();
        propertyMetadata.put("type", "type");
        propertyMetadata.put("namespaceInfo", "namespace");
        propertyMetadata.put("minMaxOccurs", "min/max occurs");
        boolean showDefaultValue = false;
        boolean showWrapper = false;
        for (Element element : this.typeDefinition.getElements()) {
            for (Element element2 : element.getChoices()) {
                if (element2.getDefaultValue() == null) continue;
                showDefaultValue = true;
            }
            if (!element.isWrapped()) continue;
            showWrapper = true;
        }
        if (showDefaultValue) {
            propertyMetadata.put("defaultValue", "default");
        }
        if (showWrapper) {
            propertyMetadata.put("wrapper", "wrapped by");
        }
        return propertyMetadata;
    }
}

