/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxws;

import com.webcohesion.enunciate.EnunciateContext;
import com.webcohesion.enunciate.module.EnunciateModuleContext;
import com.webcohesion.enunciate.modules.jaxb.EnunciateJaxbContext;
import com.webcohesion.enunciate.modules.jaxb.model.ImplicitSchemaElement;
import com.webcohesion.enunciate.modules.jaxb.model.SchemaInfo;
import com.webcohesion.enunciate.modules.jaxws.WsdlInfo;
import com.webcohesion.enunciate.modules.jaxws.model.EndpointInterface;
import com.webcohesion.enunciate.modules.jaxws.model.WebMessage;
import com.webcohesion.enunciate.modules.jaxws.model.WebMessagePart;
import com.webcohesion.enunciate.modules.jaxws.model.WebMethod;
import com.webcohesion.enunciate.util.OneTimeLogMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;

public class EnunciateJaxwsContext
extends EnunciateModuleContext {
    private final EnunciateJaxbContext jaxbContext;
    private final boolean useSourceParameterNames;
    private final Map<String, WsdlInfo> wsdls = new HashMap<String, WsdlInfo>();
    private final List<EndpointInterface> endpointInterfaces = new ArrayList<EndpointInterface>();

    public EnunciateJaxwsContext(EnunciateJaxbContext jaxbContext, boolean useSourceParameterNames) {
        super(jaxbContext.getContext());
        this.jaxbContext = jaxbContext;
        this.useSourceParameterNames = useSourceParameterNames;
    }

    public EnunciateContext getContext() {
        return this.context;
    }

    public EnunciateJaxbContext getJaxbContext() {
        return this.jaxbContext;
    }

    public boolean isUseSourceParameterNames() {
        return this.useSourceParameterNames;
    }

    public List<EndpointInterface> getEndpointInterfaces() {
        return this.endpointInterfaces;
    }

    public Map<String, WsdlInfo> getWsdls() {
        return this.wsdls;
    }

    public void add(EndpointInterface ei) {
        String namespace = ei.getTargetNamespace();
        String prefix = this.jaxbContext.addNamespace(namespace);
        WsdlInfo wsdlInfo = this.wsdls.get(namespace);
        if (wsdlInfo == null) {
            wsdlInfo = new WsdlInfo(this.jaxbContext);
            wsdlInfo.setId(prefix);
            this.wsdls.put(namespace, wsdlInfo);
            wsdlInfo.setTargetNamespace(namespace);
        }
        for (WebMethod webMethod : ei.getWebMethods()) {
            for (WebMessage webMessage : webMethod.getMessages()) {
                for (WebMessagePart messagePart : webMessage.getParts()) {
                    if (!messagePart.isImplicitSchemaElement()) continue;
                    ImplicitSchemaElement implicitElement = (ImplicitSchemaElement)messagePart;
                    String particleNamespace = messagePart.getParticleQName().getNamespaceURI();
                    SchemaInfo schemaInfo = (SchemaInfo)this.jaxbContext.getSchemas().get(particleNamespace);
                    if (schemaInfo == null) {
                        schemaInfo = new SchemaInfo(this.jaxbContext);
                        schemaInfo.setId(this.jaxbContext.addNamespace(particleNamespace));
                        schemaInfo.setNamespace(particleNamespace);
                        this.jaxbContext.getSchemas().put(particleNamespace, schemaInfo);
                    }
                    schemaInfo.getImplicitSchemaElements().add(implicitElement);
                }
            }
        }
        wsdlInfo.getEndpointInterfaces().add(ei);
        this.endpointInterfaces.add(ei);
        this.debug("Added %s as a JAX-WS endpoint interface.", new Object[]{ei.getQualifiedName()});
        if (this.getContext().getProcessingEnvironment().findSourcePosition((Element)((Object)ei)) == null) {
            OneTimeLogMessage.SOURCE_FILES_NOT_FOUND.log(this.getContext());
            if (OneTimeLogMessage.SOURCE_FILES_NOT_FOUND.getLogged() <= 3) {
                this.info("Unable to find source file for %s.", new Object[]{ei.getQualifiedName()});
            } else {
                this.debug("Unable to find source file for %s.", new Object[]{ei.getQualifiedName()});
            }
        }
    }

    public String getContextPath() {
        return "";
    }
}

