/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxws.model;

import com.webcohesion.enunciate.EnunciateContext;
import com.webcohesion.enunciate.facets.Facet;
import com.webcohesion.enunciate.facets.HasFacets;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedTypeElement;
import com.webcohesion.enunciate.metadata.ClientName;
import com.webcohesion.enunciate.modules.jaxws.EnunciateJaxwsContext;
import com.webcohesion.enunciate.modules.jaxws.model.BindingType;
import com.webcohesion.enunciate.modules.jaxws.model.EndpointInterface;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

public class EndpointImplementation
extends DecoratedTypeElement
implements HasFacets {
    private final EndpointInterface endpointInterface;
    private final Set<Facet> facets = new TreeSet<Facet>();
    private final EnunciateJaxwsContext context;
    private String path;

    public EndpointImplementation(TypeElement delegate, EndpointInterface endpointInterface, EnunciateJaxwsContext context) {
        super(delegate, context.getContext().getProcessingEnvironment());
        this.context = context;
        this.endpointInterface = endpointInterface;
        this.facets.addAll(Facet.gatherFacets((Element)delegate, (EnunciateContext)context.getContext()));
        this.facets.addAll(endpointInterface.getFacets());
    }

    public String getClientSimpleName() {
        String clientSimpleName = this.getSimpleName().toString();
        ClientName clientName = (ClientName)this.getAnnotation(ClientName.class);
        if (clientName != null) {
            clientSimpleName = clientName.value();
        }
        return clientSimpleName;
    }

    public EndpointInterface getEndpointInterface() {
        return this.endpointInterface;
    }

    public BindingType getBindingType() {
        jakarta.xml.ws.BindingType bindingType = (jakarta.xml.ws.BindingType)this.getAnnotation(jakarta.xml.ws.BindingType.class);
        if (bindingType != null && bindingType.value() != null && !"".equals(bindingType.value())) {
            return BindingType.fromNamespace(bindingType.value());
        }
        return BindingType.SOAP_1_1;
    }

    public String getServiceEndpointId() {
        return "enunciate:service:" + this.getSimpleName();
    }

    public Set<Facet> getFacets() {
        return this.facets;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

