/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxws.model;

import com.webcohesion.enunciate.EnunciateContext;
import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.facets.Facet;
import com.webcohesion.enunciate.facets.HasFacets;
import com.webcohesion.enunciate.javac.TypeElementComparator;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedTypeElement;
import com.webcohesion.enunciate.javac.decorations.element.ElementUtils;
import com.webcohesion.enunciate.javac.decorations.type.TypeVariableContext;
import com.webcohesion.enunciate.metadata.ClientName;
import com.webcohesion.enunciate.metadata.soap.SoapBindingName;
import com.webcohesion.enunciate.modules.jaxws.EnunciateJaxwsContext;
import com.webcohesion.enunciate.modules.jaxws.model.BindingType;
import com.webcohesion.enunciate.modules.jaxws.model.EndpointImplementation;
import com.webcohesion.enunciate.modules.jaxws.model.WebMethod;
import jakarta.jws.WebService;
import jakarta.jws.soap.SOAPBinding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public class EndpointInterface
extends DecoratedTypeElement
implements HasFacets {
    private final WebService annotation;
    private final List<WebMethod> webMethods;
    private final Collection<EndpointImplementation> impls;
    private final Map<String, Object> metaData = new HashMap<String, Object>();
    private final Set<Facet> facets = new TreeSet<Facet>();
    private final boolean aggressiveWebMethodExcludePolicy;
    private final EnunciateJaxwsContext context;

    public EndpointInterface(TypeElement delegate, Set<? extends Element> implementationCandidates, EnunciateJaxwsContext context) {
        this(delegate, implementationCandidates, false, context);
    }

    /*
     * WARNING - void declaration
     */
    public EndpointInterface(TypeElement delegate, Set<? extends Element> implementationCandidates, boolean aggressiveWebMethodExcludePolicy, EnunciateJaxwsContext context) {
        super(delegate, context.getContext().getProcessingEnvironment());
        Element declaration;
        TypeMirror typeMirror;
        this.context = context;
        this.aggressiveWebMethodExcludePolicy = aggressiveWebMethodExcludePolicy;
        this.facets.addAll(Facet.gatherFacets((Element)delegate, (EnunciateContext)context.getContext()));
        this.annotation = (WebService)this.getAnnotation(WebService.class);
        this.impls = new ArrayList<EndpointImplementation>();
        if (this.annotation != null) {
            if (ElementUtils.isClassOrRecord((Element)((Object)this))) {
                this.impls.add(new EndpointImplementation((TypeElement)this.getDelegate(), this, context));
            } else {
                TreeSet<TypeElement> potentialImpls = new TreeSet<TypeElement>((Comparator<TypeElement>)new TypeElementComparator());
                potentialImpls.addAll(ElementFilter.typesIn(context.getContext().getApiElements()));
                if (implementationCandidates != null) {
                    potentialImpls.addAll(ElementFilter.typesIn(implementationCandidates));
                }
                for (TypeElement typeElement : potentialImpls) {
                    if (!this.isEndpointImplementation(typeElement)) continue;
                    WebService ws = typeElement.getAnnotation(WebService.class);
                    if (!this.getQualifiedName().toString().equals(ws.endpointInterface())) continue;
                    this.impls.add(new EndpointImplementation(typeElement, this, context));
                }
            }
        }
        TypeVariableContext variableContext = new TypeVariableContext();
        ArrayList<WebMethod> webMethods = new ArrayList<WebMethod>();
        for (ExecutableElement method : this.getMethods()) {
            if (!this.isWebMethod(method)) continue;
            webMethods.add(new WebMethod(method, this, context, variableContext));
        }
        if (ElementUtils.isClassOrRecord((Element)delegate) && (typeMirror = delegate.getSuperclass()) instanceof DeclaredType && (declaration = ((DeclaredType)typeMirror).asElement()) instanceof TypeElement) {
            while (declaration != null && !Object.class.getName().equals(((TypeElement)declaration).getQualifiedName().toString())) {
                void var7_10;
                variableContext = variableContext.push(((TypeElement)declaration).getTypeParameters(), ((DeclaredType)var7_10).getTypeArguments());
                for (ExecutableElement method : ElementFilter.methodsIn(declaration.getEnclosedElements())) {
                    if (!this.isWebMethod(method)) continue;
                    webMethods.add(new WebMethod(method, this, context, variableContext));
                }
                TypeMirror typeMirror2 = ((TypeElement)declaration).getSuperclass();
                if (typeMirror2 == null || typeMirror2.getKind() == TypeKind.NONE) {
                    declaration = null;
                    continue;
                }
                declaration = ((DeclaredType)typeMirror2).asElement();
            }
        }
        this.webMethods = webMethods;
    }

    public EnunciateJaxwsContext getContext() {
        return this.context;
    }

    public String getPortTypeName() {
        String name = null;
        if (this.annotation != null) {
            name = this.annotation.name();
        }
        if (name == null || "".equals(name)) {
            name = this.getSimpleName().toString();
        }
        return name;
    }

    public String getServiceName() {
        WebService implAnnotation;
        Object serviceName = null;
        if (this.annotation != null) {
            serviceName = this.annotation.serviceName();
        }
        if ((serviceName == null || "".equals(serviceName)) && this.getEndpointImplementations().size() == 1 && (implAnnotation = (WebService)this.getEndpointImplementations().iterator().next().getAnnotation(WebService.class)) != null) {
            serviceName = implAnnotation.serviceName();
        }
        if (serviceName == null || "".equals(serviceName)) {
            serviceName = this.getSimpleName() + "Service";
        }
        return serviceName;
    }

    public String getPath() {
        for (EndpointImplementation implementation : this.getEndpointImplementations()) {
            String path = implementation.getPath();
            if (path == null) continue;
            return path;
        }
        return "/" + this.getServiceName();
    }

    public String getTargetNamespace() {
        String targetNamespace = null;
        if (this.annotation != null) {
            targetNamespace = this.annotation.targetNamespace();
        }
        if (targetNamespace == null || "".equals(targetNamespace)) {
            targetNamespace = this.calculateNamespaceURI();
        }
        return targetNamespace;
    }

    public String getClientSimpleName() {
        String clientSimpleName = this.getSimpleName().toString();
        ClientName clientName = (ClientName)this.getAnnotation(ClientName.class);
        if (clientName != null) {
            clientSimpleName = clientName.value();
        }
        return clientSimpleName;
    }

    protected String calculateNamespaceURI() {
        PackageElement pkg = this.getPackage();
        if (pkg == null || "".equals(pkg.getQualifiedName().toString())) {
            throw new EnunciateException(this.getQualifiedName() + ": a web service in no package must specify a target namespace.");
        }
        String[] tokens = pkg.getQualifiedName().toString().split("\\.");
        Object uri = "http://";
        for (int i = tokens.length - 1; i >= 0; --i) {
            uri = (String)uri + tokens[i];
            if (i == 0) continue;
            uri = (String)uri + ".";
        }
        uri = (String)uri + "/";
        return uri;
    }

    public Set<String> getReferencedNamespaces() {
        HashSet<String> namespaces = new HashSet<String>();
        namespaces.add(this.getTargetNamespace());
        List<WebMethod> webMethods = this.getWebMethods();
        for (WebMethod webMethod : webMethods) {
            namespaces.addAll(webMethod.getReferencedNamespaces());
        }
        return namespaces;
    }

    public List<WebMethod> getWebMethods() {
        return this.webMethods;
    }

    public boolean isWebMethod(ExecutableElement method) {
        boolean isWebMethod = method.getModifiers().contains((Object)Modifier.PUBLIC);
        jakarta.jws.WebMethod annotation = method.getAnnotation(jakarta.jws.WebMethod.class);
        if (annotation != null) {
            isWebMethod &= !annotation.exclude();
        } else if (this.aggressiveWebMethodExcludePolicy) {
            isWebMethod = false;
        }
        return isWebMethod;
    }

    public Collection<EndpointImplementation> getEndpointImplementations() {
        return this.impls;
    }

    protected boolean isEndpointImplementation(TypeElement declaration) {
        if (ElementUtils.isClassOrRecord((Element)declaration) && !declaration.getQualifiedName().equals(this.getQualifiedName())) {
            WebService webServiceInfo = declaration.getAnnotation(WebService.class);
            return webServiceInfo != null && this.getQualifiedName().toString().equals(webServiceInfo.endpointInterface());
        }
        return false;
    }

    public SOAPBinding.Style getSoapBindingStyle() {
        SOAPBinding.Style style = SOAPBinding.Style.DOCUMENT;
        SOAPBinding bindingInfo = (SOAPBinding)this.getAnnotation(SOAPBinding.class);
        if (bindingInfo != null) {
            style = bindingInfo.style();
        }
        return style;
    }

    public Collection<BindingType> getBindingTypes() {
        ArrayList<BindingType> bindingTypes = new ArrayList<BindingType>();
        for (EndpointImplementation implementation : this.getEndpointImplementations()) {
            bindingTypes.add(implementation.getBindingType());
        }
        if (bindingTypes.isEmpty()) {
            bindingTypes.add(BindingType.SOAP_1_1);
        }
        return bindingTypes;
    }

    public String getSoapBindingName() {
        Object name = this.getSimpleName() + "PortBinding";
        SoapBindingName bindingNameInfo = (SoapBindingName)this.getAnnotation(SoapBindingName.class);
        if (bindingNameInfo != null) {
            name = bindingNameInfo.value();
        }
        return name;
    }

    public SOAPBinding.Use getSoapUse() {
        SOAPBinding.Use use = SOAPBinding.Use.LITERAL;
        SOAPBinding bindingInfo = (SOAPBinding)this.getAnnotation(SOAPBinding.class);
        if (bindingInfo != null) {
            use = bindingInfo.use();
        }
        return use;
    }

    public SOAPBinding.ParameterStyle getSoapParameterStyle() {
        SOAPBinding.ParameterStyle style = SOAPBinding.ParameterStyle.WRAPPED;
        SOAPBinding bindingInfo = (SOAPBinding)this.getAnnotation(SOAPBinding.class);
        if (bindingInfo != null) {
            style = bindingInfo.parameterStyle();
        }
        return style;
    }

    public Map<String, Object> getMetaData() {
        return Collections.unmodifiableMap(this.metaData);
    }

    public void putMetaData(String name, Object data) {
        this.metaData.put(name, data);
    }

    public Set<Facet> getFacets() {
        return this.facets;
    }
}

