/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.util;

import com.whaleal.icefrog.core.collection.CollUtil;
import com.whaleal.icefrog.core.convert.BasicType;
import com.whaleal.icefrog.core.exceptions.UtilException;
import com.whaleal.icefrog.core.lang.Assert;
import com.whaleal.icefrog.core.lang.JarClassLoader;
import com.whaleal.icefrog.core.lang.SimpleCache;
import com.whaleal.icefrog.core.util.ClassUtil;
import com.whaleal.icefrog.core.util.StrUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ClassLoaderUtil {
    private static final String ARRAY_SUFFIX = "[]";
    private static final String INTERNAL_ARRAY_PREFIX = "[";
    private static final String NON_PRIMITIVE_ARRAY_PREFIX = "[L";
    private static final char PACKAGE_SEPARATOR = '.';
    private static final char INNER_CLASS_SEPARATOR = '$';
    private static final Map<String, Class<?>> PRIMITIVE_TYPE_NAME_MAP = new ConcurrentHashMap(32);
    private static final SimpleCache<String, Class<?>> CLASS_CACHE = new SimpleCache();

    public static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
    }

    public static ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return AccessController.doPrivileged(ClassLoader::getSystemClassLoader);
    }

    public static ClassLoader getClassLoader() {
        ClassLoader classLoader = ClassLoaderUtil.getContextClassLoader();
        if (classLoader == null && null == (classLoader = ClassLoaderUtil.class.getClassLoader())) {
            classLoader = ClassLoaderUtil.getSystemClassLoader();
        }
        return classLoader;
    }

    public static Class<?> loadClass(String name) throws UtilException {
        return ClassLoaderUtil.loadClass(name, true);
    }

    public static Class<?> loadClass(String name, boolean isInitialized) throws UtilException {
        return ClassLoaderUtil.loadClass(name, null, isInitialized);
    }

    public static Class<?> loadClass(String name, ClassLoader classLoader, boolean isInitialized) throws UtilException {
        Class<?> clazz;
        block11: {
            Assert.notNull(name, "Name must not be null", new Object[0]);
            clazz = ClassLoaderUtil.loadPrimitiveClass(name);
            if (clazz == null) {
                clazz = CLASS_CACHE.get(name);
            }
            if (clazz != null) {
                return clazz;
            }
            if (name.endsWith(ARRAY_SUFFIX)) {
                String elementClassName = name.substring(0, name.length() - ARRAY_SUFFIX.length());
                Class<?> elementClass = ClassLoaderUtil.loadClass(elementClassName, classLoader, isInitialized);
                clazz = Array.newInstance(elementClass, 0).getClass();
            } else if (name.startsWith(NON_PRIMITIVE_ARRAY_PREFIX) && name.endsWith(";")) {
                String elementName = name.substring(NON_PRIMITIVE_ARRAY_PREFIX.length(), name.length() - 1);
                Class<?> elementClass = ClassLoaderUtil.loadClass(elementName, classLoader, isInitialized);
                clazz = Array.newInstance(elementClass, 0).getClass();
            } else if (name.startsWith(INTERNAL_ARRAY_PREFIX)) {
                String elementName = name.substring(INTERNAL_ARRAY_PREFIX.length());
                Class<?> elementClass = ClassLoaderUtil.loadClass(elementName, classLoader, isInitialized);
                clazz = Array.newInstance(elementClass, 0).getClass();
            } else {
                if (null == classLoader) {
                    classLoader = ClassLoaderUtil.getClassLoader();
                }
                try {
                    clazz = Class.forName(name, isInitialized, classLoader);
                }
                catch (ClassNotFoundException ex) {
                    clazz = ClassLoaderUtil.tryLoadInnerClass(name, classLoader, isInitialized);
                    if (null != clazz) break block11;
                    throw new UtilException(ex);
                }
            }
        }
        return CLASS_CACHE.put(name, clazz);
    }

    public static Class<?> loadPrimitiveClass(String name) {
        Class<?> result = null;
        if (StrUtil.isNotBlank(name) && (name = name.trim()).length() <= 8) {
            result = PRIMITIVE_TYPE_NAME_MAP.get(name);
        }
        return result;
    }

    public static JarClassLoader getJarClassLoader(File jarOrDir) {
        return JarClassLoader.load(jarOrDir);
    }

    public static Class<?> loadClass(File jarOrDir, String name) {
        try {
            return ClassLoaderUtil.getJarClassLoader(jarOrDir).loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new UtilException(e);
        }
    }

    public static boolean isPresent(String className) {
        return ClassLoaderUtil.isPresent(className, null);
    }

    public static boolean isPresent(String className, ClassLoader classLoader) {
        try {
            ClassLoaderUtil.loadClass(className, classLoader, false);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static Class<?> loadClass(String className, Class<?> referrer) throws ClassNotFoundException {
        ClassLoader classLoader = ClassLoaderUtil.getReferrerClassLoader(referrer);
        return ClassLoaderUtil.loadClass(className, classLoader);
    }

    public static Class<?> loadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        if (className == null) {
            return null;
        }
        if (classLoader == null) {
            return Class.forName(className);
        }
        return Class.forName(className, true, classLoader);
    }

    private static ClassLoader getReferrerClassLoader(Class<?> referrer) {
        ClassLoader classLoader = null;
        if (referrer != null && (classLoader = referrer.getClassLoader()) == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    public static URL[] getResources(String resourceName) {
        LinkedList<URL> urls = CollUtil.createLinkedList();
        boolean found = false;
        found = ClassLoaderUtil.getResources(urls, resourceName, ClassLoaderUtil.getContextClassLoader(), false);
        if (!found) {
            found = ClassLoaderUtil.getResources(urls, resourceName, ClassLoaderUtil.class.getClassLoader(), false);
        }
        if (!found) {
            found = ClassLoaderUtil.getResources(urls, resourceName, null, true);
        }
        return ClassLoaderUtil.getDistinctURLs(urls);
    }

    public static URL[] getResources(String resourceName, Class<?> referrer) {
        ClassLoader classLoader = ClassLoaderUtil.getReferrerClassLoader(referrer);
        LinkedList<URL> urls = CollUtil.createLinkedList();
        ClassLoaderUtil.getResources(urls, resourceName, classLoader, classLoader == null);
        return ClassLoaderUtil.getDistinctURLs(urls);
    }

    public static URL[] getResources(String resourceName, ClassLoader classLoader) {
        LinkedList<URL> urls = CollUtil.createLinkedList();
        ClassLoaderUtil.getResources(urls, resourceName, classLoader, classLoader == null);
        return ClassLoaderUtil.getDistinctURLs(urls);
    }

    private static boolean getResources(List<URL> urlSet, String resourceName, ClassLoader classLoader, boolean sysClassLoader) {
        if (resourceName == null) {
            return false;
        }
        Enumeration<URL> i = null;
        try {
            if (classLoader != null) {
                i = classLoader.getResources(resourceName);
            } else if (sysClassLoader) {
                i = ClassLoader.getSystemResources(resourceName);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (i != null && i.hasMoreElements()) {
            while (i.hasMoreElements()) {
                urlSet.add(i.nextElement());
            }
            return true;
        }
        return false;
    }

    private static URL[] getDistinctURLs(List<URL> urls) {
        if (urls == null || urls.size() == 0) {
            return new URL[0];
        }
        HashSet urlSet = CollUtil.createHashSet();
        Iterator<URL> i = urls.iterator();
        while (i.hasNext()) {
            URL url = i.next();
            if (urlSet.contains(url)) {
                i.remove();
                continue;
            }
            urlSet.add(url);
        }
        return urls.toArray(new URL[urls.size()]);
    }

    public static URL getResource(String resourceName) {
        if (resourceName == null) {
            return null;
        }
        ClassLoader classLoader = null;
        URL url = null;
        classLoader = ClassLoaderUtil.getContextClassLoader();
        if (classLoader != null && (url = classLoader.getResource(resourceName)) != null) {
            return url;
        }
        classLoader = ClassLoaderUtil.class.getClassLoader();
        if (classLoader != null && (url = classLoader.getResource(resourceName)) != null) {
            return url;
        }
        return ClassLoader.getSystemResource(resourceName);
    }

    public static URL getResource(String resourceName, Class<?> referrer) {
        if (resourceName == null) {
            return null;
        }
        ClassLoader classLoader = ClassLoaderUtil.getReferrerClassLoader(referrer);
        return classLoader == null ? ClassLoaderUtil.class.getClassLoader().getResource(resourceName) : classLoader.getResource(resourceName);
    }

    public static URL getResource(String resourceName, ClassLoader classLoader) {
        if (resourceName == null) {
            return null;
        }
        return classLoader == null ? ClassLoaderUtil.class.getClassLoader().getResource(resourceName) : classLoader.getResource(resourceName);
    }

    public static InputStream getResourceAsStream(String resourceName) {
        URL url = ClassLoaderUtil.getResource(resourceName);
        try {
            if (url != null) {
                return url.openStream();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static InputStream getResourceAsStream(String resourceName, Class<?> referrer) {
        URL url = ClassLoaderUtil.getResource(resourceName, referrer);
        try {
            if (url != null) {
                return url.openStream();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static InputStream getResourceAsStream(String resourceName, ClassLoader classLoader) {
        URL url = ClassLoaderUtil.getResource(resourceName, classLoader);
        try {
            if (url != null) {
                return url.openStream();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static URL[] whichClasses(String className) {
        return ClassLoaderUtil.getResources(ClassUtil.getResourceNameForClass(className));
    }

    public static URL[] whichClasses(String className, Class<?> referrer) {
        return ClassLoaderUtil.getResources(ClassUtil.getResourceNameForClass(className), referrer);
    }

    public static URL[] whichClasses(String className, ClassLoader classLoader) {
        return ClassLoaderUtil.getResources(ClassUtil.getResourceNameForClass(className), classLoader);
    }

    public static URL whichClass(String className) {
        return ClassLoaderUtil.getResource(ClassUtil.getResourceNameForClass(className));
    }

    public static URL whichClass(String className, Class<?> referrer) {
        return ClassLoaderUtil.getResource(ClassUtil.getResourceNameForClass(className), referrer);
    }

    public static URL whichClass(String className, ClassLoader classLoader) {
        return ClassLoaderUtil.getResource(ClassUtil.getResourceNameForClass(className), classLoader);
    }

    private static Class<?> tryLoadInnerClass(String name, ClassLoader classLoader, boolean isInitialized) {
        int lastDotIndex = name.lastIndexOf(46);
        if (lastDotIndex > 0) {
            String innerClassName = name.substring(0, lastDotIndex) + '$' + name.substring(lastDotIndex + 1);
            try {
                return Class.forName(innerClassName, isInitialized, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        ArrayList primitiveTypes = new ArrayList(32);
        primitiveTypes.addAll(BasicType.PRIMITIVE_WRAPPER_MAP.keySet());
        primitiveTypes.add(boolean[].class);
        primitiveTypes.add(byte[].class);
        primitiveTypes.add(char[].class);
        primitiveTypes.add(double[].class);
        primitiveTypes.add(float[].class);
        primitiveTypes.add(int[].class);
        primitiveTypes.add(long[].class);
        primitiveTypes.add(short[].class);
        primitiveTypes.add(Void.TYPE);
        for (Class clazz : primitiveTypes) {
            PRIMITIVE_TYPE_NAME_MAP.put(clazz.getName(), clazz);
        }
    }
}

