/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.cron.pattern;

import com.whaleal.icefrog.core.collection.CollUtil;
import com.whaleal.icefrog.core.date.DateUnit;
import com.whaleal.icefrog.core.date.DateUtil;
import com.whaleal.icefrog.core.lang.Assert;
import com.whaleal.icefrog.cron.pattern.CronPattern;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CronPatternUtil {
    public static Date nextDateAfter(CronPattern pattern, Date start, boolean isMatchSecond) {
        List<Date> matchedDates = CronPatternUtil.matchedDates(pattern, start.getTime(), DateUtil.endOfYear(start).getTime(), 1, isMatchSecond);
        if (CollUtil.isNotEmpty(matchedDates)) {
            return matchedDates.get(0);
        }
        return null;
    }

    public static List<Date> matchedDates(String patternStr, Date start, int count, boolean isMatchSecond) {
        return CronPatternUtil.matchedDates(patternStr, start, DateUtil.endOfYear(start), count, isMatchSecond);
    }

    public static List<Date> matchedDates(String patternStr, Date start, Date end, int count, boolean isMatchSecond) {
        return CronPatternUtil.matchedDates(patternStr, start.getTime(), end.getTime(), count, isMatchSecond);
    }

    public static List<Date> matchedDates(String patternStr, long start, long end, int count, boolean isMatchSecond) {
        return CronPatternUtil.matchedDates(new CronPattern(patternStr), start, end, count, isMatchSecond);
    }

    public static List<Date> matchedDates(CronPattern pattern, long start, long end, int count, boolean isMatchSecond) {
        Assert.isTrue(start < end, "Start date is later than end !");
        ArrayList<Date> result = new ArrayList<Date>(count);
        long step = isMatchSecond ? DateUnit.SECOND.getMillis() : DateUnit.MINUTE.getMillis();
        for (long i = start; i < end; i += step) {
            if (!pattern.match(i, isMatchSecond)) continue;
            result.add(DateUtil.date(i));
            if (result.size() >= count) break;
        }
        return result;
    }
}

