/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.extra.ftp;

import com.whaleal.icefrog.core.collection.ListUtil;
import com.whaleal.icefrog.core.io.FileUtil;
import com.whaleal.icefrog.core.io.IORuntimeException;
import com.whaleal.icefrog.core.lang.Assert;
import com.whaleal.icefrog.core.lang.Filter;
import com.whaleal.icefrog.core.util.ArrayUtil;
import com.whaleal.icefrog.core.util.CharsetUtil;
import com.whaleal.icefrog.core.util.StrUtil;
import com.whaleal.icefrog.extra.ftp.AbstractFtp;
import com.whaleal.icefrog.extra.ftp.FtpConfig;
import com.whaleal.icefrog.extra.ftp.FtpException;
import com.whaleal.icefrog.extra.ftp.FtpMode;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class Ftp
extends AbstractFtp {
    public static final int DEFAULT_PORT = 21;
    private FTPClient client;
    private FtpMode mode;
    private boolean backToPwd;

    public Ftp(String host) {
        this(host, 21);
    }

    public Ftp(String host, int port) {
        this(host, port, "anonymous", "");
    }

    public Ftp(String host, int port, String user, String password) {
        this(host, port, user, password, CharsetUtil.CHARSET_UTF_8);
    }

    public Ftp(String host, int port, String user, String password, Charset charset) {
        this(host, port, user, password, charset, null, null);
    }

    public Ftp(String host, int port, String user, String password, Charset charset, String serverLanguageCode, String systemKey) {
        this(host, port, user, password, charset, serverLanguageCode, systemKey, null);
    }

    public Ftp(String host, int port, String user, String password, Charset charset, String serverLanguageCode, String systemKey, FtpMode mode) {
        this(new FtpConfig(host, port, user, password, charset, serverLanguageCode, systemKey), mode);
    }

    public Ftp(FtpConfig config, FtpMode mode) {
        super(config);
        this.mode = mode;
        this.init();
    }

    public Ftp init() {
        return this.init(this.ftpConfig, this.mode);
    }

    public Ftp init(String host, int port, String user, String password) {
        return this.init(host, port, user, password, null);
    }

    public Ftp init(String host, int port, String user, String password, FtpMode mode) {
        return this.init(new FtpConfig(host, port, user, password, this.ftpConfig.getCharset(), null, null), mode);
    }

    public Ftp init(FtpConfig config, FtpMode mode) {
        FTPClient client = new FTPClient();
        client.setRemoteVerificationEnabled(false);
        Charset charset = config.getCharset();
        if (null != charset) {
            client.setControlEncoding(charset.toString());
        }
        client.setConnectTimeout((int)config.getConnectionTimeout());
        String systemKey = config.getSystemKey();
        if (StrUtil.isNotBlank(systemKey)) {
            FTPClientConfig conf = new FTPClientConfig(systemKey);
            String serverLanguageCode = config.getServerLanguageCode();
            if (StrUtil.isNotBlank(serverLanguageCode)) {
                conf.setServerLanguageCode(config.getServerLanguageCode());
            }
            client.configure(conf);
        }
        try {
            client.connect(config.getHost(), config.getPort());
            client.setSoTimeout((int)config.getSoTimeout());
            client.login(config.getUser(), config.getPassword());
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        int replyCode = client.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)replyCode)) {
            try {
                client.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new FtpException("Login failed for user [{}], reply code is: [{}]", config.getUser(), replyCode);
        }
        this.client = client;
        if (mode != null) {
            this.setMode(mode);
        }
        return this;
    }

    public Ftp setMode(FtpMode mode) {
        this.mode = mode;
        switch (mode) {
            case Active: {
                this.client.enterLocalActiveMode();
                break;
            }
            case Passive: {
                this.client.enterLocalPassiveMode();
            }
        }
        return this;
    }

    public Ftp setBackToPwd(boolean backToPwd) {
        this.backToPwd = backToPwd;
        return this;
    }

    @Override
    public Ftp reconnectIfTimeout() {
        String pwd = null;
        try {
            pwd = this.pwd();
        }
        catch (IORuntimeException iORuntimeException) {
            // empty catch block
        }
        if (pwd == null) {
            return this.init();
        }
        return this;
    }

    @Override
    public synchronized boolean cd(String directory) {
        if (StrUtil.isBlank(directory)) {
            return true;
        }
        try {
            return this.client.changeWorkingDirectory(directory);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    @Override
    public String pwd() {
        try {
            return this.client.printWorkingDirectory();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    @Override
    public List<String> ls(String path) {
        return ArrayUtil.map(this.lsFiles(path), FTPFile::getName);
    }

    public List<FTPFile> lsFiles(String path, Filter<FTPFile> filter) {
        FTPFile[] ftpFiles = this.lsFiles(path);
        if (ArrayUtil.isEmpty(ftpFiles)) {
            return ListUtil.empty();
        }
        ArrayList<FTPFile> result = new ArrayList<FTPFile>(ftpFiles.length - 2 <= 0 ? ftpFiles.length : ftpFiles.length - 2);
        for (FTPFile ftpFile : ftpFiles) {
            String fileName = ftpFile.getName();
            if (StrUtil.equals(".", fileName) || StrUtil.equals("..", fileName) || null != filter && !filter.accept(ftpFile)) continue;
            result.add(ftpFile);
        }
        return result;
    }

    public FTPFile[] lsFiles(String path) throws FtpException, IORuntimeException {
        FTPFile[] ftpFiles;
        String pwd = null;
        if (StrUtil.isNotBlank(path)) {
            pwd = this.pwd();
            if (!this.isDir(path)) {
                throw new FtpException("Change dir to [{}] error, maybe path not exist!", path);
            }
        }
        try {
            ftpFiles = this.client.listFiles();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            this.cd(pwd);
        }
        return ftpFiles;
    }

    @Override
    public boolean mkdir(String dir) throws IORuntimeException {
        try {
            return this.client.makeDirectory(dir);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public int stat(String path) throws IORuntimeException {
        try {
            return this.client.stat(path);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public boolean existFile(String path) throws IORuntimeException {
        FTPFile[] ftpFileArr;
        try {
            ftpFileArr = this.client.listFiles(path);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return ArrayUtil.isNotEmpty(ftpFileArr);
    }

    @Override
    public boolean delFile(String path) throws IORuntimeException {
        boolean isSuccess;
        String pwd = this.pwd();
        String fileName = FileUtil.getName(path);
        String dir = StrUtil.removeSuffix(path, fileName);
        if (!this.isDir(dir)) {
            throw new FtpException("Change dir to [{}] error, maybe dir not exist!", path);
        }
        try {
            isSuccess = this.client.deleteFile(fileName);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            this.cd(pwd);
        }
        return isSuccess;
    }

    @Override
    public boolean delDir(String dirPath) throws IORuntimeException {
        FTPFile[] dirs;
        try {
            dirs = this.client.listFiles(dirPath);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        for (FTPFile ftpFile : dirs) {
            String name = ftpFile.getName();
            String childPath = StrUtil.format("{}/{}", dirPath, name);
            if (ftpFile.isDirectory()) {
                if (".".equals(name) || "..".equals(name)) continue;
                this.delDir(childPath);
                continue;
            }
            this.delFile(childPath);
        }
        try {
            return this.client.removeDirectory(dirPath);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    @Override
    public boolean upload(String destPath, File file) {
        Assert.notNull(file, "file to upload is null !", new Object[0]);
        return this.upload(destPath, file.getName(), file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean upload(String path, String fileName, File file) throws IORuntimeException {
        try (BufferedInputStream in = FileUtil.getInputStream(file);){
            boolean bl = this.upload(path, fileName, in);
            return bl;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public boolean upload(String path, String fileName, InputStream fileStream) throws IORuntimeException {
        try {
            this.client.setFileType(2);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        String pwd = null;
        if (this.backToPwd) {
            pwd = this.pwd();
        }
        if (StrUtil.isNotBlank(path)) {
            this.mkDirs(path);
            if (!this.isDir(path)) {
                throw new FtpException("Change dir to [{}] error, maybe dir not exist!", path);
            }
        }
        try {
            boolean bl = this.client.storeFile(fileName, fileStream);
            return bl;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            if (this.backToPwd) {
                this.cd(pwd);
            }
        }
    }

    @Override
    public void download(String path, File outFile) {
        String fileName = FileUtil.getName(path);
        String dir = StrUtil.removeSuffix(path, fileName);
        this.download(dir, fileName, outFile);
    }

    @Override
    public void recursiveDownloadFolder(String sourcePath, File destDir) {
        for (FTPFile ftpFile : this.lsFiles(sourcePath, null)) {
            String fileName = ftpFile.getName();
            String srcFile = StrUtil.format("{}/{}", sourcePath, fileName);
            File destFile = FileUtil.file(destDir, fileName);
            if (!ftpFile.isDirectory()) {
                if (FileUtil.exist(destFile) && ftpFile.getTimestamp().getTimeInMillis() <= destFile.lastModified()) continue;
                this.download(srcFile, destFile);
                continue;
            }
            FileUtil.mkdir(destFile);
            this.recursiveDownloadFolder(srcFile, destFile);
        }
    }

    public void download(String path, String fileName, File outFile) throws IORuntimeException {
        if (outFile.isDirectory()) {
            outFile = new File(outFile, fileName);
        }
        if (!outFile.exists()) {
            FileUtil.touch(outFile);
        }
        try (BufferedOutputStream out = FileUtil.getOutputStream(outFile);){
            this.download(path, fileName, out);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public void download(String path, String fileName, OutputStream out) {
        this.download(path, fileName, out, null);
    }

    public void download(String path, String fileName, OutputStream out, Charset fileNameCharset) throws IORuntimeException {
        String pwd = null;
        if (this.backToPwd) {
            pwd = this.pwd();
        }
        if (!this.isDir(path)) {
            throw new FtpException("Change dir to [{}] error, maybe dir not exist!", path);
        }
        if (null != fileNameCharset) {
            fileName = new String(fileName.getBytes(fileNameCharset), StandardCharsets.ISO_8859_1);
        }
        try {
            this.client.setFileType(2);
            this.client.retrieveFile(fileName, out);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            if (this.backToPwd) {
                this.cd(pwd);
            }
        }
    }

    public FTPClient getClient() {
        return this.client;
    }

    @Override
    public void close() throws IOException {
        if (null != this.client) {
            this.client.logout();
            if (this.client.isConnected()) {
                this.client.disconnect();
            }
            this.client = null;
        }
    }
}

