/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.socket;

import com.whaleal.icefrog.core.io.IORuntimeException;
import com.whaleal.icefrog.core.lang.Assert;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.ClosedChannelException;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.net.ServerSocketFactory;

public class SocketUtil {
    public static final int PORT_RANGE_MIN = 1024;
    public static final int PORT_RANGE_MAX = 65535;
    private static final Random random = new Random(System.nanoTime());

    public static SocketAddress getRemoteAddress(AsynchronousSocketChannel channel) {
        try {
            return null == channel ? null : channel.getRemoteAddress();
        }
        catch (ClosedChannelException e) {
            return null;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static boolean isConnected(AsynchronousSocketChannel channel) {
        return null != SocketUtil.getRemoteAddress(channel);
    }

    public static Socket connect(String hostname, int port) throws IORuntimeException {
        return SocketUtil.connect(hostname, port, -1);
    }

    public static Socket connect(String hostname, int port, int connectionTimeout) throws IORuntimeException {
        return SocketUtil.connect(new InetSocketAddress(hostname, port), connectionTimeout);
    }

    public static Socket connect(InetSocketAddress address, int connectionTimeout) throws IORuntimeException {
        Socket socket = new Socket();
        try {
            if (connectionTimeout <= 0) {
                socket.connect(address);
            } else {
                socket.connect(address, connectionTimeout);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return socket;
    }

    public static int findAvailableTcpPort() {
        return SocketUtil.findAvailableTcpPort(1024);
    }

    public static int findAvailableTcpPort(int minPort) {
        return SocketUtil.findAvailableTcpPort(minPort, 65535);
    }

    public static int findAvailableTcpPort(int minPort, int maxPort) {
        return SocketType.TCP.findAvailablePort(minPort, maxPort);
    }

    public static SortedSet<Integer> findAvailableTcpPorts(int numRequested) {
        return SocketUtil.findAvailableTcpPorts(numRequested, 1024, 65535);
    }

    public static SortedSet<Integer> findAvailableTcpPorts(int numRequested, int minPort, int maxPort) {
        return SocketType.TCP.findAvailablePorts(numRequested, minPort, maxPort);
    }

    public static int findAvailableUdpPort() {
        return SocketUtil.findAvailableUdpPort(1024);
    }

    public static int findAvailableUdpPort(int minPort) {
        return SocketUtil.findAvailableUdpPort(minPort, 65535);
    }

    public static int findAvailableUdpPort(int minPort, int maxPort) {
        return SocketType.UDP.findAvailablePort(minPort, maxPort);
    }

    public static SortedSet<Integer> findAvailableUdpPorts(int numRequested) {
        return SocketUtil.findAvailableUdpPorts(numRequested, 1024, 65535);
    }

    public static SortedSet<Integer> findAvailableUdpPorts(int numRequested, int minPort, int maxPort) {
        return SocketType.UDP.findAvailablePorts(numRequested, minPort, maxPort);
    }

    private static enum SocketType {
        TCP{

            @Override
            protected boolean isPortAvailable(int port) {
                try {
                    ServerSocket serverSocket = ServerSocketFactory.getDefault().createServerSocket(port, 1, InetAddress.getByName("localhost"));
                    serverSocket.close();
                    return true;
                }
                catch (Exception ex) {
                    return false;
                }
            }
        }
        ,
        UDP{

            @Override
            protected boolean isPortAvailable(int port) {
                try {
                    DatagramSocket socket = new DatagramSocket(port, InetAddress.getByName("localhost"));
                    socket.close();
                    return true;
                }
                catch (Exception ex) {
                    return false;
                }
            }
        };


        protected abstract boolean isPortAvailable(int var1);

        private int findRandomPort(int minPort, int maxPort) {
            int portRange = maxPort - minPort;
            return minPort + random.nextInt(portRange + 1);
        }

        int findAvailablePort(int minPort, int maxPort) {
            int candidatePort;
            Assert.isTrue(minPort > 0, "'minPort' must be greater than 0");
            Assert.isTrue(maxPort >= minPort, "'maxPort' must be greater than or equal to 'minPort'");
            Assert.isTrue(maxPort <= 65535, "'maxPort' must be less than or equal to 65535");
            int portRange = maxPort - minPort;
            int searchCounter = 0;
            do {
                if (searchCounter > portRange) {
                    throw new IllegalStateException(String.format("Could not find an available %s port in the range [%d, %d] after %d attempts", this.name(), minPort, maxPort, searchCounter));
                }
                candidatePort = this.findRandomPort(minPort, maxPort);
                ++searchCounter;
            } while (!this.isPortAvailable(candidatePort));
            return candidatePort;
        }

        SortedSet<Integer> findAvailablePorts(int numRequested, int minPort, int maxPort) {
            Assert.isTrue(minPort > 0, "'minPort' must be greater than 0");
            Assert.isTrue(maxPort > minPort, "'maxPort' must be greater than 'minPort'");
            Assert.isTrue(maxPort <= 65535, "'maxPort' must be less than or equal to 65535");
            Assert.isTrue(numRequested > 0, "'numRequested' must be greater than 0");
            Assert.isTrue(maxPort - minPort >= numRequested, "'numRequested' must not be greater than 'maxPort' - 'minPort'");
            TreeSet<Integer> availablePorts = new TreeSet<Integer>();
            int attemptCount = 0;
            while (++attemptCount <= numRequested + 100 && availablePorts.size() < numRequested) {
                availablePorts.add(this.findAvailablePort(minPort, maxPort));
            }
            if (availablePorts.size() != numRequested) {
                throw new IllegalStateException(String.format("Could not find %d available %s ports in the range [%d, %d]", numRequested, this.name(), minPort, maxPort));
            }
            return availablePorts;
        }
    }
}

