/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.io.copy;

import com.whaleal.icefrog.core.io.IORuntimeException;
import com.whaleal.icefrog.core.io.StreamProgress;
import com.whaleal.icefrog.core.io.copy.IoCopier;
import com.whaleal.icefrog.core.lang.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class ChannelCopier
extends IoCopier<ReadableByteChannel, WritableByteChannel> {
    public ChannelCopier() {
        this(8192);
    }

    public ChannelCopier(int bufferSize) {
        this(bufferSize, -1L);
    }

    public ChannelCopier(int bufferSize, long count) {
        this(bufferSize, count, null);
    }

    public ChannelCopier(int bufferSize, long count, StreamProgress progress) {
        super(bufferSize, count, progress);
    }

    @Override
    public long copy(ReadableByteChannel source, WritableByteChannel target) {
        long size;
        Preconditions.notNull(source, "InputStream is null !", new Object[0]);
        Preconditions.notNull(target, "OutputStream is null !", new Object[0]);
        StreamProgress progress = this.progress;
        if (null != progress) {
            progress.start();
        }
        try {
            size = this.doCopy(source, target, ByteBuffer.allocate(this.bufferSize(this.count)), progress);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        if (null != progress) {
            progress.finish();
        }
        return size;
    }

    private long doCopy(ReadableByteChannel source, WritableByteChannel target, ByteBuffer buffer, StreamProgress progress) throws IOException {
        int read;
        long numToRead = this.count > 0L ? this.count : Long.MAX_VALUE;
        long total = 0L;
        while (numToRead > 0L && (read = source.read(buffer)) >= 0) {
            buffer.flip();
            target.write(buffer);
            buffer.clear();
            numToRead -= (long)read;
            total += (long)read;
            if (null == progress) continue;
            progress.progress(total);
        }
        return total;
    }
}

