/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.lang;

import com.whaleal.icefrog.core.date.SystemClock;
import com.whaleal.icefrog.core.util.IdUtil;
import com.whaleal.icefrog.core.util.StrUtil;
import java.io.Serializable;
import java.util.Date;

public class Snowflake
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final long WORKER_ID_BITS = 5L;
    private static final long MAX_WORKER_ID = 31L;
    private static final long DATA_CENTER_ID_BITS = 5L;
    private static final long MAX_DATA_CENTER_ID = 31L;
    private static final long SEQUENCE_BITS = 12L;
    private static final long WORKER_ID_SHIFT = 12L;
    private static final long DATA_CENTER_ID_SHIFT = 17L;
    private static final long TIMESTAMP_LEFT_SHIFT = 22L;
    private static final long SEQUENCE_MASK = 4095L;
    public static long DEFAULT_TWEPOCH = 1288834974657L;
    public static long DEFAULT_TIME_OFFSET = 2000L;
    private final long twepoch;
    private final long workerId;
    private final long dataCenterId;
    private final boolean useSystemClock;
    private final long timeOffset;
    private long sequence = 0L;
    private long lastTimestamp = -1L;

    public Snowflake() {
        this(IdUtil.getWorkerId(IdUtil.getDataCenterId(31L), 31L));
    }

    public Snowflake(long workerId) {
        this(workerId, IdUtil.getDataCenterId(31L));
    }

    public Snowflake(long workerId, long dataCenterId) {
        this(workerId, dataCenterId, false);
    }

    public Snowflake(long workerId, long dataCenterId, boolean isUseSystemClock) {
        this(null, workerId, dataCenterId, isUseSystemClock);
    }

    public Snowflake(Date epochDate, long workerId, long dataCenterId, boolean isUseSystemClock) {
        this(epochDate, workerId, dataCenterId, isUseSystemClock, DEFAULT_TIME_OFFSET);
    }

    public Snowflake(Date epochDate, long workerId, long dataCenterId, boolean isUseSystemClock, long timeOffset) {
        this.twepoch = null != epochDate ? epochDate.getTime() : DEFAULT_TWEPOCH;
        if (workerId > 31L || workerId < 0L) {
            throw new IllegalArgumentException(StrUtil.format("worker Id can't be greater than {} or less than 0", 31L));
        }
        if (dataCenterId > 31L || dataCenterId < 0L) {
            throw new IllegalArgumentException(StrUtil.format("datacenter Id can't be greater than {} or less than 0", 31L));
        }
        this.workerId = workerId;
        this.dataCenterId = dataCenterId;
        this.useSystemClock = isUseSystemClock;
        this.timeOffset = timeOffset;
    }

    public long getWorkerId(long id) {
        return id >> 12 & 0x1FL;
    }

    public long getDataCenterId(long id) {
        return id >> 17 & 0x1FL;
    }

    public long getGenerateDateTime(long id) {
        return (id >> 22 & 0x1FFFFFFFFFFL) + this.twepoch;
    }

    public synchronized long nextId() {
        long timestamp = this.genTime();
        if (timestamp < this.lastTimestamp) {
            if (this.lastTimestamp - timestamp < this.timeOffset) {
                timestamp = this.lastTimestamp;
            } else {
                throw new IllegalStateException(StrUtil.format("Clock moved backwards. Refusing to generate id for {}ms", this.lastTimestamp - timestamp));
            }
        }
        if (timestamp == this.lastTimestamp) {
            long sequence = this.sequence + 1L & 0xFFFL;
            if (sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
            this.sequence = sequence;
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - this.twepoch << 22 | this.dataCenterId << 17 | this.workerId << 12 | this.sequence;
    }

    public String nextIdStr() {
        return Long.toString(this.nextId());
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.genTime();
        while (timestamp == lastTimestamp) {
            timestamp = this.genTime();
        }
        if (timestamp < lastTimestamp) {
            throw new IllegalStateException(StrUtil.format("Clock moved backwards. Refusing to generate id for {}ms", lastTimestamp - timestamp));
        }
        return timestamp;
    }

    private long genTime() {
        return this.useSystemClock ? SystemClock.now() : System.currentTimeMillis();
    }
}

