/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.thread;

import com.whaleal.icefrog.core.exceptions.UtilException;
import com.whaleal.icefrog.core.thread.ThreadUtil;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;

public class SyncFinisher {
    private final Set<Worker> workers;
    private final int threadSize;
    private ExecutorService executorService;
    private boolean isBeginAtSameTime;
    private final CountDownLatch beginLatch = new CountDownLatch(1);
    private CountDownLatch endLatch;

    public SyncFinisher(int threadSize) {
        this.threadSize = threadSize;
        this.workers = new LinkedHashSet<Worker>();
    }

    public SyncFinisher setBeginAtSameTime(boolean isBeginAtSameTime) {
        this.isBeginAtSameTime = isBeginAtSameTime;
        return this;
    }

    public SyncFinisher addRepeatWorker(final Runnable runnable) {
        for (int i = 0; i < this.threadSize; ++i) {
            this.addWorker(new Worker(){

                @Override
                public void work() {
                    runnable.run();
                }
            });
        }
        return this;
    }

    public SyncFinisher addWorker(final Runnable runnable) {
        return this.addWorker(new Worker(){

            @Override
            public void work() {
                runnable.run();
            }
        });
    }

    public synchronized SyncFinisher addWorker(Worker worker) {
        this.workers.add(worker);
        return this;
    }

    public void start() {
        this.start(true);
    }

    public void start(boolean sync) {
        this.endLatch = new CountDownLatch(this.workers.size());
        if (null == this.executorService || this.executorService.isShutdown()) {
            this.executorService = ThreadUtil.newExecutor(this.threadSize);
        }
        for (Worker worker : this.workers) {
            this.executorService.submit(worker);
        }
        this.beginLatch.countDown();
        if (sync) {
            try {
                this.endLatch.await();
            }
            catch (InterruptedException e) {
                throw new UtilException(e);
            }
        }
    }

    public void stop() {
        if (null != this.executorService) {
            this.executorService.shutdown();
        }
        this.executorService = null;
        this.clearWorker();
    }

    public void clearWorker() {
        this.workers.clear();
    }

    public long count() {
        return this.endLatch.getCount();
    }

    public abstract class Worker
    implements Runnable {
        @Override
        public void run() {
            if (SyncFinisher.this.isBeginAtSameTime) {
                try {
                    SyncFinisher.this.beginLatch.await();
                }
                catch (InterruptedException e) {
                    throw new UtilException(e);
                }
            }
            try {
                this.work();
            }
            finally {
                SyncFinisher.this.endLatch.countDown();
            }
        }

        public abstract void work();
    }
}

