/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.db.ds.druid;

import com.alibaba.druid.pool.DruidDataSource;
import com.whaleal.icefrog.core.util.StrUtil;
import com.whaleal.icefrog.db.ds.AbstractDSFactory;
import com.whaleal.icefrog.setting.Setting;
import com.whaleal.icefrog.setting.dialect.Props;
import java.util.Properties;
import javax.sql.DataSource;

public class DruidDSFactory
extends AbstractDSFactory {
    private static final long serialVersionUID = 4680621702534433222L;
    public static final String DS_NAME = "Druid";

    public DruidDSFactory() {
        this((Setting)null);
    }

    public DruidDSFactory(Setting setting) {
        super(DS_NAME, DruidDataSource.class, setting);
    }

    @Override
    protected DataSource createDataSource(String jdbcUrl, String driver, String user, String pass, Setting poolSetting) {
        DruidDataSource ds = new DruidDataSource();
        ds.setUrl(jdbcUrl);
        ds.setDriverClassName(driver);
        ds.setUsername(user);
        ds.setPassword(pass);
        for (String key2 : KEY_CONN_PROPS) {
            String connValue = poolSetting.getAndRemoveStr(key2);
            if (!StrUtil.isNotBlank(connValue)) continue;
            ds.addConnectionProperty(key2, connValue);
        }
        Props druidProps = new Props();
        poolSetting.forEach((key, value) -> druidProps.put(StrUtil.addPrefixIfNot(key, "druid."), value));
        ds.configFromPropety((Properties)druidProps);
        if (null == ds.getValidationQuery()) {
            ds.setTestOnBorrow(false);
            ds.setTestOnReturn(false);
            ds.setTestWhileIdle(false);
        }
        return ds;
    }
}

