/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.setting.dialect;

import com.whaleal.icefrog.core.bean.BeanUtil;
import com.whaleal.icefrog.core.convert.Convert;
import com.whaleal.icefrog.core.getter.BasicTypeGetter;
import com.whaleal.icefrog.core.getter.OptBasicTypeGetter;
import com.whaleal.icefrog.core.io.FileUtil;
import com.whaleal.icefrog.core.io.IORuntimeException;
import com.whaleal.icefrog.core.io.IoUtil;
import com.whaleal.icefrog.core.io.resource.ClassPathResource;
import com.whaleal.icefrog.core.io.resource.FileResource;
import com.whaleal.icefrog.core.io.resource.Resource;
import com.whaleal.icefrog.core.io.resource.ResourceUtil;
import com.whaleal.icefrog.core.io.resource.UrlResource;
import com.whaleal.icefrog.core.io.watch.SimpleWatcher;
import com.whaleal.icefrog.core.io.watch.WatchMonitor;
import com.whaleal.icefrog.core.io.watch.WatchUtil;
import com.whaleal.icefrog.core.io.watch.Watcher;
import com.whaleal.icefrog.core.lang.Preconditions;
import com.whaleal.icefrog.core.map.MapUtil;
import com.whaleal.icefrog.core.util.CharsetUtil;
import com.whaleal.icefrog.core.util.ReflectUtil;
import com.whaleal.icefrog.core.util.StrUtil;
import com.whaleal.icefrog.log.StaticLog;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.util.Date;
import java.util.Map;
import java.util.Properties;

public final class Props
extends Properties
implements BasicTypeGetter<String>,
OptBasicTypeGetter<String> {
    private static final long serialVersionUID = 1935981579709590740L;
    public static final String EXT_NAME = "properties";
    private Resource resource;
    private WatchMonitor watchMonitor;
    private transient Charset charset = CharsetUtil.CHARSET_ISO_8859_1;

    public static Props create() {
        return new Props();
    }

    public static Props getProp(String resource) {
        return new Props(resource);
    }

    public static Props getProp(String resource, String charsetName) {
        return new Props(resource, charsetName);
    }

    public static Props getProp(String resource, Charset charset) {
        return new Props(resource, charset);
    }

    public Props() {
    }

    public Props(String path) {
        this(path, CharsetUtil.CHARSET_ISO_8859_1);
    }

    public Props(String path, String charsetName) {
        this(path, CharsetUtil.charset(charsetName));
    }

    public Props(String path, Charset charset) {
        Preconditions.notBlank(path, "Blank properties file path !", new Object[0]);
        if (null != charset) {
            this.charset = charset;
        }
        this.load(ResourceUtil.getResourceObj(path));
    }

    public Props(File propertiesFile) {
        this(propertiesFile, StandardCharsets.ISO_8859_1);
    }

    public Props(File propertiesFile, String charsetName) {
        this(propertiesFile, Charset.forName(charsetName));
    }

    public Props(File propertiesFile, Charset charset) {
        Preconditions.notNull(propertiesFile, "Null properties file!", new Object[0]);
        this.charset = charset;
        this.load(new FileResource(propertiesFile));
    }

    public Props(String path, Class<?> clazz) {
        this(path, clazz, "ISO-8859-1");
    }

    public Props(String path, Class<?> clazz, String charsetName) {
        this(path, clazz, CharsetUtil.charset(charsetName));
    }

    public Props(String path, Class<?> clazz, Charset charset) {
        Preconditions.notBlank(path, "Blank properties file path !", new Object[0]);
        if (null != charset) {
            this.charset = charset;
        }
        this.load(new ClassPathResource(path, clazz));
    }

    public Props(URL propertiesUrl) {
        this(propertiesUrl, StandardCharsets.ISO_8859_1);
    }

    public Props(URL propertiesUrl, String charsetName) {
        this(propertiesUrl, CharsetUtil.charset(charsetName));
    }

    public Props(URL propertiesUrl, Charset charset) {
        Preconditions.notNull(propertiesUrl, "Null properties URL !", new Object[0]);
        if (null != charset) {
            this.charset = charset;
        }
        this.load(propertiesUrl);
    }

    public Props(Properties properties) {
        if (MapUtil.isNotEmpty(properties)) {
            this.putAll((Map<?, ?>)properties);
        }
    }

    public void load(URL url) {
        this.load(new UrlResource(url));
    }

    public void load(Resource resource) {
        Preconditions.notNull(resource, "Props resource must be not null!", new Object[0]);
        this.resource = resource;
        try (BufferedReader reader = resource.getReader(this.charset);){
            super.load(reader);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public void load() {
        this.load(this.resource);
    }

    public void autoLoad(boolean autoReload) {
        if (autoReload) {
            Preconditions.notNull(this.resource, "Properties resource must be not null!", new Object[0]);
            if (null != this.watchMonitor) {
                this.watchMonitor.close();
            }
            this.watchMonitor = WatchUtil.createModify(this.resource.getUrl(), (Watcher)new SimpleWatcher(){

                @Override
                public void onModify(WatchEvent<?> event, Path currentPath) {
                    Props.this.load();
                }
            });
            this.watchMonitor.start();
        } else {
            IoUtil.close(this.watchMonitor);
            this.watchMonitor = null;
        }
    }

    @Override
    public Object getObj(String key, Object defaultValue) {
        return this.getStr(key, null == defaultValue ? null : defaultValue.toString());
    }

    @Override
    public Object getObj(String key) {
        return this.getObj(key, (Object)null);
    }

    @Override
    public String getStr(String key, String defaultValue) {
        return super.getProperty(key, defaultValue);
    }

    @Override
    public String getStr(String key) {
        return super.getProperty(key);
    }

    @Override
    public Integer getInt(String key, Integer defaultValue) {
        return Convert.toInt(this.getStr(key), defaultValue);
    }

    @Override
    public Integer getInt(String key) {
        return this.getInt(key, (Integer)null);
    }

    @Override
    public Boolean getBool(String key, Boolean defaultValue) {
        return Convert.toBool(this.getStr(key), defaultValue);
    }

    @Override
    public Boolean getBool(String key) {
        return this.getBool(key, (Boolean)null);
    }

    @Override
    public Long getLong(String key, Long defaultValue) {
        return Convert.toLong(this.getStr(key), defaultValue);
    }

    @Override
    public Long getLong(String key) {
        return this.getLong(key, (Long)null);
    }

    @Override
    public Character getChar(String key, Character defaultValue) {
        String value = this.getStr(key);
        if (StrUtil.isBlank(value)) {
            return defaultValue;
        }
        return Character.valueOf(value.charAt(0));
    }

    @Override
    public Character getChar(String key) {
        return this.getChar(key, (Character)null);
    }

    @Override
    public Float getFloat(String key) {
        return this.getFloat(key, (Float)null);
    }

    @Override
    public Float getFloat(String key, Float defaultValue) {
        return Convert.toFloat(this.getStr(key), defaultValue);
    }

    @Override
    public Double getDouble(String key, Double defaultValue) throws NumberFormatException {
        return Convert.toDouble(this.getStr(key), defaultValue);
    }

    @Override
    public Double getDouble(String key) throws NumberFormatException {
        return this.getDouble(key, (Double)null);
    }

    @Override
    public Short getShort(String key, Short defaultValue) {
        return Convert.toShort(this.getStr(key), defaultValue);
    }

    @Override
    public Short getShort(String key) {
        return this.getShort(key, (Short)null);
    }

    @Override
    public Byte getByte(String key, Byte defaultValue) {
        return Convert.toByte(this.getStr(key), defaultValue);
    }

    @Override
    public Byte getByte(String key) {
        return this.getByte(key, (Byte)null);
    }

    @Override
    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        String valueStr = this.getStr(key);
        if (StrUtil.isBlank(valueStr)) {
            return defaultValue;
        }
        try {
            return new BigDecimal(valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public BigDecimal getBigDecimal(String key) {
        return this.getBigDecimal(key, (BigDecimal)null);
    }

    @Override
    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        String valueStr = this.getStr(key);
        if (StrUtil.isBlank(valueStr)) {
            return defaultValue;
        }
        try {
            return new BigInteger(valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public BigInteger getBigInteger(String key) {
        return this.getBigInteger(key, (BigInteger)null);
    }

    @Override
    public <E extends Enum<E>> E getEnum(Class<E> clazz, String key, E defaultValue) {
        return Convert.toEnum(clazz, this.getStr(key), defaultValue);
    }

    @Override
    public <E extends Enum<E>> E getEnum(Class<E> clazz, String key) {
        return this.getEnum(clazz, key, (E)null);
    }

    @Override
    public Date getDate(String key, Date defaultValue) {
        return Convert.toDate(this.getStr(key), defaultValue);
    }

    @Override
    public Date getDate(String key) {
        return this.getDate(key, (Date)null);
    }

    public String getAndRemoveStr(String ... keys) {
        String key;
        Object value = null;
        String[] stringArray = keys;
        int n = stringArray.length;
        for (int i = 0; i < n && null == (value = this.remove(key = stringArray[i])); ++i) {
        }
        return (String)value;
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this);
        return properties;
    }

    public <T> T toBean(Class<T> beanClass) {
        return this.toBean(beanClass, null);
    }

    public <T> T toBean(Class<T> beanClass, String prefix) {
        T bean = ReflectUtil.newInstanceIfPossible(beanClass);
        return this.fillBean(bean, prefix);
    }

    public <T> T fillBean(T bean, String prefix) {
        prefix = StrUtil.nullToEmpty(StrUtil.addSuffixIfNot(prefix, "."));
        for (Map.Entry<Object, Object> entry : this.entrySet()) {
            String key = (String)entry.getKey();
            if (!StrUtil.startWith((CharSequence)key, prefix)) continue;
            try {
                BeanUtil.setProperty(bean, StrUtil.subSuf(key, prefix.length()), entry.getValue());
            }
            catch (Exception e) {
                StaticLog.debug("Ignore property: [{}]", key);
            }
        }
        return bean;
    }

    public void setProperty(String key, Object value) {
        super.setProperty(key, value.toString());
    }

    public void store(String absolutePath) throws IORuntimeException {
        BufferedWriter writer = null;
        try {
            writer = FileUtil.getWriter(absolutePath, this.charset, false);
            super.store(writer, null);
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e, "Store properties to [{}] error!", absolutePath);
            }
            catch (Throwable throwable) {
                IoUtil.close(writer);
                throw throwable;
            }
        }
        IoUtil.close(writer);
    }

    public void store(String path, Class<?> clazz) {
        this.store(FileUtil.getAbsolutePath(path, clazz));
    }
}

