/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.bean;

import com.whaleal.icefrog.core.bean.PropDesc;
import com.whaleal.icefrog.core.lang.Preconditions;
import com.whaleal.icefrog.core.map.CaseInsensitiveMap;
import com.whaleal.icefrog.core.util.BooleanUtil;
import com.whaleal.icefrog.core.util.ModifierUtil;
import com.whaleal.icefrog.core.util.ReflectUtil;
import com.whaleal.icefrog.core.util.StrUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class BeanDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Class<?> beanClass;
    private final Map<String, PropDesc> propMap = new LinkedHashMap<String, PropDesc>();

    public BeanDesc(Class<?> beanClass) {
        Preconditions.notNull(beanClass);
        this.beanClass = beanClass;
        this.init();
    }

    public String getName() {
        return this.beanClass.getName();
    }

    public String getSimpleName() {
        return this.beanClass.getSimpleName();
    }

    public Map<String, PropDesc> getPropMap(boolean ignoreCase) {
        return ignoreCase ? new CaseInsensitiveMap<String, PropDesc>(1.0f, this.propMap) : this.propMap;
    }

    public Collection<PropDesc> getProps() {
        return this.propMap.values();
    }

    public PropDesc getProp(String fieldName) {
        return this.propMap.get(fieldName);
    }

    public Field getField(String fieldName) {
        PropDesc desc = this.propMap.get(fieldName);
        return null == desc ? null : desc.getField();
    }

    public Method getGetter(String fieldName) {
        PropDesc desc = this.propMap.get(fieldName);
        return null == desc ? null : desc.getGetter();
    }

    public Method getSetter(String fieldName) {
        PropDesc desc = this.propMap.get(fieldName);
        return null == desc ? null : desc.getSetter();
    }

    private BeanDesc init() {
        Method[] methods = ReflectUtil.getMethods(this.beanClass);
        for (Field field : ReflectUtil.getFields(this.beanClass)) {
            if (ModifierUtil.isStatic(field)) continue;
            PropDesc prop = this.createProp(field, methods);
            this.propMap.putIfAbsent(prop.getFieldName(), prop);
        }
        return this;
    }

    private PropDesc createProp(Field field, Method[] methods) {
        PropDesc prop = this.findProp(field, methods, false);
        if (null == prop.getter || null == prop.setter) {
            PropDesc propIgnoreCase = this.findProp(field, methods, true);
            if (null == prop.getter) {
                prop.getter = propIgnoreCase.getter;
            }
            if (null == prop.setter) {
                prop.setter = propIgnoreCase.setter;
            }
        }
        return prop;
    }

    private PropDesc findProp(Field field, Method[] methods, boolean ignoreCase) {
        String fieldName = field.getName();
        Class<?> fieldType = field.getType();
        boolean isBooleanField = BooleanUtil.isBoolean(fieldType);
        Method getter = null;
        Method setter = null;
        for (Method method : methods) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length > 1) continue;
            String methodName = method.getName();
            if (parameterTypes.length == 0) {
                if (this.isMatchGetter(methodName, fieldName, isBooleanField, ignoreCase)) {
                    getter = method;
                }
            } else if (this.isMatchSetter(methodName, fieldName, isBooleanField, ignoreCase)) {
                setter = method;
            }
            if (null != getter && null != setter) break;
        }
        return new PropDesc(field, getter, setter);
    }

    private boolean isMatchGetter(String methodName, String fieldName, boolean isBooleanField, boolean ignoreCase) {
        String handledFieldName;
        if (ignoreCase) {
            methodName = methodName.toLowerCase();
            fieldName = handledFieldName = fieldName.toLowerCase();
        } else {
            handledFieldName = StrUtil.upperFirst(fieldName);
        }
        if (!methodName.startsWith("get") && !methodName.startsWith("is")) {
            return false;
        }
        if ("getclass".equals(methodName)) {
            return false;
        }
        if (isBooleanField && (fieldName.startsWith("is") ? methodName.equals(fieldName) || ("get" + handledFieldName).equals(methodName) || ("is" + handledFieldName).equals(methodName) : ("is" + handledFieldName).equals(methodName))) {
            return true;
        }
        return ("get" + handledFieldName).equals(methodName);
    }

    private boolean isMatchSetter(String methodName, String fieldName, boolean isBooleanField, boolean ignoreCase) {
        String handledFieldName;
        if (ignoreCase) {
            methodName = methodName.toLowerCase();
            fieldName = handledFieldName = fieldName.toLowerCase();
        } else {
            handledFieldName = StrUtil.upperFirst(fieldName);
        }
        if (!methodName.startsWith("set")) {
            return false;
        }
        if (isBooleanField && fieldName.startsWith("is") && (("set" + StrUtil.removePrefix(fieldName, "is")).equals(methodName) || ("set" + handledFieldName).equals(methodName))) {
            return true;
        }
        return ("set" + fieldName).equals(methodName);
    }
}

