/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.util;

import com.whaleal.icefrog.core.lang.Preconditions;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.CheckForNull;

public abstract class AbstractIterator<T>
implements Iterator<T> {
    private State state = State.NOT_READY;
    @CheckForNull
    private T next;

    protected AbstractIterator() {
    }

    @CheckForNull
    protected abstract T computeNext();

    @CheckForNull
    protected final T endOfData() {
        this.state = State.DONE;
        return null;
    }

    @Override
    public final boolean hasNext() {
        Preconditions.checkState(this.state != State.FAILED);
        switch (this.state) {
            case DONE: {
                return false;
            }
            case READY: {
                return true;
            }
        }
        return this.tryToComputeNext();
    }

    private boolean tryToComputeNext() {
        this.state = State.FAILED;
        this.next = this.computeNext();
        if (this.state != State.DONE) {
            this.state = State.READY;
            return true;
        }
        return false;
    }

    @Override
    public final T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.state = State.NOT_READY;
        T result = this.next;
        this.next = null;
        return result;
    }

    public final T peek() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.next;
    }

    private static enum State {
        READY,
        NOT_READY,
        DONE,
        FAILED;

    }
}

