/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.db.ds.tomcat;

import com.whaleal.icefrog.core.util.StrUtil;
import com.whaleal.icefrog.db.ds.AbstractDSFactory;
import com.whaleal.icefrog.setting.Setting;
import com.whaleal.icefrog.setting.dialect.Props;
import java.util.Properties;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.PoolProperties;

public class TomcatDSFactory
extends AbstractDSFactory {
    private static final long serialVersionUID = 4925514193275150156L;
    public static final String DS_NAME = "Tomcat-Jdbc-Pool";

    public TomcatDSFactory() {
        this((Setting)null);
    }

    public TomcatDSFactory(Setting setting) {
        super(DS_NAME, DataSource.class, setting);
    }

    @Override
    protected javax.sql.DataSource createDataSource(String jdbcUrl, String driver, String user, String pass, Setting poolSetting) {
        PoolProperties poolProps = new PoolProperties();
        poolProps.setUrl(jdbcUrl);
        poolProps.setDriverClassName(driver);
        poolProps.setUsername(user);
        poolProps.setPassword(pass);
        Props connProps = new Props();
        for (String key : KEY_CONN_PROPS) {
            String connValue = poolSetting.getAndRemoveStr(key);
            if (!StrUtil.isNotBlank(connValue)) continue;
            connProps.setProperty(key, connValue);
        }
        poolProps.setDbProperties((Properties)connProps);
        poolSetting.toBean(poolProps);
        return new DataSource((PoolConfiguration)poolProps);
    }
}

