/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.extra.pinyin.engine;

import com.whaleal.icefrog.core.lang.Singleton;
import com.whaleal.icefrog.core.util.ServiceLoaderUtil;
import com.whaleal.icefrog.core.util.StrUtil;
import com.whaleal.icefrog.extra.pinyin.PinyinEngine;
import com.whaleal.icefrog.extra.pinyin.PinyinException;
import com.whaleal.icefrog.log.StaticLog;

public class PinyinFactory {
    public static PinyinEngine get() {
        return Singleton.get(PinyinEngine.class.getName(), PinyinFactory::create);
    }

    public static PinyinEngine create() {
        PinyinEngine engine = PinyinFactory.doCreate();
        StaticLog.debug("Use [{}] Engine As Default.", StrUtil.removeSuffix(engine.getClass().getSimpleName(), "Engine"));
        return engine;
    }

    private static PinyinEngine doCreate() {
        PinyinEngine engine = ServiceLoaderUtil.loadFirstAvailable(PinyinEngine.class);
        if (null != engine) {
            return engine;
        }
        throw new PinyinException("No pinyin jar found ! Please add one of it to your project !");
    }
}

