/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.extra.compress.extractor;

import com.whaleal.icefrog.core.io.FileUtil;
import com.whaleal.icefrog.core.io.IORuntimeException;
import com.whaleal.icefrog.core.io.IoUtil;
import com.whaleal.icefrog.core.lang.Filter;
import com.whaleal.icefrog.core.lang.Preconditions;
import com.whaleal.icefrog.core.util.StrUtil;
import com.whaleal.icefrog.extra.compress.CompressException;
import com.whaleal.icefrog.extra.compress.extractor.Extractor;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;

public class StreamExtractor
implements Extractor {
    private final ArchiveInputStream in;

    public StreamExtractor(Charset charset, File file) {
        this(charset, null, file);
    }

    public StreamExtractor(Charset charset, String archiverName, File file) {
        this(charset, archiverName, FileUtil.getInputStream(file));
    }

    public StreamExtractor(Charset charset, InputStream in) {
        this(charset, null, in);
    }

    public StreamExtractor(Charset charset, String archiverName, InputStream in) {
        ArchiveStreamFactory factory = new ArchiveStreamFactory(charset.name());
        try {
            in = IoUtil.toBuffered(in);
            this.in = StrUtil.isBlank(archiverName) ? factory.createArchiveInputStream(in) : factory.createArchiveInputStream(archiverName, in);
        }
        catch (ArchiveException e) {
            throw new CompressException(e);
        }
    }

    @Override
    public void extract(File targetDir, Filter<ArchiveEntry> filter) {
        try {
            this.extractInternal(targetDir, filter);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            this.close();
        }
    }

    private void extractInternal(File targetDir, Filter<ArchiveEntry> filter) throws IOException {
        ArchiveEntry entry;
        Preconditions.isTrue(null != targetDir && (false == targetDir.exists() || targetDir.isDirectory()), "target must be dir.");
        ArchiveInputStream in = this.in;
        while (null != (entry = in.getNextEntry())) {
            if (!in.canReadEntryData(entry)) continue;
            File outItemFile = FileUtil.file(targetDir, entry.getName());
            if (entry.isDirectory()) {
                outItemFile.mkdirs();
                continue;
            }
            FileUtil.writeFromStream((InputStream)in, outItemFile, false);
        }
    }

    @Override
    public void close() {
        IoUtil.close((Closeable)this.in);
    }
}

