/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.io.watch.watchers;

import com.whaleal.icefrog.core.collection.CollUtil;
import com.whaleal.icefrog.core.io.watch.Watcher;
import com.whaleal.icefrog.core.lang.Chain;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.util.Iterator;
import java.util.List;

public class WatcherChain
implements Watcher,
Chain<Watcher, WatcherChain> {
    private final List<Watcher> chain;

    public static WatcherChain create(Watcher ... watchers) {
        return new WatcherChain(watchers);
    }

    public WatcherChain(Watcher ... watchers) {
        this.chain = CollUtil.newArrayList(watchers);
    }

    @Override
    public void onCreate(WatchEvent<?> event, Path currentPath) {
        for (Watcher watcher : this.chain) {
            watcher.onCreate(event, currentPath);
        }
    }

    @Override
    public void onModify(WatchEvent<?> event, Path currentPath) {
        for (Watcher watcher : this.chain) {
            watcher.onModify(event, currentPath);
        }
    }

    @Override
    public void onDelete(WatchEvent<?> event, Path currentPath) {
        for (Watcher watcher : this.chain) {
            watcher.onDelete(event, currentPath);
        }
    }

    @Override
    public void onOverflow(WatchEvent<?> event, Path currentPath) {
        for (Watcher watcher : this.chain) {
            watcher.onOverflow(event, currentPath);
        }
    }

    @Override
    public Iterator<Watcher> iterator() {
        return this.chain.iterator();
    }

    @Override
    public WatcherChain addChain(Watcher element) {
        this.chain.add(element);
        return this;
    }
}

