/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.util;

import com.whaleal.icefrog.core.lang.Preconditions;
import com.whaleal.icefrog.core.util.StrUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class StrParsingUtil
extends StrUtil {
    private static final String UPPER = "\\p{Lu}|\\P{InBASIC_LATIN}";
    private static final String LOWER = "\\p{Ll}";
    private static final String CAMEL_CASE_REGEX = "(?<!(^|[%u_$]))(?=[%u])|(?<!^)(?=[%u][%l])".replace("%u", "\\p{Lu}|\\P{InBASIC_LATIN}").replace("%l", "\\p{Ll}");
    private static final Pattern CAMEL_CASE = Pattern.compile(CAMEL_CASE_REGEX);

    public static List<String> splitCamelCase(String source) {
        return StrParsingUtil.split(source, false);
    }

    public static List<String> splitCamelCaseToLower(String source) {
        return StrParsingUtil.split(source, true);
    }

    public static String reconcatenateCamelCase(String source, String delimiter) {
        Preconditions.notNull(source, "Source string must not be null!", new Object[0]);
        Preconditions.notNull(delimiter, "Delimiter must not be null!", new Object[0]);
        return StrUtil.collectionToDelimitedString(StrParsingUtil.splitCamelCaseToLower(source), delimiter);
    }

    private static List<String> split(String source, boolean toLower) {
        Preconditions.notNull(source, "Source string must not be null!", new Object[0]);
        String[] parts = CAMEL_CASE.split(source);
        ArrayList<String> result = new ArrayList<String>(parts.length);
        for (String part : parts) {
            result.add(toLower ? part.toLowerCase() : part);
        }
        return Collections.unmodifiableList(result);
    }
}

