/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.extra.tokenizer.engine.jcseg;

import com.whaleal.icefrog.extra.tokenizer.Result;
import com.whaleal.icefrog.extra.tokenizer.TokenizerException;
import com.whaleal.icefrog.extra.tokenizer.Word;
import com.whaleal.icefrog.extra.tokenizer.engine.jcseg.JcsegWord;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.lionsoul.jcseg.ISegment;
import org.lionsoul.jcseg.IWord;

public class JcsegResult
implements Result {
    private final ISegment result;
    private Word cachedWord;

    public JcsegResult(ISegment segment) {
        this.result = segment;
    }

    @Override
    public boolean hasNext() {
        IWord next;
        if (this.cachedWord != null) {
            return true;
        }
        try {
            next = this.result.next();
        }
        catch (IOException e) {
            throw new TokenizerException(e);
        }
        if (null != next) {
            this.cachedWord = new JcsegWord(next);
            return true;
        }
        return false;
    }

    @Override
    public Word next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more word !");
        }
        Word currentWord = this.cachedWord;
        this.cachedWord = null;
        return currentWord;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Jcseg result not allow to remove !");
    }

    @Override
    public Iterator<Word> iterator() {
        return this;
    }
}

