/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.extra.emoji.encode;

import com.whaleal.icefrog.extra.emoji.fitzpatrick.FitzpatrickAction;
import com.whaleal.icefrog.extra.emoji.model.UnicodeCandidate;
import com.whaleal.icefrog.extra.emoji.transformer.EmojiTransformer;

public enum EmojiEncode {
    ALIASES(new EmojiTransformer(){

        @Override
        public String transform(UnicodeCandidate unicodeCandidate, FitzpatrickAction fitzpatrickAction) {
            if (fitzpatrickAction == null) {
                fitzpatrickAction = FitzpatrickAction.PARSE;
            }
            if (fitzpatrickAction == FitzpatrickAction.PARSE && unicodeCandidate.hasFitzpatrick()) {
                return ":" + unicodeCandidate.getEmoji().getAliases().get(0) + "|" + unicodeCandidate.getFitzpatrickType() + ":";
            }
            if (fitzpatrickAction == FitzpatrickAction.IGNORE) {
                return ":" + unicodeCandidate.getEmoji().getAliases().get(0) + ":" + unicodeCandidate.getFitzpatrickUnicode();
            }
            return ":" + unicodeCandidate.getEmoji().getAliases().get(0) + ":";
        }
    }),
    HTML_DECIMAL(new EmojiTransformer(){

        @Override
        public String transform(UnicodeCandidate unicodeCandidate, FitzpatrickAction fitzpatrickAction) {
            if (fitzpatrickAction == null) {
                fitzpatrickAction = FitzpatrickAction.PARSE;
            }
            if (fitzpatrickAction == FitzpatrickAction.IGNORE) {
                return unicodeCandidate.getEmoji().getHtmlDecimal() + unicodeCandidate.getFitzpatrickUnicode();
            }
            return unicodeCandidate.getEmoji().getHtmlDecimal();
        }
    }),
    HTML_HEX_DECIMAL(new EmojiTransformer(){

        @Override
        public String transform(UnicodeCandidate unicodeCandidate, FitzpatrickAction fitzpatrickAction) {
            if (fitzpatrickAction == null) {
                fitzpatrickAction = FitzpatrickAction.PARSE;
            }
            if (fitzpatrickAction == FitzpatrickAction.IGNORE) {
                return unicodeCandidate.getEmoji().getHtmlHexadecimal() + unicodeCandidate.getFitzpatrickUnicode();
            }
            return unicodeCandidate.getEmoji().getHtmlHexadecimal();
        }
    });

    private EmojiTransformer emojiTransformer;

    private EmojiEncode(EmojiTransformer emojiTransformer) {
        this.emojiTransformer = emojiTransformer;
    }

    public EmojiTransformer getEmojiTransformer() {
        return this.emojiTransformer;
    }
}

