/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.collection;

import com.whaleal.icefrog.core.collection.CollUtil;
import com.whaleal.icefrog.core.collection.CopiedIter;
import com.whaleal.icefrog.core.collection.EnumerationIter;
import com.whaleal.icefrog.core.collection.TransIter;
import com.whaleal.icefrog.core.exceptions.UtilException;
import com.whaleal.icefrog.core.lang.Editor;
import com.whaleal.icefrog.core.lang.Matcher;
import com.whaleal.icefrog.core.lang.Precondition;
import com.whaleal.icefrog.core.lang.Predicate;
import com.whaleal.icefrog.core.lang.func.Func1;
import com.whaleal.icefrog.core.map.MapUtil;
import com.whaleal.icefrog.core.text.StrJoiner;
import com.whaleal.icefrog.core.util.ObjectUtil;
import com.whaleal.icefrog.core.util.ReflectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.CheckForNull;

public class IterUtil {
    public static <T> Iterator<T> getIter(Iterable<T> iterable) {
        return null == iterable ? null : iterable.iterator();
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        return null == iterable || IterUtil.isEmpty(iterable.iterator());
    }

    public static boolean isEmpty(Iterator<?> Iterator2) {
        return null == Iterator2 || false == Iterator2.hasNext();
    }

    public static boolean isNotEmpty(Iterable<?> iterable) {
        return null != iterable && IterUtil.isNotEmpty(iterable.iterator());
    }

    public static boolean isNotEmpty(Iterator<?> Iterator2) {
        return null != Iterator2 && Iterator2.hasNext();
    }

    public static boolean hasNull(Iterable<?> iter) {
        return IterUtil.hasNull(null == iter ? null : iter.iterator());
    }

    public static boolean hasNull(Iterator<?> iter) {
        if (null == iter) {
            return true;
        }
        while (iter.hasNext()) {
            if (null != iter.next()) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllNull(Iterable<?> iter) {
        return IterUtil.isAllNull(null == iter ? null : iter.iterator());
    }

    public static boolean isAllNull(Iterator<?> iter) {
        return null == IterUtil.getFirstNoneNull(iter);
    }

    public static <T> Map<T, Integer> countMap(Iterator<T> iter) {
        HashMap<T, Integer> countMap = new HashMap<T, Integer>();
        if (null != iter) {
            while (iter.hasNext()) {
                T t = iter.next();
                countMap.put(t, countMap.getOrDefault(t, 0) + 1);
            }
        }
        return countMap;
    }

    public static <K, V> Map<K, V> fieldValueMap(Iterator<V> iter, String fieldName) {
        return IterUtil.toMap(iter, new HashMap(), (V value) -> ReflectUtil.getFieldValue(value, fieldName));
    }

    public static <K, V> Map<K, V> fieldValueAsMap(Iterator<?> iter, String fieldNameForKey, String fieldNameForValue) {
        return IterUtil.toMap(iter, new HashMap(), (E value) -> ReflectUtil.getFieldValue(value, fieldNameForKey), (E value) -> ReflectUtil.getFieldValue(value, fieldNameForValue));
    }

    public static <V> List<Object> fieldValueList(Iterable<V> iterable, String fieldName) {
        return IterUtil.fieldValueList(IterUtil.getIter(iterable), fieldName);
    }

    public static <V> List<Object> fieldValueList(Iterator<V> iter, String fieldName) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (null != iter) {
            while (iter.hasNext()) {
                V value = iter.next();
                result.add(ReflectUtil.getFieldValue(value, fieldName));
            }
        }
        return result;
    }

    public static <T> String join(Iterator<T> iterator, CharSequence conjunction) {
        return StrJoiner.of(conjunction).append(iterator).toString();
    }

    public static <T> String join(Iterator<T> iterator, CharSequence conjunction, String prefix, String suffix) {
        return StrJoiner.of(conjunction, prefix, suffix).setWrapElement(true).append(iterator).toString();
    }

    public static <T> String join(Iterator<T> iterator, CharSequence conjunction, Function<T, ? extends CharSequence> func) {
        if (null == iterator) {
            return null;
        }
        return StrJoiner.of(conjunction).append(iterator, func).toString();
    }

    public static <K, V> HashMap<K, V> toMap(Iterable<Map.Entry<K, V>> entryIter) {
        HashMap<K, V> map = new HashMap<K, V>();
        if (IterUtil.isNotEmpty(entryIter)) {
            for (Map.Entry<K, V> entry : entryIter) {
                map.put(entry.getKey(), entry.getValue());
            }
        }
        return map;
    }

    public static <K, V> Map<K, V> toMap(Iterable<K> keys, Iterable<V> values) {
        return IterUtil.toMap(keys, values, false);
    }

    public static <K, V> Map<K, V> toMap(Iterable<K> keys, Iterable<V> values, boolean isOrder) {
        return IterUtil.toMap(null == keys ? null : keys.iterator(), null == values ? null : values.iterator(), isOrder);
    }

    public static <K, V> Map<K, V> toMap(Iterator<K> keys, Iterator<V> values) {
        return IterUtil.toMap(keys, values, false);
    }

    public static <K, V> Map<K, V> toMap(Iterator<K> keys, Iterator<V> values, boolean isOrder) {
        HashMap<K, Object> resultMap = MapUtil.newHashMap(isOrder);
        if (IterUtil.isNotEmpty(keys)) {
            while (keys.hasNext()) {
                resultMap.put(keys.next(), null != values && values.hasNext() ? (Object)values.next() : null);
            }
        }
        return resultMap;
    }

    public static <K, V> Map<K, List<V>> toListMap(Iterable<V> iterable, Function<V, K> keyMapper) {
        return IterUtil.toListMap(iterable, keyMapper, v -> v);
    }

    public static <T, K, V> Map<K, List<V>> toListMap(Iterable<T> iterable, Function<T, K> keyMapper, Function<T, V> valueMapper) {
        return IterUtil.toListMap(MapUtil.newHashMap(), iterable, keyMapper, valueMapper);
    }

    public static <T, K, V> Map<K, List<V>> toListMap(Map<K, List<V>> resultMap, Iterable<T> iterable, Function<T, K> keyMapper, Function<T, V> valueMapper) {
        if (null == resultMap) {
            resultMap = MapUtil.newHashMap();
        }
        if (ObjectUtil.isNull(iterable)) {
            return resultMap;
        }
        for (T value : iterable) {
            resultMap.computeIfAbsent(keyMapper.apply(value), k -> new ArrayList()).add(valueMapper.apply(value));
        }
        return resultMap;
    }

    public static <K, V> Map<K, V> toMap(Iterable<V> iterable, Function<V, K> keyMapper) {
        return IterUtil.toMap(iterable, keyMapper, (T v) -> v);
    }

    public static <T, K, V> Map<K, V> toMap(Iterable<T> iterable, Function<T, K> keyMapper, Function<T, V> valueMapper) {
        return IterUtil.toMap(MapUtil.newHashMap(), iterable, keyMapper, valueMapper);
    }

    public static <T, K, V> Map<K, V> toMap(Map<K, V> resultMap, Iterable<T> iterable, Function<T, K> keyMapper, Function<T, V> valueMapper) {
        if (null == resultMap) {
            resultMap = MapUtil.newHashMap();
        }
        if (ObjectUtil.isNull(iterable)) {
            return resultMap;
        }
        for (T value : iterable) {
            resultMap.put(keyMapper.apply(value), valueMapper.apply(value));
        }
        return resultMap;
    }

    public static <E> List<E> toList(Iterable<E> iter) {
        if (null == iter) {
            return null;
        }
        return IterUtil.toList(iter.iterator());
    }

    public static <E> List<E> toList(Iterator<E> iter) {
        ArrayList<E> list = new ArrayList<E>();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public static <E> Iterator<E> asIterator(Enumeration<E> e) {
        return new EnumerationIter<E>(e);
    }

    public static <E> Iterable<E> asIterable(Iterator<E> iter) {
        return () -> iter;
    }

    public static <T> T getFirst(Iterable<T> iterable) {
        if (null == iterable) {
            return null;
        }
        return IterUtil.getFirst(iterable.iterator());
    }

    public static <T> T getFirstNoneNull(Iterable<T> iterable) {
        if (null == iterable) {
            return null;
        }
        return IterUtil.getFirstNoneNull(iterable.iterator());
    }

    public static <T> T getFirst(Iterator<T> iterator) {
        if (null != iterator && iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static <T> T getFirstNoneNull(Iterator<T> iterator) {
        return (T)IterUtil.firstMatch(iterator, Objects::nonNull);
    }

    public static <T> T firstMatch(Iterator<T> iterator, Matcher<T> matcher) {
        Precondition.notNull(matcher, "Matcher must be not null !", new Object[0]);
        if (null != iterator) {
            while (iterator.hasNext()) {
                T next = iterator.next();
                if (!matcher.match(next)) continue;
                return next;
            }
        }
        return null;
    }

    public static Class<?> getElementType(Iterable<?> iterable) {
        if (null != iterable) {
            Iterator<?> iterator = iterable.iterator();
            return IterUtil.getElementType(iterator);
        }
        return null;
    }

    public static Class<?> getElementType(Iterator<?> iterator) {
        Object t;
        CopiedIter iter2 = new CopiedIter(iterator);
        if (iter2.hasNext() && null != (t = iter2.next())) {
            return t.getClass();
        }
        return null;
    }

    public static <T> List<T> edit(Iterable<T> iter, Editor<T> editor) {
        ArrayList<T> result = new ArrayList<T>();
        if (null == iter) {
            return result;
        }
        for (T t : iter) {
            T modified = null == editor ? t : editor.edit(t);
            if (null == modified) continue;
            result.add(t);
        }
        return result;
    }

    public static <T extends Iterable<E>, E> T filter(T iter, Predicate<E> predicate) {
        if (null == iter) {
            return null;
        }
        IterUtil.filter(iter.iterator(), predicate);
        return iter;
    }

    public static <E> Iterator<E> filter(Iterator<E> iter, Predicate<E> predicate) {
        if (null == iter || null == predicate) {
            return iter;
        }
        while (iter.hasNext()) {
            if (predicate.apply(iter.next())) continue;
            iter.remove();
        }
        return iter;
    }

    public static <K, V> Map<K, V> toMap(Iterator<V> iterator, Map<K, V> map, Func1<V, K> keyFunc) {
        return IterUtil.toMap(iterator, map, keyFunc, (E value) -> value);
    }

    public static <K, V, E> Map<K, V> toMap(Iterator<E> iterator, Map<K, V> map, Func1<E, K> keyFunc, Func1<E, V> valueFunc) {
        if (null == iterator) {
            return map;
        }
        if (null == map) {
            map = MapUtil.newHashMap(true);
        }
        while (iterator.hasNext()) {
            E element = iterator.next();
            try {
                map.put(keyFunc.apply(element), valueFunc.apply(element));
            }
            catch (Exception e) {
                throw new UtilException(e);
            }
        }
        return map;
    }

    public static <T> Iterator<T> empty() {
        return Collections.emptyIterator();
    }

    public static <F, T> Iterable<T> trans(Iterable<F> iterable, Function<? super F, ? extends T> function) {
        if (iterable instanceof Collection) {
            return CollUtil.trans((Collection)iterable, function);
        }
        return CollUtil.trans(CollUtil.newArrayList(iterable), function);
    }

    public static <F, T> Iterator<T> trans(Iterator<F> iterator, Function<? super F, ? extends T> function) {
        return new TransIter<F, T>(iterator, function);
    }

    public static int size(Iterable<?> iterable) {
        if (null == iterable) {
            return 0;
        }
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        return IterUtil.size(iterable.iterator());
    }

    public static int size(Iterator<?> iterator) {
        int size = 0;
        if (iterator != null) {
            while (iterator.hasNext()) {
                iterator.next();
                ++size;
            }
        }
        return size;
    }

    public static boolean isEqualList(Iterable<?> list1, Iterable<?> list2) {
        if (list1 == list2) {
            return true;
        }
        Iterator<?> it1 = list1.iterator();
        Iterator<?> it2 = list2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            Object obj2;
            Object obj1 = it1.next();
            if (Objects.equals(obj1, obj2 = it2.next())) continue;
            return false;
        }
        return false == (it1.hasNext() || it2.hasNext());
    }

    public static boolean contains(Iterable<? extends Object> iterable, @CheckForNull Object element) {
        if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            return CollUtil.safeContains(collection, element);
        }
        return IterUtil.contains(iterable.iterator(), element);
    }

    public static boolean contains(Iterator<?> iterator, @CheckForNull Object element) {
        if (element == null) {
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                return true;
            }
        } else {
            while (iterator.hasNext()) {
                if (!element.equals(iterator.next())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean removeAll(Iterator<?> removeFrom, Collection<?> elementsToRemove) {
        Precondition.checkNotNull(elementsToRemove);
        boolean result = false;
        while (removeFrom.hasNext()) {
            if (!elementsToRemove.contains(removeFrom.next())) continue;
            removeFrom.remove();
            result = true;
        }
        return result;
    }

    public static <T> boolean removeIf(Iterable<T> removeFrom, Predicate<? super T> predicate) {
        if (removeFrom instanceof Collection) {
            return ((Collection)removeFrom).removeIf(predicate);
        }
        return IterUtil.removeIf(removeFrom.iterator(), predicate);
    }

    public static <T> boolean removeIf(Iterator<T> removeFrom, Predicate predicate) {
        Precondition.checkNotNull(predicate);
        boolean modified = false;
        while (removeFrom.hasNext()) {
            if (!predicate.apply(removeFrom.next())) continue;
            removeFrom.remove();
            modified = true;
        }
        return modified;
    }

    public static boolean retainAll(Iterator<?> removeFrom, Collection<?> elementsToRetain) {
        Precondition.checkNotNull(elementsToRetain);
        boolean result = false;
        while (removeFrom.hasNext()) {
            if (elementsToRetain.contains(removeFrom.next())) continue;
            removeFrom.remove();
            result = true;
        }
        return result;
    }

    @CheckForNull
    public static <T> T removeFirstMatching(Iterable<T> removeFrom, Predicate<? super T> predicate) {
        Precondition.checkNotNull(predicate);
        Iterator<T> iterator = removeFrom.iterator();
        while (iterator.hasNext()) {
            T next = iterator.next();
            if (!predicate.apply(next)) continue;
            iterator.remove();
            return next;
        }
        return null;
    }

    public static boolean elementsEqual(Iterator<?> iterator1, Iterator<?> iterator2) {
        while (iterator1.hasNext()) {
            Object o2;
            if (!iterator2.hasNext()) {
                return false;
            }
            Object o1 = iterator1.next();
            if (ObjectUtil.equal(o1, o2 = iterator2.next())) continue;
            return false;
        }
        return !iterator2.hasNext();
    }

    public static String toString(Iterable<?> iterable) {
        return IterUtil.toString(iterable.iterator());
    }

    public static String toString(Iterator<?> iterator) {
        StringBuilder sb = new StringBuilder().append('[');
        boolean first = true;
        while (iterator.hasNext()) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(iterator.next());
        }
        return sb.append(']').toString();
    }

    public static <T> T getOnlyElement(Iterable<T> iterable) {
        return IterUtil.getOnlyElement(iterable.iterator());
    }

    public static <T> T getOnlyElement(Iterator<T> iterator) {
        T first = iterator.next();
        if (!iterator.hasNext()) {
            return first;
        }
        StringBuilder sb = new StringBuilder().append("expected one element but was: <").append(first);
        for (int i = 0; i < 4 && iterator.hasNext(); ++i) {
            sb.append(", ").append(iterator.next());
        }
        if (iterator.hasNext()) {
            sb.append(", ...");
        }
        sb.append('>');
        throw new IllegalArgumentException(sb.toString());
    }

    public static <T> T getOnlyElement(Iterator<? extends T> iterator, T defaultValue) {
        return iterator.hasNext() ? IterUtil.getOnlyElement(iterator) : defaultValue;
    }

    public static <T> boolean addAll(Collection<T> addTo, Iterable<? extends T> elementsToAdd) {
        if (elementsToAdd instanceof Collection) {
            Collection c = (Collection)elementsToAdd;
            return addTo.addAll(c);
        }
        return IterUtil.addAll(addTo, Precondition.checkNotNull(elementsToAdd).iterator());
    }

    public static <T> boolean addAll(Collection<T> addTo, Iterator<? extends T> iterator) {
        Precondition.checkNotNull(addTo);
        Precondition.checkNotNull(iterator);
        boolean wasModified = false;
        while (iterator.hasNext()) {
            wasModified |= addTo.add(iterator.next());
        }
        return wasModified;
    }

    public static int frequency(Iterator<?> iterator, @CheckForNull Object element) {
        int count = 0;
        while (IterUtil.contains(iterator, element)) {
            ++count;
        }
        return count;
    }

    public static <T> boolean any(Iterator<T> iterator, Predicate predicate) {
        return IterUtil.indexOf(iterator, predicate) != -1;
    }

    public static <T> boolean all(Iterator<T> iterator, Predicate predicate) {
        Precondition.checkNotNull(predicate);
        while (iterator.hasNext()) {
            T element = iterator.next();
            if (predicate.apply(element)) continue;
            return false;
        }
        return true;
    }

    @CheckForNull
    public static <T> T find(Iterator<? extends T> iterator, Predicate predicate, @CheckForNull T defaultValue) {
        Precondition.checkNotNull(iterator);
        Precondition.checkNotNull(predicate);
        while (iterator.hasNext()) {
            T t = iterator.next();
            if (!predicate.apply(t)) continue;
            return t;
        }
        return defaultValue;
    }

    public static <T> Optional<T> tryFind(Iterator<T> iterator, Predicate predicate) {
        Precondition.checkNotNull(iterator);
        Precondition.checkNotNull(predicate);
        while (iterator.hasNext()) {
            T t = iterator.next();
            if (!predicate.apply(t)) continue;
            return Optional.of(t);
        }
        return Optional.empty();
    }

    public static <T> int indexOf(Iterator<T> iterator, Predicate predicate) {
        Precondition.checkNotNull(predicate, "predicate");
        int i = 0;
        while (iterator.hasNext()) {
            T current = iterator.next();
            if (predicate.apply(current)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <T> T get(Iterator<T> iterator, int position) {
        IterUtil.checkNonnegative(position);
        int skipped = IterUtil.advance(iterator, position);
        if (!iterator.hasNext()) {
            throw new IndexOutOfBoundsException("position (" + position + ") must be less than the number of elements that remained (" + skipped + ")");
        }
        return iterator.next();
    }

    public static <T> T get(Iterator<? extends T> iterator, int position, T defaultValue) {
        IterUtil.checkNonnegative(position);
        IterUtil.advance(iterator, position);
        return IterUtil.getNext(iterator, defaultValue);
    }

    static void checkNonnegative(int position) {
        if (position < 0) {
            throw new IndexOutOfBoundsException("position (" + position + ") must not be negative");
        }
    }

    public static <T> T getNext(Iterator<? extends T> iterator, T defaultValue) {
        return iterator.hasNext() ? iterator.next() : defaultValue;
    }

    public static <T> T getLast(Iterator<T> iterator) {
        T current;
        do {
            current = iterator.next();
        } while (iterator.hasNext());
        return current;
    }

    public static <T> T getLast(Iterator<? extends T> iterator, T defaultValue) {
        return iterator.hasNext() ? IterUtil.getLast(iterator) : defaultValue;
    }

    public static int advance(Iterator<?> iterator, int numberToAdvance) {
        int i;
        Precondition.checkNotNull(iterator);
        Precondition.checkArgument(numberToAdvance >= 0, "numberToAdvance must be nonnegative");
        for (i = 0; i < numberToAdvance && iterator.hasNext(); ++i) {
            iterator.next();
        }
        return i;
    }

    public static <T> Iterator<T> limit(final Iterator<T> iterator, final int limitSize) {
        Precondition.checkNotNull(iterator);
        Precondition.checkArgument(limitSize >= 0, "limit is negative");
        return new Iterator<T>(){
            private int count;

            @Override
            public boolean hasNext() {
                return this.count < limitSize && iterator.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.count;
                return iterator.next();
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    public static void clear(Iterator<?> iterator) {
        Precondition.checkNotNull(iterator);
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    @CheckForNull
    public static <T> T find(Iterable<? extends T> iterable, Predicate<? super T> predicate, @CheckForNull T defaultValue) {
        return IterUtil.find(iterable.iterator(), predicate, defaultValue);
    }

    public static <T> T find(Iterable<T> iterable, Predicate<? super T> predicate) {
        return IterUtil.find(iterable.iterator(), predicate);
    }

    public static <T> T find(Iterator<T> iterator, Predicate<? super T> predicate) {
        Precondition.checkNotNull(iterator);
        Precondition.checkNotNull(predicate);
        while (iterator.hasNext()) {
            T t = iterator.next();
            if (!predicate.apply(t)) continue;
            return t;
        }
        throw new NoSuchElementException();
    }
}

