/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.comparator;

import com.whaleal.icefrog.core.lang.Precondition;
import java.util.Comparator;

public class InstanceComparator<T>
implements Comparator<T> {
    private final boolean atEndIfMiss;
    private final Class<?>[] instanceOrder;

    public InstanceComparator(Class<?> ... instanceOrder) {
        this(false, instanceOrder);
    }

    public InstanceComparator(boolean atEndIfMiss, Class<?> ... instanceOrder) {
        Precondition.notNull(instanceOrder, "'instanceOrder' array must not be null", new Object[0]);
        this.atEndIfMiss = atEndIfMiss;
        this.instanceOrder = instanceOrder;
    }

    @Override
    public int compare(T o1, T o2) {
        int i1 = this.getOrder(o1);
        int i2 = this.getOrder(o2);
        return Integer.compare(i1, i2);
    }

    private int getOrder(T object) {
        if (object != null) {
            for (int i = 0; i < this.instanceOrder.length; ++i) {
                if (!this.instanceOrder[i].isInstance(object)) continue;
                return i;
            }
        }
        return this.atEndIfMiss ? this.instanceOrder.length : -1;
    }
}

